/*
 * Decompiled with CFR 0.152.
 */
package ag.granular.tiff;

import ag.granular.io.ByteOrder;
import ag.granular.tiff.FieldType;
import ag.granular.tiff.FileDirectory;
import ag.granular.tiff.FileDirectoryEntry;
import ag.granular.tiff.Rasters;
import ag.granular.tiff.TIFFImage;
import ag.granular.tiff.TiffWriter$WhenMappings;
import ag.granular.tiff.compression.CompressionEncoder;
import ag.granular.tiff.compression.DeflateCompression;
import ag.granular.tiff.compression.LZWCompression;
import ag.granular.tiff.compression.PackbitsCompression;
import ag.granular.tiff.compression.RawCompression;
import ag.granular.tiff.io.ByteWriter;
import ag.granular.tiff.util.TiffException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J(\u0010\u0017\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0016\u0010\u0019\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a8\u0006\u001f"}, d2={"Lag/granular/tiff/TiffWriter;", "", "()V", "getEncoder", "Lag/granular/tiff/compression/CompressionEncoder;", "fileDirectory", "Lag/granular/tiff/FileDirectory;", "populateRasterEntries", "", "populateStripEntries", "writeFillerBytes", "writer", "Lag/granular/tiff/io/ByteWriter;", "count", "", "writeImageFileDirectories", "tiffImage", "Lag/granular/tiff/TIFFImage;", "writeRasters", "", "byteOrder", "Lag/granular/io/ByteOrder;", "offset", "writeStripRasters", "encoder", "writeTiff", "writeTiffToBytes", "writeValues", "", "entry", "Lag/granular/tiff/FileDirectoryEntry;", "tiffany"})
public final class TiffWriter {
    @NotNull
    public final byte[] writeTiffToBytes(@NotNull TIFFImage tiffImage) {
        Intrinsics.checkParameterIsNotNull((Object)tiffImage, (String)"tiffImage");
        ByteWriter writer = new ByteWriter(null, 1, null);
        byte[] bytes = this.writeTiffToBytes(writer, tiffImage);
        writer.close();
        return bytes;
    }

    @NotNull
    public final byte[] writeTiffToBytes(@NotNull ByteWriter writer, @NotNull TIFFImage tiffImage) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull((Object)tiffImage, (String)"tiffImage");
        this.writeTiff(writer, tiffImage);
        return writer.getBytes();
    }

    public final void writeTiff(@NotNull ByteWriter writer, @NotNull TIFFImage tiffImage) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull((Object)tiffImage, (String)"tiffImage");
        String byteOrder = writer.getByteOrder() == ByteOrder.BIG_ENDIAN ? "MM" : "II";
        writer.writeString(byteOrder);
        writer.writeUnsignedShort(42);
        writer.writeUnsignedInt(8);
        this.writeImageFileDirectories(writer, tiffImage);
    }

    /*
     * WARNING - void declaration
     */
    private final void writeImageFileDirectories(ByteWriter writer, TIFFImage tiffImage) {
        int n = 0;
        int n2 = tiffImage.getFileDirectories().size();
        while (n < n2) {
            void i;
            FileDirectory fileDirectory = tiffImage.getFileDirectories().get((int)i);
            this.populateRasterEntries(fileDirectory);
            int startOfDirectory = writer.size();
            long afterDirectory = (long)startOfDirectory + fileDirectory.size();
            long afterValues = (long)startOfDirectory + fileDirectory.sizeWithValues();
            writer.writeUnsignedShort(fileDirectory.numEntries());
            ArrayList<FileDirectoryEntry> entryValues = new ArrayList<FileDirectoryEntry>();
            long nextByte = afterDirectory;
            ArrayList<Long> valueBytesCheck = new ArrayList<Long>();
            if (fileDirectory.isTiled()) {
                throw (Throwable)new TiffException("Tiled images are not supported");
            }
            byte[] rastersBytes = this.writeRasters(writer.getByteOrder(), fileDirectory, afterValues);
            for (FileDirectoryEntry entry : fileDirectory.getEntries()) {
                writer.writeUnsignedShort(entry.getFieldTag().getId());
                writer.writeUnsignedShort(entry.getFieldType().getValue());
                writer.writeUnsignedInt(entry.getTypeCount());
                long valueBytes = (long)entry.getFieldType().getBytes() * entry.getTypeCount();
                if (valueBytes > (long)4) {
                    entryValues.add(entry);
                    writer.writeUnsignedInt(nextByte);
                    valueBytesCheck.add(nextByte);
                    nextByte += entry.sizeOfValues();
                    continue;
                }
                int bytesWritten = this.writeValues(writer, entry);
                if ((long)bytesWritten != valueBytes) {
                    throw (Throwable)new TiffException("Unexpected bytes written. Expected: " + valueBytes + ", Actual: " + bytesWritten);
                }
                this.writeFillerBytes(writer, (long)4 - valueBytes);
            }
            if (i + true == tiffImage.getFileDirectories().size()) {
                this.writeFillerBytes(writer, 4L);
            } else {
                long nextFileDirectory = afterValues + (long)rastersBytes.length;
                writer.writeUnsignedInt(nextFileDirectory);
            }
            int nextFileDirectory = 0;
            int n3 = ((Collection)entryValues).size();
            while (nextFileDirectory < n3) {
                long valueBytes;
                void entryIndex;
                Object e = entryValues.get((int)entryIndex);
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"entryValues[entryIndex]");
                FileDirectoryEntry entry = (FileDirectoryEntry)e;
                Object e2 = valueBytesCheck.get((int)entryIndex);
                Intrinsics.checkExpressionValueIsNotNull(e2, (String)"valueBytesCheck[entryIndex]");
                long entryValuesByte = ((Number)e2).longValue();
                if (entryValuesByte != (long)writer.size()) {
                    throw (Throwable)new TiffException("Entry values byte does not match the write location. Entry Values Byte: " + entryValuesByte + ", Current Byte: " + writer.size());
                }
                int bytesWritten = this.writeValues(writer, entry);
                if ((long)bytesWritten != (valueBytes = (long)entry.getFieldType().getBytes() * entry.getTypeCount())) {
                    throw (Throwable)new TiffException("Unexpected bytes written. Expected: " + valueBytes + ", Actual: " + bytesWritten);
                }
                ++entryIndex;
            }
            writer.writeBytes(rastersBytes);
            ++i;
        }
    }

    private final void populateRasterEntries(FileDirectory fileDirectory) {
        Rasters rasters = fileDirectory.getWriteRasters();
        if (rasters == null) {
            throw (Throwable)new TiffException("File Directory Writer Rasters is required to create a TIFF");
        }
        Rasters rasters2 = rasters;
        if (fileDirectory.isTiled()) {
            throw (Throwable)new TiffException("Tiled images are not supported");
        }
        this.populateStripEntries(fileDirectory);
    }

    private final void populateStripEntries(FileDirectory fileDirectory) {
        Number number;
        List<Long> list;
        boolean bl;
        int n;
        int stripsPerSample;
        Number number2 = fileDirectory.getRowsPerStrip();
        int rowsPerStrip = number2 != null ? number2.intValue() : 0;
        int imageHeight = fileDirectory.getImageHeight().intValue();
        int strips = stripsPerSample = (imageHeight + rowsPerStrip - 1) / rowsPerStrip;
        Integer n2 = fileDirectory.getPlanarConfiguration();
        int n3 = 2;
        if (n2 != null && n2 == n3) {
            strips *= fileDirectory.getSamplesPerPixel();
        }
        FileDirectory fileDirectory2 = fileDirectory;
        n3 = 0;
        boolean bl2 = false;
        ArrayList<Long> arrayList = new ArrayList<Long>(strips);
        boolean bl3 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = strips;
        while (n4 < n5) {
            n = n4++;
            bl = false;
            int n6 = n;
            list = arrayList;
            boolean bl4 = false;
            number = 0L;
            ((ArrayList)list).add(number);
        }
        list = arrayList;
        fileDirectory2.setStripOffsetsAsLongs(list);
        fileDirectory2 = fileDirectory;
        n3 = 0;
        bl2 = false;
        arrayList = new ArrayList(strips);
        bl3 = false;
        n4 = 0;
        n4 = 0;
        n5 = strips;
        while (n4 < n5) {
            n = n4++;
            bl = false;
            int it = n;
            list = arrayList;
            boolean bl5 = false;
            number = 0;
            ((ArrayList)list).add(number);
        }
        list = arrayList;
        fileDirectory2.setStripByteCounts(list);
    }

    private final byte[] writeRasters(ByteOrder byteOrder, FileDirectory fileDirectory, long offset) {
        Rasters rasters = fileDirectory.getWriteRasters();
        if (rasters == null) {
            throw (Throwable)new TiffException("File Directory Writer Rasters is required to create a TIFF");
        }
        Rasters rasters2 = rasters;
        CompressionEncoder encoder = this.getEncoder(fileDirectory);
        ByteWriter writer = new ByteWriter(byteOrder);
        if (fileDirectory.isTiled()) {
            throw (Throwable)new TiffException("Tiled images are not supported");
        }
        this.writeStripRasters(writer, fileDirectory, offset, encoder);
        byte[] bytes = writer.getBytes();
        writer.close();
        return bytes;
    }

    /*
     * WARNING - void declaration
     */
    private final void writeStripRasters(ByteWriter writer, FileDirectory fileDirectory, long offset, CompressionEncoder encoder) {
        int stripsPerSample;
        long offset2 = offset;
        Rasters rasters = fileDirectory.getWriteRasters();
        if (rasters == null) {
            Intrinsics.throwNpe();
        }
        Rasters rasters2 = rasters;
        Number number = fileDirectory.getRowsPerStrip();
        if (number == null) {
            Intrinsics.throwNpe();
        }
        int rowsPerStrip = number.intValue();
        int maxY = fileDirectory.getImageHeight().intValue();
        int strips = stripsPerSample = (maxY + rowsPerStrip - 1) / rowsPerStrip;
        Integer n = fileDirectory.getPlanarConfiguration();
        int n2 = 2;
        if (n != null && n == n2) {
            strips *= fileDirectory.getSamplesPerPixel();
        }
        ArrayList<Long> stripOffsets = new ArrayList<Long>();
        ArrayList<Integer> stripByteCounts = new ArrayList<Integer>();
        int n3 = 0;
        int n4 = strips;
        while (n3 < n4) {
            void strip;
            int startingY = 0;
            Integer sample = null;
            Integer n5 = fileDirectory.getPlanarConfiguration();
            int n6 = 2;
            if (n5 != null && n5 == n6) {
                sample = (int)(strip / stripsPerSample);
                startingY = strip % stripsPerSample * rowsPerStrip;
            } else {
                startingY = strip * rowsPerStrip;
            }
            ByteWriter stripWriter = new ByteWriter(writer.getByteOrder());
            int n7 = startingY + rowsPerStrip;
            int n8 = 0;
            int endingY = Math.min(n7, maxY);
            n7 = startingY;
            n8 = endingY;
            while (n7 < n8) {
                void y;
                byte[] rowBytes = null;
                rowBytes = sample != null ? rasters2.getSampleRow((int)y, sample, writer.getByteOrder()) : rasters2.getPixelRow((int)y, writer.getByteOrder());
                if (encoder.rowEncoding()) {
                    if (rowBytes == null) {
                        Intrinsics.throwNpe();
                    }
                    rowBytes = encoder.encode(rowBytes, writer.getByteOrder());
                }
                if (rowBytes == null) {
                    Intrinsics.throwNpe();
                }
                stripWriter.writeBytes(rowBytes);
                ++y;
            }
            byte[] stripBytes = stripWriter.getBytes();
            stripWriter.close();
            if (!encoder.rowEncoding()) {
                stripBytes = encoder.encode(stripBytes, writer.getByteOrder());
            }
            writer.writeBytes(stripBytes);
            int bytesWritten = stripBytes.length;
            stripByteCounts.add(bytesWritten);
            stripOffsets.add(offset2);
            offset2 += (long)bytesWritten;
            ++strip;
        }
        fileDirectory.setStripOffsetsAsLongs((List<Long>)stripOffsets);
        fileDirectory.setStripByteCounts((List<Integer>)stripByteCounts);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final CompressionEncoder getEncoder(FileDirectory fileDirectory) {
        CompressionEncoder encoder = null;
        Integer compression = fileDirectory.getCompression();
        if (compression == null) {
            compression = 1;
        }
        Integer n = compression;
        int n2 = 1;
        if (n == n2) {
            return new RawCompression();
        }
        n2 = 2;
        if (n == n2) {
            throw (Throwable)new TiffException("CCITT Huffman compression not supported: " + compression);
        }
        n2 = 3;
        if (n == n2) {
            throw (Throwable)new TiffException("T4-encoding compression not supported: " + compression);
        }
        n2 = 4;
        if (n == n2) {
            throw (Throwable)new TiffException("T6-encoding compression not supported: " + compression);
        }
        n2 = 5;
        if (n == n2) {
            return new LZWCompression();
        }
        n2 = 6;
        if (n == n2) throw (Throwable)new TiffException("JPEG compression not supported: " + compression);
        n2 = 7;
        if (n == n2) {
            throw (Throwable)new TiffException("JPEG compression not supported: " + compression);
        }
        n2 = 8;
        if (n == n2) return new DeflateCompression();
        n2 = 32946;
        if (n == n2) {
            return new DeflateCompression();
        }
        n2 = 32773;
        if (n != n2) throw (Throwable)new TiffException("Unknown compression method identifier: " + compression);
        return new PackbitsCompression();
    }

    /*
     * WARNING - void declaration
     */
    private final void writeFillerBytes(ByteWriter writer, long count) {
        long l = 0L;
        long l2 = count;
        while (l < l2) {
            void i;
            writer.writeUnsignedByte((short)0);
            ++i;
        }
    }

    private final int writeValues(ByteWriter writer, FileDirectoryEntry entry) {
        List list;
        if (entry.getTypeCount() == 1L && !entry.getFieldTag().isArray() && entry.getFieldType() != FieldType.RATIONAL && entry.getFieldType() != FieldType.SRATIONAL) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            boolean bl = false;
            boolean bl2 = false;
            ArrayList<Object> $this$apply = arrayList;
            boolean bl3 = false;
            $this$apply.add(entry.getValues());
            list = arrayList;
        } else {
            Object object = entry.getValues();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<kotlin.Any>");
            }
            list = (List)object;
        }
        List valuesList = list;
        int bytesWritten = 0;
        block13: for (Object value : valuesList) {
            switch (TiffWriter$WhenMappings.$EnumSwitchMapping$0[entry.getFieldType().ordinal()]) {
                case 1: {
                    Object e = value;
                    if (e == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                    }
                    if ((long)(bytesWritten += writer.writeString((String)e)) >= entry.getTypeCount()) continue block13;
                    long fillerBytes = entry.getTypeCount() - (long)bytesWritten;
                    this.writeFillerBytes(writer, fillerBytes);
                    bytesWritten += (int)fillerBytes;
                    continue block13;
                }
                case 2: 
                case 3: {
                    Object e = value;
                    if (e == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Short");
                    }
                    writer.writeUnsignedByte((Short)e);
                    ++bytesWritten;
                    continue block13;
                }
                case 4: {
                    Object e = value;
                    if (e == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Byte");
                    }
                    writer.writeByte((Byte)e);
                    ++bytesWritten;
                    continue block13;
                }
                case 5: {
                    Object e = value;
                    if (e == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                    }
                    writer.writeUnsignedShort((Integer)e);
                    bytesWritten += 2;
                    continue block13;
                }
                case 6: {
                    Object e = value;
                    if (e == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Short");
                    }
                    writer.writeShort((Short)e);
                    bytesWritten += 2;
                    continue block13;
                }
                case 7: {
                    Object e = value;
                    if (e == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Long");
                    }
                    writer.writeUnsignedInt((Long)e);
                    bytesWritten += 4;
                    continue block13;
                }
                case 8: {
                    Object e = value;
                    if (e == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                    }
                    writer.writeInt((Integer)e);
                    bytesWritten += 4;
                    continue block13;
                }
                case 9: {
                    Object e = value;
                    if (e == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Long");
                    }
                    writer.writeUnsignedInt((Long)e);
                    bytesWritten += 4;
                    continue block13;
                }
                case 10: {
                    Object e = value;
                    if (e == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                    }
                    writer.writeInt((Integer)e);
                    bytesWritten += 4;
                    continue block13;
                }
                case 11: {
                    Object e = value;
                    if (e == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
                    }
                    writer.writeFloat(((Float)e).floatValue());
                    bytesWritten += 4;
                    continue block13;
                }
                case 12: {
                    Object e = value;
                    if (e == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Double");
                    }
                    writer.writeDouble((Double)e);
                    bytesWritten += 8;
                    continue block13;
                }
            }
            throw (Throwable)new TiffException("Invalid field type: " + (Object)((Object)entry.getFieldType()));
        }
        return bytesWritten;
    }
}

