/*
 * Decompiled with CFR 0.152.
 */
package ag.granular.tiff.compression;

import ag.granular.io.ByteOrder;
import ag.granular.tiff.compression.CompressionDecoder;
import ag.granular.tiff.compression.CompressionEncoder;
import ag.granular.tiff.util.TiffException;
import java.io.ByteArrayOutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\nH\u0002J\b\u0010\u000f\u001a\u00020\fH\u0002J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\nH\u0002J\b\u0010\u0017\u001a\u00020\fH\u0002J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0005H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001f"}, d2={"Lag/granular/tiff/compression/LZWCompression;", "Lag/granular/tiff/compression/CompressionDecoder;", "Lag/granular/tiff/compression/CompressionEncoder;", "()V", "byteLength", "", "maxCode", "position", "table", "", "", "addToTable", "", "value", "code", "checkByteLength", "decode", "bytes", "byteOrder", "Lag/granular/io/ByteOrder;", "encode", "getByte", "getNextCode", "initializeTable", "readUnsignedByte", "Lkotlin/UByte;", "offset", "([BI)B", "rowEncoding", "", "Companion", "tiffany"})
public final class LZWCompression
implements CompressionDecoder,
CompressionEncoder {
    private final Map<Integer, byte[]> table;
    private int maxCode;
    private int byteLength;
    private int position;
    private static final int CLEAR_CODE = 256;
    private static final int EOI_CODE = 257;
    private static final int MIN_BITS = 9;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public byte[] decode(@NotNull byte[] bytes, @NotNull ByteOrder byteOrder) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        Intrinsics.checkParameterIsNotNull((Object)((Object)byteOrder), (String)"byteOrder");
        ByteArrayOutputStream decodedStream = new ByteArrayOutputStream();
        this.initializeTable();
        this.position = 0;
        int oldCode = 0;
        int code = this.getNextCode(bytes);
        while (code != EOI_CODE) {
            byte[] value;
            if (code == CLEAR_CODE) {
                this.initializeTable();
                code = this.getNextCode(bytes);
                while (code == CLEAR_CODE) {
                    code = this.getNextCode(bytes);
                }
                if (code == EOI_CODE) break;
                if (code > CLEAR_CODE) {
                    throw (Throwable)new TiffException("Corrupted code at scan line: " + code);
                }
                value = this.table.get(code);
                if (value == null) {
                    Intrinsics.throwNpe();
                }
                decodedStream.write(value);
                oldCode = code;
            } else {
                value = this.table.get(code);
                if (value != null) {
                    decodedStream.write(value);
                    byte[] byArray = this.table.get(oldCode);
                    if (byArray == null) {
                        Intrinsics.throwNpe();
                    }
                    byte[] byArray2 = this.table.get(code);
                    if (byArray2 == null) {
                        Intrinsics.throwNpe();
                    }
                    byte[] newValue = ArraysKt.plus((byte[])byArray, (byte)byArray2[0]);
                    this.addToTable(newValue);
                    oldCode = code;
                } else {
                    byte[] oldValue = this.table.get(oldCode);
                    if (oldValue == null) {
                        Intrinsics.throwNpe();
                    }
                    byte[] newValue = ArraysKt.plus((byte[])oldValue, (byte)oldValue[0]);
                    decodedStream.write(newValue);
                    this.addToTable(code, newValue);
                    oldCode = code;
                }
            }
            code = this.getNextCode(bytes);
        }
        byte[] byArray = decodedStream.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"decodedStream.toByteArray()");
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeTable() {
        this.table.clear();
        int n = 0;
        int n2 = 257;
        while (n <= n2) {
            byte[] byArray;
            void i;
            int n3 = 1;
            Integer n4 = (int)i;
            Map<Integer, byte[]> map = this.table;
            byte[] byArray2 = new byte[n3];
            int n5 = 0;
            while (n5 < n3) {
                byte by;
                int n6 = n5;
                int n7 = n5++;
                byArray = byArray2;
                boolean bl = false;
                byArray[n7] = by = (byte)i;
            }
            byArray = byArray2;
            map.put(n4, byArray);
            ++i;
        }
        this.maxCode = 257;
        this.byteLength = MIN_BITS;
    }

    private final void checkByteLength() {
        double d = 2.0;
        double d2 = this.byteLength;
        double d3 = this.maxCode;
        boolean bl = false;
        double d4 = Math.pow(d, d2);
        if (d3 >= d4 - (double)2) {
            int n = this.byteLength;
            this.byteLength = n + 1;
        }
    }

    private final void addToTable(byte[] value) {
        this.addToTable(this.maxCode + 1, value);
    }

    private final void addToTable(int code, byte[] value) {
        int n;
        this.table.put(code, value);
        int n2 = this.maxCode;
        LZWCompression lZWCompression = this;
        boolean bl = false;
        lZWCompression.maxCode = n = Math.max(n2, code);
        this.checkByteLength();
    }

    private final int getNextCode(byte[] bytes) {
        int nextByte = this.getByte(bytes);
        this.position += this.byteLength;
        return nextByte;
    }

    private final int getByte(byte[] bytes) {
        int n;
        int d = this.position % 8;
        double d2 = (double)this.position / 8.0;
        boolean bl = false;
        int a = (int)Math.floor(d2);
        int de = 8 - d;
        int ef = this.position + this.byteLength - (a + 1) * 8;
        int fg = 8 * (a + 2) - (this.position + this.byteLength);
        int dg = (a + 2) * 8 - this.position;
        int n2 = 0;
        byte by = 0;
        fg = Math.max(n2, fg);
        if (a >= bytes.length) {
            String string = "End of data reached without an end of input code";
            by = 0;
            System.out.println((Object)string);
            return EOI_CODE;
        }
        by = this.readUnsignedByte(bytes, a);
        boolean bl2 = false;
        double d3 = 2.0;
        double d4 = 8 - d;
        int n3 = by & 0xFF;
        boolean bl3 = false;
        double d5 = Math.pow(d3, d4);
        int chunk1 = n3 & (int)(d5 - 1.0);
        int chunks = chunk1 <<= this.byteLength - de;
        if (a + 1 < bytes.length) {
            byte by2 = this.readUnsignedByte(bytes, a + 1);
            n = 0;
            int chunk2 = (by2 & 0xFF) >>> fg;
            by2 = 0;
            n = this.byteLength - dg;
            n3 = chunk2;
            bl3 = false;
            int n4 = Math.max(by2, n);
            chunk2 = n3 << n4;
            chunks += chunk2;
        }
        if (ef > 8 && a + 2 < bytes.length) {
            int hi = (a + 3) * 8 - (this.position + this.byteLength);
            n = this.readUnsignedByte(bytes, a + 2);
            bl3 = false;
            int chunk3 = (n & 0xFF) >>> hi;
            chunks += chunk3;
        }
        return chunks;
    }

    private final byte readUnsignedByte(byte[] bytes, int offset) {
        byte by = bytes[offset];
        boolean bl = false;
        return UByte.constructor-impl((byte)by);
    }

    @Override
    public boolean rowEncoding() {
        return false;
    }

    @Override
    @NotNull
    public byte[] encode(@NotNull byte[] bytes, @NotNull ByteOrder byteOrder) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        Intrinsics.checkParameterIsNotNull((Object)((Object)byteOrder), (String)"byteOrder");
        throw (Throwable)new TiffException("LZW encoder is not yet implemented");
    }

    public LZWCompression() {
        Map map;
        LZWCompression lZWCompression = this;
        boolean bl = false;
        lZWCompression.table = map = (Map)new LinkedHashMap();
    }

    static {
        CLEAR_CODE = 256;
        EOI_CODE = 257;
        MIN_BITS = 9;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lag/granular/tiff/compression/LZWCompression$Companion;", "", "()V", "CLEAR_CODE", "", "EOI_CODE", "MIN_BITS", "tiffany"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

