/*
 * Decompiled with CFR 0.152.
 */
package ag.granular.tiff.compression;

import ag.granular.io.ByteOrder;
import ag.granular.tiff.compression.CompressionDecoder;
import ag.granular.tiff.compression.CompressionEncoder;
import ag.granular.tiff.io.ByteReader;
import ag.granular.tiff.util.TiffException;
import java.io.ByteArrayOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lag/granular/tiff/compression/PackbitsCompression;", "Lag/granular/tiff/compression/CompressionDecoder;", "Lag/granular/tiff/compression/CompressionEncoder;", "()V", "decode", "", "bytes", "byteOrder", "Lag/granular/io/ByteOrder;", "encode", "rowEncoding", "", "tiffany"})
public final class PackbitsCompression
implements CompressionDecoder,
CompressionEncoder {
    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public byte[] decode(@NotNull byte[] bytes, @NotNull ByteOrder byteOrder) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        Intrinsics.checkParameterIsNotNull((Object)((Object)byteOrder), (String)"byteOrder");
        ByteReader reader = new ByteReader(bytes, byteOrder);
        ByteArrayOutputStream decodedStream = new ByteArrayOutputStream();
        block0: while (reader.hasByte()) {
            byte by;
            short next;
            byte header = reader.readByte();
            if (header == -128) continue;
            if (header < 0) {
                next = reader.readUnsignedByte();
                by = 0;
                byte by2 = header = -header;
                if (by > by2) continue;
                while (true) {
                    void i;
                    decodedStream.write(next);
                    if (i == by2) continue block0;
                    ++i;
                }
            }
            next = 0;
            by = header;
            if (next > by) continue;
            while (true) {
                void i;
                decodedStream.write(reader.readUnsignedByte());
                if (i == by) continue block0;
                ++i;
            }
        }
        byte[] byArray = decodedStream.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"decodedStream.toByteArray()");
        return byArray;
    }

    @Override
    public boolean rowEncoding() {
        return true;
    }

    @Override
    @NotNull
    public byte[] encode(@NotNull byte[] bytes, @NotNull ByteOrder byteOrder) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        Intrinsics.checkParameterIsNotNull((Object)((Object)byteOrder), (String)"byteOrder");
        throw (Throwable)new TiffException("Packbits encoder is not yet implemented");
    }
}

