/*
 * Decompiled with CFR 0.152.
 */
package ag.granular.tiff.io;

import ag.granular.io.ByteBuffer;
import ag.granular.io.ByteOrder;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0011\u001a\u00020\fJ\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fJ\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\fJ\u0016\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\fJ\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\fJ\u000e\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\fJ\u0016\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\fJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\fJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\fJ\u0006\u0010\u001f\u001a\u00020\fJ\u000e\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fJ\u0006\u0010 \u001a\u00020!J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\fJ\u0010\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001a\u001a\u00020\fJ\u0018\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\fJ\u0006\u0010$\u001a\u00020!J\u000e\u0010$\u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\fJ\u0006\u0010%\u001a\u00020&J\u000e\u0010%\u001a\u00020&2\u0006\u0010\u0014\u001a\u00020\fJ\u0006\u0010'\u001a\u00020\fJ\u000e\u0010'\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fJ1\u0010(\u001a\u0002H)\"\u0004\b\u0000\u0010)2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010*\u001a\u00020\f2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H)0,H\u0002\u00a2\u0006\u0002\u0010-R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006."}, d2={"Lag/granular/tiff/io/ByteReader;", "", "bytes", "", "byteReaderOrder", "Lag/granular/io/ByteOrder;", "([BLag/granular/io/ByteOrder;)V", "getByteReaderOrder", "()Lag/granular/io/ByteOrder;", "setByteReaderOrder", "(Lag/granular/io/ByteOrder;)V", "nextByte", "", "getNextByte", "()I", "setNextByte", "(I)V", "byteLength", "hasByte", "", "offset", "hasBytes", "count", "readByte", "", "readBytes", "num", "readDouble", "", "readFloat", "", "readInt", "readShort", "", "readString", "", "readUnsignedByte", "readUnsignedInt", "", "readUnsignedShort", "verifyRemainingBytes", "T", "bytesToRead", "block", "Lkotlin/Function0;", "(IILkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "tiffany"})
public final class ByteReader {
    private int nextByte;
    private final byte[] bytes;
    @NotNull
    private ByteOrder byteReaderOrder;

    public final int getNextByte() {
        return this.nextByte;
    }

    public final void setNextByte(int n) {
        this.nextByte = n;
    }

    public final boolean hasByte() {
        return this.hasBytes(1);
    }

    public final boolean hasByte(int offset) {
        return this.hasBytes(offset, 1);
    }

    public final boolean hasBytes(int count) {
        return this.hasBytes(this.nextByte, count);
    }

    public final boolean hasBytes(int offset, int count) {
        return offset + count <= this.bytes.length;
    }

    @Nullable
    public final String readString(int num) {
        String value = this.readString(this.nextByte, num);
        this.nextByte += num;
        return value;
    }

    @Nullable
    public final String readString(int offset, int num) {
        return (String)this.verifyRemainingBytes(offset, num, (Function0)new Function0<String>(this, num, offset){
            final /* synthetic */ ByteReader this$0;
            final /* synthetic */ int $num;
            final /* synthetic */ int $offset;

            @Nullable
            public final String invoke() {
                return this.$num != 1 || ByteReader.access$getBytes$p(this.this$0)[this.$offset] != 0 ? StringsKt.decodeToString$default((byte[])ByteReader.access$getBytes$p(this.this$0), (int)this.$offset, (int)(this.$offset + this.$num), (boolean)false, (int)4, null) : null;
            }
            {
                this.this$0 = byteReader;
                this.$num = n;
                this.$offset = n2;
                super(0);
            }
        });
    }

    public final byte readByte() {
        byte value = this.readByte(this.nextByte);
        int n = this.nextByte;
        this.nextByte = n + 1;
        return value;
    }

    public final byte readByte(int offset) {
        return ((Number)this.verifyRemainingBytes(offset, 1, (Function0)new Function0<Byte>(this, offset){
            final /* synthetic */ ByteReader this$0;
            final /* synthetic */ int $offset;

            public final byte invoke() {
                return ByteReader.access$getBytes$p(this.this$0)[this.$offset];
            }
            {
                this.this$0 = byteReader;
                this.$offset = n;
                super(0);
            }
        })).byteValue();
    }

    public final short readUnsignedByte() {
        short value = this.readUnsignedByte(this.nextByte);
        int n = this.nextByte;
        this.nextByte = n + 1;
        return value;
    }

    public final short readUnsignedByte(int offset) {
        return (short)(this.readByte(offset) & 0xFF);
    }

    @NotNull
    public final byte[] readBytes(int num) {
        byte[] readBytes2 = this.readBytes(this.nextByte, num);
        this.nextByte += num;
        return readBytes2;
    }

    @NotNull
    public final byte[] readBytes(int offset, int num) {
        return (byte[])this.verifyRemainingBytes(offset, num, (Function0)new Function0<byte[]>(this, offset, num){
            final /* synthetic */ ByteReader this$0;
            final /* synthetic */ int $offset;
            final /* synthetic */ int $num;

            @NotNull
            public final byte[] invoke() {
                byte[] byArray = ByteReader.access$getBytes$p(this.this$0);
                int n = this.$offset;
                int n2 = this.$offset + this.$num;
                boolean bl = false;
                return ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
            }
            {
                this.this$0 = byteReader;
                this.$offset = n;
                this.$num = n2;
                super(0);
            }
        });
    }

    public final short readShort() {
        short value = this.readShort(this.nextByte);
        this.nextByte += 2;
        return value;
    }

    public final short readShort(int offset) {
        return ((Number)this.verifyRemainingBytes(offset, 2, (Function0)new Function0<Short>(this, offset){
            final /* synthetic */ ByteReader this$0;
            final /* synthetic */ int $offset;

            public final short invoke() {
                return ByteBuffer.Companion.wrap(ByteReader.access$getBytes$p(this.this$0), this.$offset, 2).order(this.this$0.getByteReaderOrder()).getShort();
            }
            {
                this.this$0 = byteReader;
                this.$offset = n;
                super(0);
            }
        })).shortValue();
    }

    public final int readUnsignedShort() {
        int value = this.readUnsignedShort(this.nextByte);
        this.nextByte += 2;
        return value;
    }

    public final int readUnsignedShort(int offset) {
        return this.readShort(offset) & 0xFFFF;
    }

    public final int readInt() {
        int value = this.readInt(this.nextByte);
        this.nextByte += 4;
        return value;
    }

    public final int readInt(int offset) {
        return ((Number)this.verifyRemainingBytes(offset, 4, (Function0)new Function0<Integer>(this, offset){
            final /* synthetic */ ByteReader this$0;
            final /* synthetic */ int $offset;

            public final int invoke() {
                return ByteBuffer.Companion.wrap(ByteReader.access$getBytes$p(this.this$0), this.$offset, 4).order(this.this$0.getByteReaderOrder()).getInt();
            }
            {
                this.this$0 = byteReader;
                this.$offset = n;
                super(0);
            }
        })).intValue();
    }

    public final long readUnsignedInt() {
        long value = this.readUnsignedInt(this.nextByte);
        this.nextByte += 4;
        return value;
    }

    public final long readUnsignedInt(int offset) {
        return (long)this.readInt(offset) & 0xFFFFFFFFL;
    }

    public final float readFloat() {
        float value = this.readFloat(this.nextByte);
        this.nextByte += 4;
        return value;
    }

    public final float readFloat(int offset) {
        return ((Number)this.verifyRemainingBytes(offset, 4, (Function0)new Function0<Float>(this, offset){
            final /* synthetic */ ByteReader this$0;
            final /* synthetic */ int $offset;

            public final float invoke() {
                return ByteBuffer.Companion.wrap(ByteReader.access$getBytes$p(this.this$0), this.$offset, 4).order(this.this$0.getByteReaderOrder()).getFloat();
            }
            {
                this.this$0 = byteReader;
                this.$offset = n;
                super(0);
            }
        })).floatValue();
    }

    public final double readDouble() {
        double value = this.readDouble(this.nextByte);
        this.nextByte += 8;
        return value;
    }

    public final double readDouble(int offset) {
        return ((Number)this.verifyRemainingBytes(offset, 8, (Function0)new Function0<Double>(this, offset){
            final /* synthetic */ ByteReader this$0;
            final /* synthetic */ int $offset;

            public final double invoke() {
                return ByteBuffer.Companion.wrap(ByteReader.access$getBytes$p(this.this$0), this.$offset, 8).order(this.this$0.getByteReaderOrder()).getDouble();
            }
            {
                this.this$0 = byteReader;
                this.$offset = n;
                super(0);
            }
        })).doubleValue();
    }

    public final int byteLength() {
        return this.bytes.length;
    }

    private final <T> T verifyRemainingBytes(int offset, int bytesToRead, Function0<? extends T> block) {
        if (offset + bytesToRead > this.bytes.length) {
            throw (Throwable)new IllegalStateException("No more remaining bytes to read. Total Bytes: " + this.bytes.length + ", Byte offset: " + offset + ", Attempted to read: " + bytesToRead);
        }
        return (T)block.invoke();
    }

    @NotNull
    public final ByteOrder getByteReaderOrder() {
        return this.byteReaderOrder;
    }

    public final void setByteReaderOrder(@NotNull ByteOrder byteOrder) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)byteOrder), (String)"<set-?>");
        this.byteReaderOrder = byteOrder;
    }

    public ByteReader(@NotNull byte[] bytes, @NotNull ByteOrder byteReaderOrder) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        Intrinsics.checkParameterIsNotNull((Object)((Object)byteReaderOrder), (String)"byteReaderOrder");
        this.bytes = bytes;
        this.byteReaderOrder = byteReaderOrder;
    }

    public /* synthetic */ ByteReader(byte[] byArray, ByteOrder byteOrder, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        }
        this(byArray, byteOrder);
    }

    public static final /* synthetic */ byte[] access$getBytes$p(ByteReader $this) {
        return $this.bytes;
    }
}

