/*
 * Decompiled with CFR 0.152.
 */
package ag.granular.tiff;

import ag.granular.tiff.FieldTagType;
import ag.granular.tiff.FieldTagTypeMapping$WhenMappings;
import ag.granular.tiff.FieldType;
import ag.granular.tiff.FileDirectoryEntry;
import ag.granular.tiff.compression.CompressionDecoder;
import ag.granular.tiff.compression.DeflateCompression;
import ag.granular.tiff.compression.LZWCompression;
import ag.granular.tiff.compression.PackbitsCompression;
import ag.granular.tiff.compression.RawCompression;
import ag.granular.tiff.io.ByteReader;
import ag.granular.tiff.util.TiffException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u001d\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b)\u0018\u00002\u00020\u0001B\u001d\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020\u0004J\u0016\u0010U\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010V\u001a\u00020\tH\u0002J\u0016\u0010W\u001a\b\u0012\u0004\u0012\u00020G0\b2\u0006\u0010V\u001a\u00020GH\u0002J\u0011\u0010X\u001a\u00020\u00042\u0006\u0010Y\u001a\u00020\u001dH\u0086\u0002J\u001d\u0010Z\u001a\u0004\u0018\u0001H[\"\u0004\b\u0000\u0010[2\u0006\u0010Y\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010\\J\u0012\u0010]\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00040^J\u000e\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020\tJ\u0015\u0010b\u001a\u0004\u0018\u00010\t2\u0006\u0010Y\u001a\u00020\u001d\u00a2\u0006\u0002\u0010cJ\u0016\u0010d\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010Y\u001a\u00020\u001dJ\u0016\u0010e\u001a\n\u0012\u0004\u0012\u00020G\u0018\u00010\b2\u0006\u0010Y\u001a\u00020\u001dJ\u0015\u0010f\u001a\u0004\u0018\u00010\t2\u0006\u0010Y\u001a\u00020\u001d\u00a2\u0006\u0002\u0010cJ\u0010\u0010g\u001a\u0004\u0018\u00010 2\u0006\u0010Y\u001a\u00020\u001dJ\u0016\u0010h\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\b2\u0006\u0010Y\u001a\u00020\u001dJ\r\u00102\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010i\u001a\u00020\t2\u0006\u0010a\u001a\u00020\tJ\u0010\u0010j\u001a\u0004\u0018\u00010k2\u0006\u0010Y\u001a\u00020\u001dJ\u0006\u0010l\u001a\u00020\tJ\u0018\u0010m\u001a\u00020 2\u0006\u0010n\u001a\u00020o2\u0006\u0010p\u001a\u00020`H\u0002J\u000e\u0010\f\u001a\u00020S2\u0006\u0010\u0007\u001a\u00020\tJ\u000e\u0010\u0013\u001a\u00020S2\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010q\u001a\u00020S2\u0006\u0010\u0014\u001a\u00020\tJ(\u0010r\u001a\u00020S2\u0006\u0010Y\u001a\u00020\u001d2\u0006\u0010p\u001a\u00020`2\u0006\u0010s\u001a\u00020G2\u0006\u0010t\u001a\u00020\u0001H\u0002J\u000e\u0010u\u001a\u00020S2\u0006\u0010v\u001a\u00020\tJ\u000e\u0010w\u001a\u00020S2\u0006\u0010v\u001a\u00020GJ\u000e\u0010x\u001a\u00020S2\u0006\u0010y\u001a\u00020\tJ\u000e\u0010z\u001a\u00020S2\u0006\u0010y\u001a\u00020GJ\u000e\u0010{\u001a\u00020S2\u0006\u0010/\u001a\u00020\tJ\u000e\u0010|\u001a\u00020S2\u0006\u00101\u001a\u00020\tJ\u000e\u0010}\u001a\u00020S2\u0006\u00103\u001a\u00020\tJ\u000e\u0010~\u001a\u00020S2\u0006\u00105\u001a\u00020\tJ\u000e\u0010\u007f\u001a\u00020S2\u0006\u00105\u001a\u00020GJ\u000e\u00109\u001a\u00020S2\u0006\u00107\u001a\u00020\tJ\u0017\u0010\u0080\u0001\u001a\u00020S2\u0006\u0010Y\u001a\u00020\u001d2\u0006\u0010V\u001a\u00020kJ\u0010\u0010\u0081\u0001\u001a\u00020S2\u0007\u0010\u0082\u0001\u001a\u00020\tJ\u0010\u0010\u0081\u0001\u001a\u00020S2\u0007\u0010\u0082\u0001\u001a\u00020GJ\u0015\u0010\u0081\u0001\u001a\u00020S2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0015\u0010\u0083\u0001\u001a\u00020S2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020G0\bJ\u0010\u0010\u0084\u0001\u001a\u00020S2\u0007\u0010\u0085\u0001\u001a\u00020\tJ\u0010\u0010\u0084\u0001\u001a\u00020S2\u0007\u0010\u0085\u0001\u001a\u00020GJ\u0015\u0010\u0084\u0001\u001a\u00020S2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0015\u0010\u0086\u0001\u001a\u00020S2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020G0\bJ\u0010\u0010\u0087\u0001\u001a\u00020S2\u0007\u0010\u0088\u0001\u001a\u00020\tJ\u0010\u0010\u0087\u0001\u001a\u00020S2\u0007\u0010\u0088\u0001\u001a\u00020GJ\u0015\u0010\u0087\u0001\u001a\u00020S2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0015\u0010\u0089\u0001\u001a\u00020S2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020G0\bJ\u000f\u0010\u008a\u0001\u001a\u00020S2\u0006\u0010D\u001a\u00020\tJ\u000f\u0010\u008b\u0001\u001a\u00020S2\u0006\u0010D\u001a\u00020GJ\u000f\u0010I\u001a\u00020S2\u0007\u0010\u008c\u0001\u001a\u00020GJ\u000f\u0010\u008d\u0001\u001a\u00020S2\u0006\u0010J\u001a\u00020\tJ\u000f\u0010\u008e\u0001\u001a\u00020S2\u0006\u0010J\u001a\u00020GJ\u0017\u0010\u008f\u0001\u001a\u00020S2\u0006\u0010Y\u001a\u00020\u001d2\u0006\u0010V\u001a\u00020\tJ\u001d\u0010\u0090\u0001\u001a\u00020S2\u0006\u0010Y\u001a\u00020\u001d2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0017\u0010\u0091\u0001\u001a\u00020S2\u0006\u0010Y\u001a\u00020\u001d2\u0006\u0010V\u001a\u00020GJ\u001d\u0010\u0092\u0001\u001a\u00020S2\u0006\u0010Y\u001a\u00020\u001d2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020G0\bJ\u000e\u0010N\u001a\u00020S2\u0006\u0010L\u001a\u00020GJ\u000e\u0010Q\u001a\u00020S2\u0006\u0010O\u001a\u00020GJ\u0007\u0010\u0093\u0001\u001a\u00020GJ\u0007\u0010\u0094\u0001\u001a\u00020GJ+\u0010\u0095\u0001\u001a\u00020\t2\u000e\u0010t\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0007\u0010\u0096\u0001\u001a\u00020\t2\u0007\u0010\u0097\u0001\u001a\u00020\tH\u0002R4\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R4\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u0013\u0010\u0014\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001b\u001a\u001e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00040\u001cj\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u0004`\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010'R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010+\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0016R\u0013\u0010-\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0016R\u0013\u0010/\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0016R\u0011\u00101\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0010R\u0013\u00103\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u0016R\u0013\u00105\u001a\u0004\u0018\u00010 8F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\"R4\u00107\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u000e\u00107\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b8\u0010\u000b\"\u0004\b9\u0010\rR$\u0010:\u001a\u00020\t2\u0006\u0010:\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b;\u0010\u0010\"\u0004\b<\u0010=R\u0019\u0010>\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010\u000bR\u0019\u0010@\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\bA\u0010\u000bR\u0019\u0010B\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\bC\u0010\u000bR\u0013\u0010D\u001a\u0004\u0018\u00010 8F\u00a2\u0006\u0006\u001a\u0004\bE\u0010\"R4\u0010F\u001a\n\u0012\u0004\u0012\u00020G\u0018\u00010\b2\u000e\u0010F\u001a\n\u0012\u0004\u0012\u00020G\u0018\u00010\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bH\u0010\u000b\"\u0004\bI\u0010\rR\u0013\u0010J\u001a\u0004\u0018\u00010 8F\u00a2\u0006\u0006\u001a\u0004\bK\u0010\"R4\u0010L\u001a\n\u0012\u0004\u0012\u00020G\u0018\u00010\b2\u000e\u0010L\u001a\n\u0012\u0004\u0012\u00020G\u0018\u00010\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bM\u0010\u000b\"\u0004\bN\u0010\rR4\u0010O\u001a\n\u0012\u0004\u0012\u00020G\u0018\u00010\b2\u000e\u0010O\u001a\n\u0012\u0004\u0012\u00020G\u0018\u00010\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bP\u0010\u000b\"\u0004\bQ\u0010\r\u00a8\u0006\u0098\u0001"}, d2={"Lag/granular/tiff/FieldTagTypeMapping;", "", "entries", "Ljava/util/LinkedHashSet;", "Lag/granular/tiff/FileDirectoryEntry;", "Lkotlin/collections/LinkedHashSet;", "(Ljava/util/LinkedHashSet;)V", "bitsPerSample", "", "", "getBitsPerSample", "()Ljava/util/List;", "setBitsPerSample", "(Ljava/util/List;)V", "bytesPerPixel", "getBytesPerPixel", "()I", "colorMap", "getColorMap", "setColorMap", "compression", "getCompression", "()Ljava/lang/Integer;", "decoder", "Lag/granular/tiff/compression/CompressionDecoder;", "getDecoder", "()Lag/granular/tiff/compression/CompressionDecoder;", "fieldTagTypeMapping", "Ljava/util/HashMap;", "Lag/granular/tiff/FieldTagType;", "Lkotlin/collections/HashMap;", "imageHeight", "", "getImageHeight", "()Ljava/lang/Number;", "imageWidth", "getImageWidth", "isTiled", "", "()Z", "lastBlock", "", "lastBlockIndex", "maxBitsPerSample", "getMaxBitsPerSample", "maxSampleFormat", "getMaxSampleFormat", "photometricInterpretation", "getPhotometricInterpretation", "planarConfiguration", "getPlanarConfiguration", "resolutionUnit", "getResolutionUnit", "rowsPerStrip", "getRowsPerStrip", "sampleFormat", "getSampleFormat", "setSampleFormat", "samplesPerPixel", "getSamplesPerPixel", "setSamplesPerPixel", "(I)V", "stripByteCounts", "getStripByteCounts", "stripOffsets", "getStripOffsets", "tileByteCounts", "getTileByteCounts", "tileHeight", "getTileHeight", "tileOffsets", "", "getTileOffsets", "setTileOffsets", "tileWidth", "getTileWidth", "xResolution", "getXResolution", "setXResolution", "yResolution", "getYResolution", "setYResolution", "addEntry", "", "entry", "createSingleIntegerList", "value", "createSingleLongList", "get", "fieldTagType", "getEntryValue", "T", "(Lag/granular/tiff/FieldTagType;)Ljava/lang/Object;", "getFieldTagTypeMapping", "", "getFieldTypeForSample", "Lag/granular/tiff/FieldType;", "sampleIndex", "getIntegerEntryValue", "(Lag/granular/tiff/FieldTagType;)Ljava/lang/Integer;", "getIntegerListEntryValue", "getLongListEntryValue", "getMaxIntegerEntryValue", "getNumberEntryValue", "getNumberListEntryValue", "getSampleByteSize", "getStringEntryValue", "", "numEntries", "readValue", "reader", "Lag/granular/tiff/io/ByteReader;", "fieldType", "setCompression", "setEntryValue", "typeCount", "values", "setImageHeight", "height", "setImageHeightAsLong", "setImageWidth", "width", "setImageWidthAsLong", "setPhotometricInterpretation", "setPlanarConfiguration", "setResolutionUnit", "setRowsPerStrip", "setRowsPerStripAsLong", "setStringEntryValue", "setStripByteCounts", "stripByteCount", "setStripByteCountsAsLongs", "setStripOffsets", "stripOffset", "setStripOffsetsAsLongs", "setTileByteCounts", "tileByteCount", "setTileByteCountsAsLongs", "setTileHeight", "setTileHeightAsLong", "tileOffset", "setTileWidth", "setTileWidthAsLong", "setUnsignedIntegerEntryValue", "setUnsignedIntegerListEntryValue", "setUnsignedLongEntryValue", "setUnsignedLongListEntryValue", "size", "sizeWithValues", "sum", "start", "end", "tiffany"})
public final class FieldTagTypeMapping {
    private final HashMap<FieldTagType, FileDirectoryEntry> fieldTagTypeMapping;
    private final boolean isTiled;
    private final int planarConfiguration;
    @NotNull
    private final CompressionDecoder decoder;
    private int lastBlockIndex;
    private byte[] lastBlock;
    private final LinkedHashSet<FileDirectoryEntry> entries;

    public final boolean isTiled() {
        return this.isTiled;
    }

    public final int getPlanarConfiguration() {
        return this.planarConfiguration;
    }

    @NotNull
    public final CompressionDecoder getDecoder() {
        return this.decoder;
    }

    @NotNull
    public final Number getImageWidth() {
        Number number = this.getNumberEntryValue(FieldTagType.ImageWidth);
        if (number == null) {
            Intrinsics.throwNpe();
        }
        return number;
    }

    @NotNull
    public final Number getImageHeight() {
        Number number = this.getNumberEntryValue(FieldTagType.ImageLength);
        if (number == null) {
            Intrinsics.throwNpe();
        }
        return number;
    }

    @Nullable
    public final List<Integer> getBitsPerSample() {
        return this.getIntegerListEntryValue(FieldTagType.BitsPerSample);
    }

    public final void setBitsPerSample(@Nullable List<Integer> bitsPerSample) {
        List<Integer> list = bitsPerSample;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        this.setUnsignedIntegerListEntryValue(FieldTagType.BitsPerSample, list);
    }

    @Nullable
    public final Integer getMaxBitsPerSample() {
        return this.getMaxIntegerEntryValue(FieldTagType.BitsPerSample);
    }

    @Nullable
    public final Integer getCompression() {
        return this.getIntegerEntryValue(FieldTagType.Compression);
    }

    @Nullable
    public final Integer getPhotometricInterpretation() {
        return this.getIntegerEntryValue(FieldTagType.PhotometricInterpretation);
    }

    @Nullable
    public final List<Number> getStripOffsets() {
        return this.getNumberListEntryValue(FieldTagType.StripOffsets);
    }

    public final int getSamplesPerPixel() {
        Integer samplesPerPixel = this.getIntegerEntryValue(FieldTagType.SamplesPerPixel);
        if (samplesPerPixel == null) {
            samplesPerPixel = 1;
        }
        return samplesPerPixel;
    }

    public final void setSamplesPerPixel(int samplesPerPixel) {
        this.setUnsignedIntegerEntryValue(FieldTagType.SamplesPerPixel, samplesPerPixel);
    }

    @Nullable
    public final Number getRowsPerStrip() {
        return this.getNumberEntryValue(FieldTagType.RowsPerStrip);
    }

    @Nullable
    public final List<Number> getStripByteCounts() {
        return this.getNumberListEntryValue(FieldTagType.StripByteCounts);
    }

    @Nullable
    public final List<Long> getXResolution() {
        return this.getLongListEntryValue(FieldTagType.XResolution);
    }

    public final void setXResolution(@Nullable List<Long> xResolution) {
        List<Long> list = xResolution;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        this.setUnsignedLongListEntryValue(FieldTagType.XResolution, list);
    }

    @Nullable
    public final List<Long> getYResolution() {
        return this.getLongListEntryValue(FieldTagType.YResolution);
    }

    public final void setYResolution(@Nullable List<Long> yResolution) {
        List<Long> list = yResolution;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        this.setUnsignedLongListEntryValue(FieldTagType.YResolution, list);
    }

    @Nullable
    public final Integer getResolutionUnit() {
        return this.getIntegerEntryValue(FieldTagType.ResolutionUnit);
    }

    @Nullable
    public final List<Integer> getColorMap() {
        return this.getIntegerListEntryValue(FieldTagType.ColorMap);
    }

    public final void setColorMap(@Nullable List<Integer> colorMap) {
        List<Integer> list = colorMap;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        this.setUnsignedIntegerListEntryValue(FieldTagType.ColorMap, list);
    }

    @Nullable
    public final Number getTileWidth() {
        return this.isTiled ? (Number)this.getNumberEntryValue(FieldTagType.TileWidth) : (Number)this.getImageWidth();
    }

    @Nullable
    public final Number getTileHeight() {
        return this.isTiled ? (Number)this.getNumberEntryValue(FieldTagType.TileLength) : (Number)this.getRowsPerStrip();
    }

    @Nullable
    public final List<Long> getTileOffsets() {
        return this.getLongListEntryValue(FieldTagType.TileOffsets);
    }

    public final void setTileOffsets(@Nullable List<Long> tileOffsets) {
        List<Long> list = tileOffsets;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        this.setUnsignedLongListEntryValue(FieldTagType.TileOffsets, list);
    }

    @Nullable
    public final List<Number> getTileByteCounts() {
        return this.getNumberListEntryValue(FieldTagType.TileByteCounts);
    }

    @Nullable
    public final List<Integer> getSampleFormat() {
        return this.getIntegerListEntryValue(FieldTagType.SampleFormat);
    }

    public final void setSampleFormat(@Nullable List<Integer> sampleFormat) {
        List<Integer> list = sampleFormat;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        this.setUnsignedIntegerListEntryValue(FieldTagType.SampleFormat, list);
    }

    @Nullable
    public final Integer getMaxSampleFormat() {
        return this.getMaxIntegerEntryValue(FieldTagType.SampleFormat);
    }

    /*
     * WARNING - void declaration
     */
    private final int getBytesPerPixel() {
        int bitsPerSample = 0;
        List<Integer> list = this.getBitsPerSample();
        if (list == null) {
            Intrinsics.throwNpe();
        }
        List<Integer> bitsPerSamples = list;
        int n = 0;
        int n2 = ((Collection)bitsPerSamples).size();
        while (n < n2) {
            void i;
            int bits = ((Number)bitsPerSamples.get((int)i)).intValue();
            if (bits % 8 != 0) {
                throw (Throwable)new TiffException("Sample bit-width of " + bits + " is not supported");
            }
            if (bits != ((Number)bitsPerSamples.get(0)).intValue()) {
                throw (Throwable)new TiffException("Differing size of samples in a pixel are not supported. sample 0 = " + ((Number)bitsPerSamples.get(0)).intValue() + ", sample " + (int)i + " = " + bits);
            }
            bitsPerSample += bits;
            ++i;
        }
        return bitsPerSample / 8;
    }

    public final void addEntry(@NotNull FileDirectoryEntry entry) {
        Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        this.entries.remove(entry);
        this.entries.add(entry);
        ((Map)this.fieldTagTypeMapping).put(entry.getFieldTag(), entry);
    }

    public final int numEntries() {
        return this.entries.size();
    }

    @NotNull
    public final FileDirectoryEntry get(@NotNull FieldTagType fieldTagType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)fieldTagType), (String)"fieldTagType");
        FileDirectoryEntry fileDirectoryEntry = this.fieldTagTypeMapping.get((Object)fieldTagType);
        if (fileDirectoryEntry == null) {
            Intrinsics.throwNpe();
        }
        return fileDirectoryEntry;
    }

    @NotNull
    public final Map<FieldTagType, FileDirectoryEntry> getFieldTagTypeMapping() {
        return this.fieldTagTypeMapping;
    }

    public final void setImageWidth(int width) {
        this.setUnsignedIntegerEntryValue(FieldTagType.ImageWidth, width);
    }

    public final void setImageWidthAsLong(long width) {
        this.setUnsignedLongEntryValue(FieldTagType.ImageWidth, width);
    }

    public final void setImageHeight(int height) {
        this.setUnsignedIntegerEntryValue(FieldTagType.ImageLength, height);
    }

    public final void setImageHeightAsLong(long height) {
        this.setUnsignedLongEntryValue(FieldTagType.ImageLength, height);
    }

    public final void setBitsPerSample(int bitsPerSample) {
        this.setBitsPerSample(this.createSingleIntegerList(bitsPerSample));
    }

    public final void setCompression(int compression) {
        this.setUnsignedIntegerEntryValue(FieldTagType.Compression, compression);
    }

    public final void setPhotometricInterpretation(int photometricInterpretation) {
        this.setUnsignedIntegerEntryValue(FieldTagType.PhotometricInterpretation, photometricInterpretation);
    }

    public final void setStripOffsets(@NotNull List<Integer> stripOffsets) {
        Intrinsics.checkParameterIsNotNull(stripOffsets, (String)"stripOffsets");
        this.setUnsignedIntegerListEntryValue(FieldTagType.StripOffsets, stripOffsets);
    }

    public final void setStripOffsetsAsLongs(@NotNull List<Long> stripOffsets) {
        Intrinsics.checkParameterIsNotNull(stripOffsets, (String)"stripOffsets");
        this.setUnsignedLongListEntryValue(FieldTagType.StripOffsets, stripOffsets);
    }

    public final void setStripOffsets(int stripOffset) {
        this.setStripOffsets(this.createSingleIntegerList(stripOffset));
    }

    public final void setStripOffsets(long stripOffset) {
        this.setStripOffsetsAsLongs(this.createSingleLongList(stripOffset));
    }

    public final void setRowsPerStrip(int rowsPerStrip) {
        this.setUnsignedIntegerEntryValue(FieldTagType.RowsPerStrip, rowsPerStrip);
    }

    public final void setRowsPerStripAsLong(long rowsPerStrip) {
        this.setUnsignedLongEntryValue(FieldTagType.RowsPerStrip, rowsPerStrip);
    }

    public final void setStripByteCounts(@NotNull List<Integer> stripByteCounts) {
        Intrinsics.checkParameterIsNotNull(stripByteCounts, (String)"stripByteCounts");
        this.setUnsignedIntegerListEntryValue(FieldTagType.StripByteCounts, stripByteCounts);
    }

    public final void setStripByteCountsAsLongs(@NotNull List<Long> stripByteCounts) {
        Intrinsics.checkParameterIsNotNull(stripByteCounts, (String)"stripByteCounts");
        this.setUnsignedLongListEntryValue(FieldTagType.StripByteCounts, stripByteCounts);
    }

    public final void setStripByteCounts(int stripByteCount) {
        this.setStripByteCounts(this.createSingleIntegerList(stripByteCount));
    }

    public final void setStripByteCounts(long stripByteCount) {
        this.setStripByteCountsAsLongs(this.createSingleLongList(stripByteCount));
    }

    public final void setXResolution(long xResolution) {
        this.setXResolution(this.createSingleLongList(xResolution));
    }

    public final void setYResolution(long yResolution) {
        this.setYResolution(this.createSingleLongList(yResolution));
    }

    @Nullable
    public final Integer getPlanarConfiguration() {
        return this.getIntegerEntryValue(FieldTagType.PlanarConfiguration);
    }

    public final void setPlanarConfiguration(int planarConfiguration) {
        this.setUnsignedIntegerEntryValue(FieldTagType.PlanarConfiguration, planarConfiguration);
    }

    public final void setResolutionUnit(int resolutionUnit) {
        this.setUnsignedIntegerEntryValue(FieldTagType.ResolutionUnit, resolutionUnit);
    }

    public final void setColorMap(int colorMap) {
        this.setColorMap(this.createSingleIntegerList(colorMap));
    }

    public final void setTileWidth(int tileWidth) {
        this.setUnsignedIntegerEntryValue(FieldTagType.TileWidth, tileWidth);
    }

    public final void setTileWidthAsLong(long tileWidth) {
        this.setUnsignedLongEntryValue(FieldTagType.TileWidth, tileWidth);
    }

    public final void setTileHeight(int tileHeight) {
        this.setUnsignedIntegerEntryValue(FieldTagType.TileLength, tileHeight);
    }

    public final void setTileHeightAsLong(long tileHeight) {
        this.setUnsignedLongEntryValue(FieldTagType.TileLength, tileHeight);
    }

    public final void setTileOffsets(long tileOffset) {
        this.setTileOffsets(this.createSingleLongList(tileOffset));
    }

    public final void setTileByteCounts(@NotNull List<Integer> tileByteCounts) {
        Intrinsics.checkParameterIsNotNull(tileByteCounts, (String)"tileByteCounts");
        this.setUnsignedIntegerListEntryValue(FieldTagType.TileByteCounts, tileByteCounts);
    }

    public final void setTileByteCountsAsLongs(@NotNull List<Long> tileByteCounts) {
        Intrinsics.checkParameterIsNotNull(tileByteCounts, (String)"tileByteCounts");
        this.setUnsignedLongListEntryValue(FieldTagType.TileByteCounts, tileByteCounts);
    }

    public final void setTileByteCounts(int tileByteCount) {
        this.setTileByteCounts(this.createSingleIntegerList(tileByteCount));
    }

    public final void setTileByteCounts(long tileByteCount) {
        this.setTileByteCountsAsLongs(this.createSingleLongList(tileByteCount));
    }

    public final void setSampleFormat(int sampleFormat) {
        this.setSampleFormat(this.createSingleIntegerList(sampleFormat));
    }

    private final Number readValue(ByteReader reader, FieldType fieldType) {
        Number value = null;
        switch (FieldTagTypeMapping$WhenMappings.$EnumSwitchMapping$0[fieldType.ordinal()]) {
            case 1: {
                value = reader.readUnsignedByte();
                break;
            }
            case 2: {
                value = reader.readUnsignedShort();
                break;
            }
            case 3: {
                value = reader.readUnsignedInt();
                break;
            }
            case 4: {
                value = reader.readByte();
                break;
            }
            case 5: {
                value = reader.readShort();
                break;
            }
            case 6: {
                value = reader.readInt();
                break;
            }
            case 7: {
                value = Float.valueOf(reader.readFloat());
                break;
            }
            case 8: {
                value = reader.readDouble();
                break;
            }
            default: {
                throw (Throwable)new TiffException("Unsupported raster field type: " + (Object)((Object)fieldType));
            }
        }
        return value;
    }

    @NotNull
    public final FieldType getFieldTypeForSample(int sampleIndex) {
        List<Integer> sampleFormatList = this.getSampleFormat();
        int sampleFormat = sampleFormatList == null ? 1 : ((Number)sampleFormatList.get(sampleIndex < sampleFormatList.size() ? sampleIndex : 0)).intValue();
        List<Integer> list = this.getBitsPerSample();
        if (list == null) {
            Intrinsics.throwNpe();
        }
        int bitsPerSample = ((Number)list.get(sampleIndex)).intValue();
        return FieldType.Companion.getFieldType(sampleFormat, bitsPerSample);
    }

    public final int getSampleByteSize(int sampleIndex) {
        List<Integer> bitsPerSample;
        List<Integer> list = bitsPerSample = this.getBitsPerSample();
        if (list == null) {
            Intrinsics.throwNpe();
        }
        if (sampleIndex >= list.size()) {
            throw (Throwable)new TiffException("Sample index " + sampleIndex + " is out of range");
        }
        int bits = ((Number)bitsPerSample.get(sampleIndex)).intValue();
        if (bits % 8 != 0) {
            throw (Throwable)new TiffException("Sample bit-width of " + bits + " is not supported");
        }
        return bits / 8;
    }

    @Nullable
    public final Integer getIntegerEntryValue(@NotNull FieldTagType fieldTagType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)fieldTagType), (String)"fieldTagType");
        return (Integer)this.getEntryValue(fieldTagType);
    }

    public final void setUnsignedIntegerEntryValue(@NotNull FieldTagType fieldTagType, int value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)fieldTagType), (String)"fieldTagType");
        this.setEntryValue(fieldTagType, FieldType.SHORT, 1L, value);
    }

    @Nullable
    public final Number getNumberEntryValue(@NotNull FieldTagType fieldTagType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)fieldTagType), (String)"fieldTagType");
        return (Number)this.getEntryValue(fieldTagType);
    }

    public final void setUnsignedLongEntryValue(@NotNull FieldTagType fieldTagType, long value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)fieldTagType), (String)"fieldTagType");
        this.setEntryValue(fieldTagType, FieldType.LONG, 1L, value);
    }

    @Nullable
    public final String getStringEntryValue(@NotNull FieldTagType fieldTagType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)fieldTagType), (String)"fieldTagType");
        String value = null;
        List values = (List)this.getEntryValue(fieldTagType);
        if (values != null && !values.isEmpty()) {
            value = (String)values.get(0);
        }
        return value;
    }

    public final void setStringEntryValue(@NotNull FieldTagType fieldTagType, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)fieldTagType), (String)"fieldTagType");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        this.setEntryValue(fieldTagType, FieldType.ASCII, value.length() + 1, values);
    }

    @Nullable
    public final List<Integer> getIntegerListEntryValue(@NotNull FieldTagType fieldTagType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)fieldTagType), (String)"fieldTagType");
        return (List)this.getEntryValue(fieldTagType);
    }

    public final void setUnsignedIntegerListEntryValue(@NotNull FieldTagType fieldTagType, @NotNull List<Integer> value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)fieldTagType), (String)"fieldTagType");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        this.setEntryValue(fieldTagType, FieldType.SHORT, value.size(), value);
    }

    @Nullable
    public final Integer getMaxIntegerEntryValue(@NotNull FieldTagType fieldTagType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)fieldTagType), (String)"fieldTagType");
        Integer maxValue = null;
        List<Integer> values = this.getIntegerListEntryValue(fieldTagType);
        if (values != null) {
            maxValue = (Integer)CollectionsKt.max((Iterable)values);
        }
        return maxValue;
    }

    @Nullable
    public final List<Number> getNumberListEntryValue(@NotNull FieldTagType fieldTagType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)fieldTagType), (String)"fieldTagType");
        return (List)this.getEntryValue(fieldTagType);
    }

    @Nullable
    public final List<Long> getLongListEntryValue(@NotNull FieldTagType fieldTagType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)fieldTagType), (String)"fieldTagType");
        return (List)this.getEntryValue(fieldTagType);
    }

    public final void setUnsignedLongListEntryValue(@NotNull FieldTagType fieldTagType, @NotNull List<Long> value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)fieldTagType), (String)"fieldTagType");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        this.setEntryValue(fieldTagType, FieldType.LONG, value.size(), value);
    }

    private final <T> T getEntryValue(FieldTagType fieldTagType) {
        Object value = null;
        FileDirectoryEntry entry = this.fieldTagTypeMapping.get((Object)fieldTagType);
        if (entry != null) {
            value = entry.getValues();
        }
        return (T)value;
    }

    private final void setEntryValue(FieldTagType fieldTagType, FieldType fieldType, long typeCount, Object values) {
        FileDirectoryEntry entry = new FileDirectoryEntry(fieldTagType, fieldType, typeCount, values);
        this.addEntry(entry);
    }

    /*
     * WARNING - void declaration
     */
    private final int sum(List<Integer> values, int start, int end) {
        int sum = 0;
        int n = start;
        int n2 = end;
        while (n < n2) {
            void i;
            List<Integer> list = values;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            sum += ((Number)list.get((int)i)).intValue();
            ++i;
        }
        return sum;
    }

    private final List<Integer> createSingleIntegerList(int value) {
        ArrayList<Integer> valueList = new ArrayList<Integer>();
        valueList.add(value);
        return valueList;
    }

    private final List<Long> createSingleLongList(long value) {
        ArrayList<Long> valueList = new ArrayList<Long>();
        valueList.add(value);
        return valueList;
    }

    public final long size() {
        return 2 + this.entries.size() * 12 + 4;
    }

    public final long sizeWithValues() {
        long size = 6;
        for (FileDirectoryEntry entry : this.entries) {
            size += entry.sizeWithValues();
        }
        return size;
    }

    public FieldTagTypeMapping(@NotNull LinkedHashSet<FileDirectoryEntry> entries) {
        CompressionDecoder compressionDecoder;
        Integer pc;
        Intrinsics.checkParameterIsNotNull(entries, (String)"entries");
        this.entries = entries;
        this.fieldTagTypeMapping = new HashMap();
        this.lastBlockIndex = -1;
        for (FileDirectoryEntry entry : this.entries) {
            Map map = this.fieldTagTypeMapping;
            FieldTagType fieldTagType = entry.getFieldTag();
            FileDirectoryEntry fileDirectoryEntry = entry;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileDirectoryEntry, (String)"entry");
            map.put(fieldTagType, fileDirectoryEntry);
        }
        this.isTiled = this.getRowsPerStrip() == null;
        Integer n = pc = this.getPlanarConfiguration();
        int n2 = this.planarConfiguration = n != null ? n : 1;
        if (this.planarConfiguration != 1 && this.planarConfiguration != 2) {
            throw (Throwable)new TiffException("Invalid planar configuration: " + this.planarConfiguration);
        }
        Integer n3 = this.getCompression();
        int compression = n3 != null ? n3 : 1;
        switch (compression) {
            case 1: {
                compressionDecoder = new RawCompression();
                break;
            }
            case 2: {
                throw (Throwable)new TiffException("CCITT Huffman compression not supported: " + compression);
            }
            case 3: {
                throw (Throwable)new TiffException("T4-encoding compression not supported: " + compression);
            }
            case 4: {
                throw (Throwable)new TiffException("T6-encoding compression not supported: " + compression);
            }
            case 5: {
                compressionDecoder = new LZWCompression();
                break;
            }
            case 6: 
            case 7: {
                throw (Throwable)new TiffException("JPEG compression not supported: " + compression);
            }
            case 8: 
            case 32946: {
                compressionDecoder = new DeflateCompression();
                break;
            }
            case 32773: {
                compressionDecoder = new PackbitsCompression();
                break;
            }
            default: {
                throw (Throwable)new TiffException("Unknown compression method identifier: " + compression);
            }
        }
        this.decoder = compressionDecoder;
    }
}

