/*
 * Decompiled with CFR 0.152.
 */
package ag.granular.tiff;

import ag.granular.io.ByteBuffer;
import ag.granular.io.ByteOrder;
import ag.granular.tiff.FieldType;
import ag.granular.tiff.Rasters$WhenMappings;
import ag.granular.tiff.util.TiffException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\b\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0017\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0006\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!J\u001e\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!J\u0018\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\b\b\u0002\u0010%\u001a\u00020\u0003J#\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010(J#\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0002\u00a2\u0006\u0002\u0010,J\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00030.J\u0018\u0010/\u001a\u0004\u0018\u00010!2\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u0003J\u0016\u00102\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u0003J\u0006\u00103\u001a\u00020\tJ!\u00104\u001a\b\u0012\u0004\u0012\u00020!0\u00062\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u0003\u00a2\u0006\u0002\u00105J\u0016\u00106\u001a\u0002072\u0006\u00101\u001a\u00020\u00032\u0006\u00108\u001a\u000209J\u001e\u0010:\u001a\u00020!2\u0006\u0010;\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u0003J\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00030.J\"\u0010=\u001a\u00020!2\b\u0010>\u001a\u0004\u0018\u00010\t2\u0006\u0010?\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J\u0016\u0010@\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u0003J\u001e\u0010A\u001a\u0002072\u0006\u00101\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u00032\u0006\u00108\u001a\u000209J\u0011\u0010B\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\u0002\u0010CJ\u0006\u0010D\u001a\u00020EJ\u0006\u0010F\u001a\u00020EJ\u0018\u0010G\u001a\u00020!2\u0006\u0010>\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u0007H\u0002J\u0018\u0010H\u001a\u00020\u00032\u0006\u0010I\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003H\u0002J\u001e\u0010J\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!J\u000e\u0010K\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\tJ)\u0010L\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u00032\f\u0010M\u001a\b\u0012\u0004\u0012\u00020!0\u0006\u00a2\u0006\u0002\u0010NJ&\u0010O\u001a\u00020\u001d2\u0006\u0010;\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!J\u0019\u0010P\u001a\u00020\u001d2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\u0002\u0010QJ\u0006\u0010R\u001a\u00020\u0003J\u0006\u0010S\u001a\u00020\u0003J*\u0010T\u001a\u00020\u001d2\b\u0010>\u001a\u0004\u0018\u00010\t2\u0006\u0010U\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010V\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u0003H\u0002J\u0010\u0010W\u001a\u00020\u001d2\u0006\u0010;\u001a\u00020\u0003H\u0002J\b\u0010X\u001a\u00020\u001dH\u0002J \u0010Y\u001a\u00020\u001d2\u0006\u0010Z\u001a\u00020\t2\u0006\u0010[\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u0007H\u0002J \u0010Y\u001a\u00020\u001d2\u0006\u0010>\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!H\u0002R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0016\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0012\u00a8\u0006\\"}, d2={"Lag/granular/tiff/Rasters;", "", "width", "", "height", "fieldTypes", "", "Lag/granular/tiff/FieldType;", "sampleValues", "Lag/granular/io/ByteBuffer;", "interleaveValues", "(II[Lag/granular/tiff/FieldType;[Lag/granular/io/ByteBuffer;Lag/granular/io/ByteBuffer;)V", "bitsPerSample", "", "getFieldTypes", "()[Lag/granular/tiff/FieldType;", "[Lag/granular/tiff/FieldType;", "getHeight", "()I", "numPixels", "getNumPixels", "pixelSize", "Ljava/lang/Integer;", "sampleFormat", "[Lag/granular/io/ByteBuffer;", "samplesPerPixel", "getSamplesPerPixel", "getWidth", "addToInterleave", "", "sampleIndex", "coordinate", "value", "", "addToSample", "calculateRowsPerStrip", "planarConfiguration", "maxBytesPerStrip", "createFieldTypeArray", "fieldType", "(ILag/granular/tiff/FieldType;)[Lag/granular/tiff/FieldType;", "bitsPerSamples", "", "sampleFormats", "([I[I)[Lag/granular/tiff/FieldType;", "getBitsPerSample", "", "getFirstPixelSample", "x", "y", "getInterleaveIndex", "getInterleaveValues", "getPixel", "(II)[Ljava/lang/Number;", "getPixelRow", "", "newOrder", "Lag/granular/io/ByteOrder;", "getPixelSample", "sample", "getSampleFormat", "getSampleFromByteBuffer", "buffer", "index", "getSampleIndex", "getSampleRow", "getSampleValues", "()[Lag/granular/io/ByteBuffer;", "hasInterleaveValues", "", "hasSampleValues", "readSample", "rowsPerStrip", "bytesPerPixel", "setFirstPixelSample", "setInterleaveValues", "setPixel", "values", "(II[Ljava/lang/Number;)V", "setPixelSample", "setSampleValues", "([Lag/granular/io/ByteBuffer;)V", "size", "sizePixel", "updateSampleInByteBuffer", "bufferIndex", "validateCoordinates", "validateSample", "validateValues", "writeSample", "outBuffer", "inBuffer", "tiffany"})
public final class Rasters {
    private Integer pixelSize;
    private List<Integer> bitsPerSample;
    private List<Integer> sampleFormat;
    private final int width;
    private final int height;
    @NotNull
    private final FieldType[] fieldTypes;
    private ByteBuffer[] sampleValues;
    private ByteBuffer interleaveValues;

    public final int getNumPixels() {
        return this.width * this.height;
    }

    public final int getSamplesPerPixel() {
        return this.fieldTypes.length;
    }

    private final void validateValues() {
        if (this.sampleValues == null && this.interleaveValues == null) {
            throw (Throwable)new TiffException("Results must be sample and/or interleave based");
        }
    }

    private final FieldType[] createFieldTypeArray(int samplesPerPixel, FieldType fieldType) {
        FieldType[] fieldTypeArray = new FieldType[samplesPerPixel];
        int n = 0;
        while (n < samplesPerPixel) {
            FieldType fieldType2;
            int n2 = n;
            int n3 = n++;
            FieldType[] fieldTypeArray2 = fieldTypeArray;
            boolean bl = false;
            fieldTypeArray2[n3] = fieldType2 = fieldType;
        }
        return fieldTypeArray;
    }

    /*
     * WARNING - void declaration
     */
    private final FieldType[] createFieldTypeArray(int[] bitsPerSamples, int[] sampleFormats) {
        if (bitsPerSamples.length != sampleFormats.length) {
            throw (Throwable)new TiffException("Equal number of bits per samples and sample formats expected. Bits Per Samples: " + bitsPerSamples + ", Sample Formats: " + sampleFormats);
        }
        int n = bitsPerSamples.length;
        FieldType[] fieldTypeArray = new FieldType[n];
        int n2 = 0;
        while (n2 < n) {
            void i;
            FieldType fieldType;
            int n3 = n2;
            int n4 = n2++;
            FieldType[] fieldTypeArray2 = fieldTypeArray;
            boolean bl = false;
            fieldTypeArray2[n4] = fieldType = FieldType.Companion.getFieldType(sampleFormats[i], bitsPerSamples[i]);
        }
        return fieldTypeArray;
    }

    public final boolean hasSampleValues() {
        return this.sampleValues != null;
    }

    public final boolean hasInterleaveValues() {
        return this.interleaveValues != null;
    }

    private final void updateSampleInByteBuffer(ByteBuffer buffer, int bufferIndex, int sampleIndex, Number value) {
        block3: {
            block2: {
                if (bufferIndex < 0) break block2;
                ByteBuffer byteBuffer = buffer;
                Intrinsics.checkNotNull((Object)byteBuffer);
                if (bufferIndex < byteBuffer.capacity()) break block3;
            }
            StringBuilder stringBuilder = new StringBuilder().append("index: ").append(bufferIndex).append(". Buffer capacity: ");
            ByteBuffer byteBuffer = buffer;
            Intrinsics.checkNotNull((Object)byteBuffer);
            throw (Throwable)new IndexOutOfBoundsException(stringBuilder.append(byteBuffer.capacity()).toString());
        }
        buffer.position(bufferIndex);
        this.writeSample(buffer, this.fieldTypes[sampleIndex], value);
    }

    private final Number getSampleFromByteBuffer(ByteBuffer buffer, int index, int sampleIndex) {
        block3: {
            block2: {
                if (index < 0) break block2;
                ByteBuffer byteBuffer = buffer;
                Intrinsics.checkNotNull((Object)byteBuffer);
                if (index < byteBuffer.capacity()) break block3;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Requested index: ").append(index).append(", but size of buffer is: ");
            ByteBuffer byteBuffer = buffer;
            Intrinsics.checkNotNull((Object)byteBuffer);
            throw (Throwable)new IndexOutOfBoundsException(stringBuilder.append(byteBuffer.capacity()).toString());
        }
        buffer.position(index);
        return this.readSample(buffer, this.fieldTypes[sampleIndex]);
    }

    public final void addToSample(int sampleIndex, int coordinate, @NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNull((Object)this.sampleValues);
        this.updateSampleInByteBuffer(this.sampleValues[sampleIndex], coordinate * this.fieldTypes[sampleIndex].getBytes(), sampleIndex, value);
    }

    /*
     * WARNING - void declaration
     */
    public final void addToInterleave(int sampleIndex, int coordinate, @NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int bufferPos = coordinate * this.sizePixel();
        int n = 0;
        int n2 = sampleIndex;
        while (n < n2) {
            void i;
            bufferPos += this.fieldTypes[i].getBytes();
            ++i;
        }
        this.updateSampleInByteBuffer(this.interleaveValues, bufferPos, sampleIndex, value);
    }

    @NotNull
    public final List<Integer> getBitsPerSample() {
        List result = this.bitsPerSample;
        if (result == null) {
            result = new ArrayList(this.fieldTypes.length);
            for (FieldType fieldType : this.fieldTypes) {
                result.add(fieldType.getBits());
            }
            this.bitsPerSample = result;
        }
        return result;
    }

    @NotNull
    public final List<Integer> getSampleFormat() {
        List result = this.sampleFormat;
        if (result == null) {
            result = new ArrayList(this.fieldTypes.length);
            for (FieldType fieldType : this.fieldTypes) {
                result.add(FieldType.Companion.getSampleFormat(fieldType));
            }
            this.sampleFormat = result;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ByteBuffer[] getSampleValues() {
        int n = 0;
        Intrinsics.checkNotNull((Object)this.sampleValues);
        int n2 = this.sampleValues.length;
        while (n < n2) {
            void i;
            Intrinsics.checkNotNull((Object)this.sampleValues);
            this.sampleValues[i].rewind();
            ++i;
        }
        Intrinsics.checkNotNull((Object)this.sampleValues);
        return this.sampleValues;
    }

    public final void setSampleValues(@NotNull ByteBuffer[] sampleValues) {
        Intrinsics.checkNotNullParameter((Object)sampleValues, (String)"sampleValues");
        this.sampleValues = sampleValues;
        this.sampleFormat = null;
        this.bitsPerSample = null;
        this.pixelSize = null;
        this.validateValues();
    }

    @NotNull
    public final ByteBuffer getInterleaveValues() {
        ByteBuffer byteBuffer = this.interleaveValues;
        Intrinsics.checkNotNull((Object)byteBuffer);
        byteBuffer.rewind();
        ByteBuffer byteBuffer2 = this.interleaveValues;
        Intrinsics.checkNotNull((Object)byteBuffer2);
        return byteBuffer2;
    }

    public final void setInterleaveValues(@NotNull ByteBuffer interleaveValues) {
        Intrinsics.checkNotNullParameter((Object)interleaveValues, (String)"interleaveValues");
        this.interleaveValues = interleaveValues;
        this.validateValues();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Number[] getPixel(int x, int y) {
        Number[] numberArray;
        this.validateCoordinates(x, y);
        if (this.sampleValues != null) {
            int sampleIndex = this.getSampleIndex(x, y);
            int n = this.getSamplesPerPixel();
            Number[] numberArray2 = new Number[n];
            int n2 = 0;
            while (n2 < n) {
                Number number;
                void i;
                int n3 = n2;
                int n4 = n2++;
                Number[] numberArray3 = numberArray2;
                boolean bl = false;
                int bufferIndex = sampleIndex * this.fieldTypes[i].getBytes();
                Intrinsics.checkNotNull((Object)this.sampleValues);
                numberArray3[n4] = number = this.getSampleFromByteBuffer(this.sampleValues[i], bufferIndex, (int)i);
            }
            numberArray = numberArray2;
        } else {
            int interleaveIndex = this.getInterleaveIndex(x, y);
            int n = this.getSamplesPerPixel();
            Number[] numberArray4 = new Number[n];
            int n5 = 0;
            while (n5 < n) {
                Number number;
                int i = n5;
                int n6 = n5++;
                Number[] numberArray5 = numberArray4;
                boolean bl = false;
                Number s = this.getSampleFromByteBuffer(this.interleaveValues, interleaveIndex, i);
                interleaveIndex += this.fieldTypes[i].getBytes();
                numberArray5[n6] = number = s;
            }
            numberArray = numberArray4;
        }
        return numberArray;
    }

    /*
     * WARNING - void declaration
     */
    public final void setPixel(int x, int y, @NotNull Number[] values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.validateCoordinates(x, y);
        this.validateSample(values.length + 1);
        if (this.sampleValues != null) {
            int n = 0;
            int n2 = this.getSamplesPerPixel();
            while (n < n2) {
                void i;
                int bufferIndex = this.getSampleIndex(x, y) * this.fieldTypes[i].getBytes();
                Intrinsics.checkNotNull((Object)this.sampleValues);
                this.updateSampleInByteBuffer(this.sampleValues[i], bufferIndex, (int)i, values[i]);
                ++i;
            }
        } else {
            int interleaveIndex = this.getSampleIndex(x, y) * this.sizePixel();
            int n = 0;
            int n3 = this.getSamplesPerPixel();
            while (n < n3) {
                void i;
                this.updateSampleInByteBuffer(this.interleaveValues, interleaveIndex, (int)i, values[i]);
                interleaveIndex += this.fieldTypes[i].getBytes();
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] getPixelRow(int y, @NotNull ByteOrder newOrder) {
        Intrinsics.checkNotNullParameter((Object)((Object)newOrder), (String)"newOrder");
        ByteBuffer outBuffer = ByteBuffer.Companion.allocate(this.width * this.sizePixel());
        outBuffer.order(newOrder);
        if (this.sampleValues != null) {
            int i;
            int n = 0;
            int n2 = this.getSamplesPerPixel();
            while (n < n2) {
                Intrinsics.checkNotNull((Object)this.sampleValues);
                this.sampleValues[i].position(y * this.width * this.fieldTypes[i].getBytes());
                ++i;
            }
            n2 = this.width;
            for (i = 0; i < n2; ++i) {
                int n3 = 0;
                int n4 = this.getSamplesPerPixel();
                while (n3 < n4) {
                    void j;
                    Intrinsics.checkNotNull((Object)this.sampleValues);
                    this.writeSample(outBuffer, this.sampleValues[j], this.fieldTypes[j]);
                    ++j;
                }
            }
        } else {
            ByteBuffer byteBuffer = this.interleaveValues;
            Intrinsics.checkNotNull((Object)byteBuffer);
            byteBuffer.position(y * this.width * this.sizePixel());
            int n = this.width;
            for (int i = 0; i < n; ++i) {
                int n5 = this.getSamplesPerPixel();
                for (int j = 0; j < n5; ++j) {
                    ByteBuffer byteBuffer2 = this.interleaveValues;
                    Intrinsics.checkNotNull((Object)byteBuffer2);
                    this.writeSample(outBuffer, byteBuffer2, this.fieldTypes[j]);
                }
            }
        }
        return outBuffer.array();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] getSampleRow(int y, int sample, @NotNull ByteOrder newOrder) {
        Intrinsics.checkNotNullParameter((Object)((Object)newOrder), (String)"newOrder");
        ByteBuffer outBuffer = ByteBuffer.Companion.allocate(this.width * this.fieldTypes[sample].getBytes());
        outBuffer.order(newOrder);
        if (this.sampleValues != null) {
            Intrinsics.checkNotNull((Object)this.sampleValues);
            this.sampleValues[sample].position(y * this.width * this.fieldTypes[sample].getBytes());
            int n = 0;
            int n2 = this.width;
            while (n < n2) {
                void x;
                Intrinsics.checkNotNull((Object)this.sampleValues);
                this.writeSample(outBuffer, this.sampleValues[sample], this.fieldTypes[sample]);
                ++x;
            }
        } else {
            int i;
            int sampleOffset = 0;
            int n = 0;
            int n3 = sample;
            while (n < n3) {
                sampleOffset += this.fieldTypes[sample].getBytes();
                ++i;
            }
            n3 = this.width;
            for (i = 0; i < n3; ++i) {
                ByteBuffer byteBuffer = this.interleaveValues;
                Intrinsics.checkNotNull((Object)byteBuffer);
                byteBuffer.position((y * this.width + i) * this.sizePixel() + sampleOffset);
                ByteBuffer byteBuffer2 = this.interleaveValues;
                Intrinsics.checkNotNull((Object)byteBuffer2);
                this.writeSample(outBuffer, byteBuffer2, this.fieldTypes[sample]);
            }
        }
        return outBuffer.array();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Number getPixelSample(int sample, int x, int y) {
        this.validateCoordinates(x, y);
        this.validateSample(sample);
        Number pixelSample = null;
        if (this.sampleValues != null) {
            int bufferPos = this.getSampleIndex(x, y) * this.fieldTypes[sample].getBytes();
            Intrinsics.checkNotNull((Object)this.sampleValues);
            pixelSample = this.getSampleFromByteBuffer(this.sampleValues[sample], bufferPos, sample);
        } else {
            int bufferPos = this.getInterleaveIndex(x, y);
            int n = 0;
            int n2 = sample;
            while (n < n2) {
                void i;
                bufferPos += this.fieldTypes[sample].getBytes();
                ++i;
            }
            pixelSample = this.getSampleFromByteBuffer(this.interleaveValues, bufferPos, sample);
        }
        return pixelSample;
    }

    /*
     * WARNING - void declaration
     */
    public final void setPixelSample(int sample, int x, int y, @NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.validateCoordinates(x, y);
        this.validateSample(sample);
        if (this.sampleValues != null) {
            int sampleIndex = this.getSampleIndex(x, y) * this.fieldTypes[sample].getBytes();
            Intrinsics.checkNotNull((Object)this.sampleValues);
            this.updateSampleInByteBuffer(this.sampleValues[sample], sampleIndex, sample, value);
        }
        if (this.interleaveValues != null) {
            int interleaveIndex = this.getSampleIndex(x, y) * this.sizePixel();
            int n = 0;
            int n2 = sample;
            while (n < n2) {
                void i;
                interleaveIndex += this.fieldTypes[sample].getBytes();
                ++i;
            }
            this.updateSampleInByteBuffer(this.interleaveValues, interleaveIndex, sample, value);
        }
    }

    @Nullable
    public final Number getFirstPixelSample(int x, int y) {
        return this.getPixelSample(0, x, y);
    }

    public final void setFirstPixelSample(int x, int y, @NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setPixelSample(0, x, y, value);
    }

    public final int getSampleIndex(int x, int y) {
        return y * this.width + x;
    }

    public final int getInterleaveIndex(int x, int y) {
        return y * this.width * this.sizePixel() + x * this.sizePixel();
    }

    public final int size() {
        return this.getNumPixels() * this.sizePixel();
    }

    /*
     * WARNING - void declaration
     */
    public final int sizePixel() {
        if (this.pixelSize != null) {
            Integer n = this.pixelSize;
            Intrinsics.checkNotNull((Object)n);
            return n;
        }
        int size = 0;
        int n = 0;
        int n2 = this.getSamplesPerPixel();
        while (n < n2) {
            void i;
            size += this.fieldTypes[i].getBytes();
            ++i;
        }
        this.pixelSize = size;
        return size;
    }

    private final void validateCoordinates(int x, int y) {
        if (x < 0 || x >= this.width || y < 0 || y > this.height) {
            throw (Throwable)new TiffException("Pixel oustide of raster range. Width: " + this.width + ", Height: " + this.height + ", x: " + x + ", y: " + y);
        }
    }

    private final void validateSample(int sample) {
        if (sample < 0 || sample >= this.getSamplesPerPixel()) {
            throw (Throwable)new TiffException("Pixel sample out of bounds. sample: " + sample + ", samples per pixel: " + this.getSamplesPerPixel());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int calculateRowsPerStrip(int planarConfiguration, int maxBytesPerStrip) {
        Integer rowsPerStrip = null;
        if (planarConfiguration == 1) {
            rowsPerStrip = this.rowsPerStrip(this.sizePixel(), maxBytesPerStrip);
        } else {
            int n = 0;
            int n2 = this.getSamplesPerPixel();
            while (n < n2) {
                void sample;
                int rowsPerStripForSample = this.rowsPerStrip(this.fieldTypes[sample].getBytes(), maxBytesPerStrip);
                if (rowsPerStrip == null || rowsPerStripForSample < rowsPerStrip) {
                    rowsPerStrip = rowsPerStripForSample;
                }
                ++sample;
            }
        }
        Integer n = rowsPerStrip;
        Intrinsics.checkNotNull((Object)n);
        return n;
    }

    public static /* synthetic */ int calculateRowsPerStrip$default(Rasters rasters, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 8000;
        }
        return rasters.calculateRowsPerStrip(n, n2);
    }

    private final int rowsPerStrip(int bytesPerPixel, int maxBytesPerStrip) {
        int bytesPerRow = bytesPerPixel * this.width;
        int n = 1;
        int n2 = maxBytesPerStrip / bytesPerRow;
        boolean bl = false;
        return Math.max(n, n2);
    }

    private final Number readSample(ByteBuffer buffer, FieldType fieldType) {
        Number number;
        switch (Rasters$WhenMappings.$EnumSwitchMapping$0[fieldType.ordinal()]) {
            case 1: {
                number = (short)(buffer.get() & 0xFF);
                break;
            }
            case 2: {
                number = buffer.getShort() & 0xFFFF;
                break;
            }
            case 3: {
                number = buffer.getInt() & 0xFFFFFFF;
                break;
            }
            case 4: {
                number = buffer.get();
                break;
            }
            case 5: {
                number = buffer.getShort();
                break;
            }
            case 6: {
                number = buffer.getInt();
                break;
            }
            case 7: {
                number = Float.valueOf(buffer.getFloat());
                break;
            }
            case 8: {
                number = buffer.getDouble();
                break;
            }
            default: {
                throw (Throwable)new TiffException("Unsupported raster field type: " + (Object)((Object)fieldType));
            }
        }
        return number;
    }

    private final void writeSample(ByteBuffer buffer, FieldType fieldType, Number value) {
        switch (Rasters$WhenMappings.$EnumSwitchMapping$1[fieldType.ordinal()]) {
            case 1: 
            case 2: {
                buffer.put(value.byteValue());
                break;
            }
            case 3: 
            case 4: {
                buffer.putShort(value.shortValue());
                break;
            }
            case 5: 
            case 6: {
                buffer.putInt(value.intValue());
                break;
            }
            case 7: {
                buffer.putFloat(value.floatValue());
                break;
            }
            case 8: {
                buffer.putDouble(value.doubleValue());
                break;
            }
            default: {
                throw (Throwable)new TiffException("Unsupported raster field type: " + (Object)((Object)fieldType));
            }
        }
    }

    private final void writeSample(ByteBuffer outBuffer, ByteBuffer inBuffer, FieldType fieldType) {
        switch (Rasters$WhenMappings.$EnumSwitchMapping$2[fieldType.ordinal()]) {
            case 1: 
            case 2: {
                outBuffer.put(inBuffer.get());
                break;
            }
            case 3: 
            case 4: {
                outBuffer.putShort(inBuffer.getShort());
                break;
            }
            case 5: 
            case 6: {
                outBuffer.putInt(inBuffer.getInt());
                break;
            }
            case 7: {
                outBuffer.putFloat(inBuffer.getFloat());
                break;
            }
            case 8: {
                outBuffer.putDouble(inBuffer.getDouble());
                break;
            }
            default: {
                throw (Throwable)new TiffException("Unsupported raster field type: " + (Object)((Object)fieldType));
            }
        }
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final FieldType[] getFieldTypes() {
        return this.fieldTypes;
    }

    public Rasters(int width, int height, @NotNull FieldType[] fieldTypes, @Nullable ByteBuffer[] sampleValues, @Nullable ByteBuffer interleaveValues) {
        Intrinsics.checkNotNullParameter((Object)fieldTypes, (String)"fieldTypes");
        this.width = width;
        this.height = height;
        this.fieldTypes = fieldTypes;
        this.sampleValues = sampleValues;
        this.interleaveValues = interleaveValues;
        this.validateValues();
    }

    public /* synthetic */ Rasters(int n, int n2, FieldType[] fieldTypeArray, ByteBuffer[] byteBufferArray, ByteBuffer byteBuffer, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            byteBuffer = null;
        }
        this(n, n2, fieldTypeArray, byteBufferArray, byteBuffer);
    }
}

