/*
 * Decompiled with CFR 0.152.
 */
package ag.granular.tiff;

import ag.granular.io.ByteBuffer;
import ag.granular.tiff.FieldTagType;
import ag.granular.tiff.FieldType;
import ag.granular.tiff.FileDirectoryEntry;
import ag.granular.tiff.FileDirectoryKt;
import ag.granular.tiff.ImageWindow;
import ag.granular.tiff.Rasters;
import ag.granular.tiff.TypedRasters;
import ag.granular.tiff.TypedSample;
import ag.granular.tiff.compression.CompressionDecoder;
import ag.granular.tiff.compression.DeflateCompression;
import ag.granular.tiff.compression.LZWCompression;
import ag.granular.tiff.compression.PackbitsCompression;
import ag.granular.tiff.compression.RawCompression;
import ag.granular.tiff.io.ByteReader;
import ag.granular.tiff.util.TiffException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b#\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b+\u0018\u00002\u00020\u0001B-\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020\u0004J\u0016\u0010`\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010a\u001a\u00020\rH\u0002J\u0016\u0010b\u001a\b\u0012\u0004\u0012\u00020L0\f2\u0006\u0010a\u001a\u00020LH\u0002J\u0011\u0010c\u001a\u00020\u00042\u0006\u0010d\u001a\u00020%H\u0086\u0002J\f\u0010e\u001a\b\u0012\u0004\u0012\u00020\u00040fJ\u001b\u0010g\u001a\u0002Hh\"\u0004\b\u0000\u0010h2\u0006\u0010d\u001a\u00020%H\u0002\u00a2\u0006\u0002\u0010iJ\u0012\u0010j\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00040kJ\u000e\u0010l\u001a\u00020m2\u0006\u0010n\u001a\u00020\rJ\u000e\u0010o\u001a\u00020\r2\u0006\u0010d\u001a\u00020%J\u0016\u0010p\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010d\u001a\u00020%J\u0016\u0010q\u001a\n\u0012\u0004\u0012\u00020L\u0018\u00010\f2\u0006\u0010d\u001a\u00020%J\u0015\u0010r\u001a\u0004\u0018\u00010\r2\u0006\u0010d\u001a\u00020%\u00a2\u0006\u0002\u0010sJ\u000e\u0010t\u001a\u00020(2\u0006\u0010d\u001a\u00020%J\u0016\u0010u\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010\f2\u0006\u0010d\u001a\u00020%J\r\u0010v\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010w\u001a\u00020\r2\u0006\u0010n\u001a\u00020\rH\u0002J\u0010\u0010x\u001a\u0004\u0018\u00010y2\u0006\u0010d\u001a\u00020%J \u0010z\u001a\u00020\u00172\u0006\u0010{\u001a\u00020\r2\u0006\u0010|\u001a\u00020\r2\u0006\u0010}\u001a\u00020\rH\u0002J\u0006\u0010~\u001a\u00020\rJ\u0006\u0010\u007f\u001a\u00020RJ\u001e\u0010\u007f\u001a\u00020R2\b\u0010\u0080\u0001\u001a\u00030\u0081\u00012\f\b\u0002\u0010\u0082\u0001\u001a\u0005\u0018\u00010\u0083\u0001J\u0010\u0010\u007f\u001a\u00020R2\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001J&\u0010\u0084\u0001\u001a\u00020^2\b\u0010\u0080\u0001\u001a\u00030\u0081\u00012\b\u0010\u0082\u0001\u001a\u00030\u0083\u00012\u0007\u0010\u0085\u0001\u001a\u00020RH\u0002J\u0007\u0010\u0086\u0001\u001a\u00020RJ#\u0010\u0086\u0001\u001a\u00020R2\b\u0010\u0080\u0001\u001a\u00030\u0081\u00012\u0007\u0010\u0087\u0001\u001a\u00020\t2\u0007\u0010\u0088\u0001\u001a\u00020\tJ5\u0010\u0086\u0001\u001a\u00020R2\b\u0010\u0080\u0001\u001a\u00030\u0081\u00012\f\b\u0002\u0010\u0082\u0001\u001a\u0005\u0018\u00010\u0083\u00012\t\b\u0002\u0010\u0087\u0001\u001a\u00020\t2\t\b\u0002\u0010\u0088\u0001\u001a\u00020\tJ\u0019\u0010\u0086\u0001\u001a\u00020R2\u0007\u0010\u0087\u0001\u001a\u00020\t2\u0007\u0010\u0088\u0001\u001a\u00020\tJ\u0011\u0010\u0086\u0001\u001a\u00020R2\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001J#\u0010\u0086\u0001\u001a\u00020R2\b\u0010\u0082\u0001\u001a\u00030\u0083\u00012\u0007\u0010\u0087\u0001\u001a\u00020\t2\u0007\u0010\u0088\u0001\u001a\u00020\tJ\b\u0010\u0089\u0001\u001a\u00030\u008a\u0001J\u001a\u0010\u008b\u0001\u001a\u00020(2\u0006\u0010\u0006\u001a\u00020\u00072\u0007\u0010\u008c\u0001\u001a\u00020mH\u0002J\u000e\u0010\u0010\u001a\u00020^2\u0006\u0010\u000b\u001a\u00020\rJ\u000f\u0010\u008d\u0001\u001a\u00020^2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u001a\u001a\u00020^2\u0006\u0010\u0018\u001a\u00020\rJ\u000f\u0010\u008e\u0001\u001a\u00020^2\u0006\u0010\u001b\u001a\u00020\rJ,\u0010\u008f\u0001\u001a\u00020^2\u0006\u0010d\u001a\u00020%2\u0007\u0010\u008c\u0001\u001a\u00020m2\u0007\u0010\u0090\u0001\u001a\u00020L2\u0007\u0010\u0091\u0001\u001a\u00020\u0001H\u0002J\u0010\u0010\u0092\u0001\u001a\u00020^2\u0007\u0010\u0093\u0001\u001a\u00020\rJ\u0010\u0010\u0094\u0001\u001a\u00020^2\u0007\u0010\u0093\u0001\u001a\u00020LJ\u0010\u0010\u0095\u0001\u001a\u00020^2\u0007\u0010\u0096\u0001\u001a\u00020\rJ\u0010\u0010\u0097\u0001\u001a\u00020^2\u0007\u0010\u0096\u0001\u001a\u00020LJ\u000f\u0010\u0098\u0001\u001a\u00020^2\u0006\u00105\u001a\u00020\rJ\u000f\u0010\u0099\u0001\u001a\u00020^2\u0006\u00107\u001a\u00020\rJ\u000f\u0010\u009a\u0001\u001a\u00020^2\u0006\u00108\u001a\u00020\rJ\u000f\u0010\u009b\u0001\u001a\u00020^2\u0006\u0010:\u001a\u00020\rJ\u000f\u0010\u009c\u0001\u001a\u00020^2\u0006\u0010:\u001a\u00020LJ\u000e\u0010>\u001a\u00020^2\u0006\u0010<\u001a\u00020\rJ\u0017\u0010\u009d\u0001\u001a\u00020^2\u0006\u0010d\u001a\u00020%2\u0006\u0010a\u001a\u00020yJ\u0010\u0010\u009e\u0001\u001a\u00020^2\u0007\u0010\u009f\u0001\u001a\u00020\rJ\u0010\u0010\u009e\u0001\u001a\u00020^2\u0007\u0010\u009f\u0001\u001a\u00020LJ\u0015\u0010\u009e\u0001\u001a\u00020^2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0015\u0010\u00a0\u0001\u001a\u00020^2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020L0\fJ\u0010\u0010\u00a1\u0001\u001a\u00020^2\u0007\u0010\u00a2\u0001\u001a\u00020\rJ\u0010\u0010\u00a1\u0001\u001a\u00020^2\u0007\u0010\u00a2\u0001\u001a\u00020LJ\u0015\u0010\u00a1\u0001\u001a\u00020^2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0015\u0010\u00a3\u0001\u001a\u00020^2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020L0\fJ\u0010\u0010\u00a4\u0001\u001a\u00020^2\u0007\u0010\u00a5\u0001\u001a\u00020\rJ\u0010\u0010\u00a4\u0001\u001a\u00020^2\u0007\u0010\u00a5\u0001\u001a\u00020LJ\u0015\u0010\u00a4\u0001\u001a\u00020^2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0015\u0010\u00a6\u0001\u001a\u00020^2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020L0\fJ\u000f\u0010\u00a7\u0001\u001a\u00020^2\u0006\u0010I\u001a\u00020\rJ\u000f\u0010\u00a8\u0001\u001a\u00020^2\u0006\u0010I\u001a\u00020LJ\u000f\u0010N\u001a\u00020^2\u0007\u0010\u00a9\u0001\u001a\u00020LJ\u000f\u0010\u00aa\u0001\u001a\u00020^2\u0006\u0010O\u001a\u00020\rJ\u000f\u0010\u00ab\u0001\u001a\u00020^2\u0006\u0010O\u001a\u00020LJ\u0017\u0010\u00ac\u0001\u001a\u00020^2\u0006\u0010d\u001a\u00020%2\u0006\u0010a\u001a\u00020\rJ\u001d\u0010\u00ad\u0001\u001a\u00020^2\u0006\u0010d\u001a\u00020%2\f\u0010a\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0017\u0010\u00ae\u0001\u001a\u00020^2\u0006\u0010d\u001a\u00020%2\u0006\u0010a\u001a\u00020LJ\u001d\u0010\u00af\u0001\u001a\u00020^2\u0006\u0010d\u001a\u00020%2\f\u0010a\u001a\b\u0012\u0004\u0012\u00020L0\fJ\u000e\u0010Y\u001a\u00020^2\u0006\u0010W\u001a\u00020LJ\u000e\u0010\\\u001a\u00020^2\u0006\u0010Z\u001a\u00020LJ\u0007\u0010\u00b0\u0001\u001a\u00020LJ\u0007\u0010\u00b1\u0001\u001a\u00020LJ,\u0010\u00b2\u0001\u001a\u00020\r2\u000f\u0010\u0091\u0001\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0007\u0010\u00b3\u0001\u001a\u00020\r2\u0007\u0010\u00b4\u0001\u001a\u00020\rH\u0002R4\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R4\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u000f\"\u0004\b\u001a\u0010\u0011R\u0013\u0010\u001b\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\"\u0010 \u001a\u0004\u0018\u00010\u001f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010#\u001a\u001e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00040$j\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u0004`&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010'\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010*R\u0011\u0010-\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0010\u0010/\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u00101\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u001dR\u0013\u00103\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u001dR\u0013\u00105\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u001dR\u000e\u00107\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u00108\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u001dR\u0013\u0010:\u001a\u0004\u0018\u00010(8F\u00a2\u0006\u0006\u001a\u0004\b;\u0010*R4\u0010<\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u000e\u0010<\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b=\u0010\u000f\"\u0004\b>\u0010\u0011R$\u0010?\u001a\u00020\r2\u0006\u0010?\u001a\u00020\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b@\u0010\u0014\"\u0004\bA\u0010BR\u0019\u0010C\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\bD\u0010\u000fR\u0019\u0010E\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\bF\u0010\u000fR\u0019\u0010G\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\bH\u0010\u000fR\u0013\u0010I\u001a\u0004\u0018\u00010(8F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010*R4\u0010K\u001a\n\u0012\u0004\u0012\u00020L\u0018\u00010\f2\u000e\u0010K\u001a\n\u0012\u0004\u0012\u00020L\u0018\u00010\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bM\u0010\u000f\"\u0004\bN\u0010\u0011R\u0013\u0010O\u001a\u0004\u0018\u00010(8F\u00a2\u0006\u0006\u001a\u0004\bP\u0010*R\u001c\u0010Q\u001a\u0004\u0018\u00010RX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010T\"\u0004\bU\u0010VR4\u0010W\u001a\n\u0012\u0004\u0012\u00020L\u0018\u00010\f2\u000e\u0010W\u001a\n\u0012\u0004\u0012\u00020L\u0018\u00010\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bX\u0010\u000f\"\u0004\bY\u0010\u0011R4\u0010Z\u001a\n\u0012\u0004\u0012\u00020L\u0018\u00010\f2\u000e\u0010Z\u001a\n\u0012\u0004\u0012\u00020L\u0018\u00010\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b[\u0010\u000f\"\u0004\b\\\u0010\u0011\u00a8\u0006\u00b5\u0001"}, d2={"Lag/granular/tiff/FileDirectory;", "", "entries", "Ljava/util/LinkedHashSet;", "Lag/granular/tiff/FileDirectoryEntry;", "Lkotlin/collections/LinkedHashSet;", "reader", "Lag/granular/tiff/io/ByteReader;", "cacheData", "", "(Ljava/util/LinkedHashSet;Lag/granular/tiff/io/ByteReader;Z)V", "bitsPerSample", "", "", "getBitsPerSample", "()Ljava/util/List;", "setBitsPerSample", "(Ljava/util/List;)V", "bytesPerPixel", "getBytesPerPixel", "()I", "cache", "", "", "colorMap", "getColorMap", "setColorMap", "compression", "getCompression", "()Ljava/lang/Integer;", "<set-?>", "Lag/granular/tiff/compression/CompressionDecoder;", "decoder", "getDecoder", "()Lag/granular/tiff/compression/CompressionDecoder;", "fieldTagTypeMapping", "Ljava/util/HashMap;", "Lag/granular/tiff/FieldTagType;", "Lkotlin/collections/HashMap;", "imageHeight", "", "getImageHeight", "()Ljava/lang/Number;", "imageWidth", "getImageWidth", "isTiled", "()Z", "lastBlock", "lastBlockIndex", "maxBitsPerSample", "getMaxBitsPerSample", "maxSampleFormat", "getMaxSampleFormat", "photometricInterpretation", "getPhotometricInterpretation", "planarConfiguration", "resolutionUnit", "getResolutionUnit", "rowsPerStrip", "getRowsPerStrip", "sampleFormat", "getSampleFormat", "setSampleFormat", "samplesPerPixel", "getSamplesPerPixel", "setSamplesPerPixel", "(I)V", "stripByteCounts", "getStripByteCounts", "stripOffsets", "getStripOffsets", "tileByteCounts", "getTileByteCounts", "tileHeight", "getTileHeight", "tileOffsets", "", "getTileOffsets", "setTileOffsets", "tileWidth", "getTileWidth", "writeRasters", "Lag/granular/tiff/Rasters;", "getWriteRasters", "()Lag/granular/tiff/Rasters;", "setWriteRasters", "(Lag/granular/tiff/Rasters;)V", "xResolution", "getXResolution", "setXResolution", "yResolution", "getYResolution", "setYResolution", "addEntry", "", "entry", "createSingleIntegerList", "value", "createSingleLongList", "get", "fieldTagType", "getEntries", "", "getEntryValue", "T", "(Lag/granular/tiff/FieldTagType;)Ljava/lang/Object;", "getFieldTagTypeMapping", "", "getFieldTypeForSample", "Lag/granular/tiff/FieldType;", "sampleIndex", "getIntegerEntryValue", "getIntegerListEntryValue", "getLongListEntryValue", "getMaxIntegerEntryValue", "(Lag/granular/tiff/FieldTagType;)Ljava/lang/Integer;", "getNumberEntryValue", "getNumberListEntryValue", "getPlanarConfiguration", "getSampleByteSize", "getStringEntryValue", "", "getTileOrStrip", "x", "y", "sample", "numEntries", "readInterleavedRasters", "window", "Lag/granular/tiff/ImageWindow;", "samples", "", "readRaster", "rasters", "readRasters", "sampleValues", "interleaveValues", "readTypedRasters", "Lag/granular/tiff/TypedRasters;", "readValue", "fieldType", "setCache", "setCompression", "setEntryValue", "typeCount", "values", "setImageHeight", "height", "setImageHeightAsLong", "setImageWidth", "width", "setImageWidthAsLong", "setPhotometricInterpretation", "setPlanarConfiguration", "setResolutionUnit", "setRowsPerStrip", "setRowsPerStripAsLong", "setStringEntryValue", "setStripByteCounts", "stripByteCount", "setStripByteCountsAsLongs", "setStripOffsets", "stripOffset", "setStripOffsetsAsLongs", "setTileByteCounts", "tileByteCount", "setTileByteCountsAsLongs", "setTileHeight", "setTileHeightAsLong", "tileOffset", "setTileWidth", "setTileWidthAsLong", "setUnsignedIntegerEntryValue", "setUnsignedIntegerListEntryValue", "setUnsignedLongEntryValue", "setUnsignedLongListEntryValue", "size", "sizeWithValues", "sum", "start", "end", "tiffany"})
public final class FileDirectory {
    @NotNull
    private final LinkedHashSet<FileDirectoryEntry> entries;
    @NotNull
    private final ByteReader reader;
    @NotNull
    private final HashMap<FieldTagType, FileDirectoryEntry> fieldTagTypeMapping;
    private final boolean isTiled;
    private final int planarConfiguration;
    @Nullable
    private CompressionDecoder decoder;
    @Nullable
    private Map<Integer, byte[]> cache;
    @Nullable
    private Rasters writeRasters;
    private int lastBlockIndex;
    @Nullable
    private byte[] lastBlock;

    public FileDirectory(@NotNull LinkedHashSet<FileDirectoryEntry> entries, @NotNull ByteReader reader, boolean cacheData) {
        Integer pc;
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.entries = entries;
        this.reader = reader;
        this.fieldTagTypeMapping = new HashMap();
        this.lastBlockIndex = -1;
        for (FileDirectoryEntry entry : this.entries) {
            Map map = this.fieldTagTypeMapping;
            FieldTagType fieldTagType = entry.getFieldTag();
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"entry");
            map.put(fieldTagType, entry);
        }
        this.setCache(cacheData);
        this.isTiled = this.getRowsPerStrip() == null;
        Integer n = pc = this.getPlanarConfiguration();
        int n2 = this.planarConfiguration = n != null ? n : 1;
        if (this.planarConfiguration != 1 && this.planarConfiguration != 2) {
            throw new TiffException("Invalid planar configuration: " + this.planarConfiguration);
        }
        Integer compression = this.getCompression();
        if (compression == null) {
            compression = 1;
        }
        switch (compression) {
            case 1: {
                this.decoder = new RawCompression();
                break;
            }
            case 2: {
                throw new TiffException("CCITT Huffman compression not supported: " + compression);
            }
            case 3: {
                throw new TiffException("T4-encoding compression not supported: " + compression);
            }
            case 4: {
                throw new TiffException("T6-encoding compression not supported: " + compression);
            }
            case 5: {
                this.decoder = new LZWCompression();
                break;
            }
            case 6: 
            case 7: {
                throw new TiffException("JPEG compression not supported: " + compression);
            }
            case 8: 
            case 32946: {
                this.decoder = new DeflateCompression();
                break;
            }
            case 32773: {
                this.decoder = new PackbitsCompression();
                break;
            }
            default: {
                throw new TiffException("Unknown compression method identifier: " + compression);
            }
        }
    }

    public final boolean isTiled() {
        return this.isTiled;
    }

    @Nullable
    public final CompressionDecoder getDecoder() {
        return this.decoder;
    }

    @Nullable
    public final Rasters getWriteRasters() {
        return this.writeRasters;
    }

    public final void setWriteRasters(@Nullable Rasters rasters) {
        this.writeRasters = rasters;
    }

    @NotNull
    public final Number getImageWidth() {
        Number number = this.getNumberEntryValue(FieldTagType.ImageWidth);
        Intrinsics.checkNotNull((Object)number);
        return number;
    }

    @NotNull
    public final Number getImageHeight() {
        Number number = this.getNumberEntryValue(FieldTagType.ImageLength);
        Intrinsics.checkNotNull((Object)number);
        return number;
    }

    @Nullable
    public final List<Integer> getBitsPerSample() {
        return this.getIntegerListEntryValue(FieldTagType.BitsPerSample);
    }

    public final void setBitsPerSample(@Nullable List<Integer> bitsPerSample) {
        List<Integer> list = bitsPerSample;
        Intrinsics.checkNotNull(list);
        this.setUnsignedIntegerListEntryValue(FieldTagType.BitsPerSample, list);
    }

    @Nullable
    public final Integer getMaxBitsPerSample() {
        return this.getMaxIntegerEntryValue(FieldTagType.BitsPerSample);
    }

    @Nullable
    public final Integer getCompression() {
        return this.getIntegerEntryValue(FieldTagType.Compression);
    }

    @Nullable
    public final Integer getPhotometricInterpretation() {
        return this.getIntegerEntryValue(FieldTagType.PhotometricInterpretation);
    }

    @Nullable
    public final List<Number> getStripOffsets() {
        return this.getNumberListEntryValue(FieldTagType.StripOffsets);
    }

    public final int getSamplesPerPixel() {
        int samplesPerPixel = this.getIntegerEntryValue(FieldTagType.SamplesPerPixel);
        return samplesPerPixel;
    }

    public final void setSamplesPerPixel(int samplesPerPixel) {
        this.setUnsignedIntegerEntryValue(FieldTagType.SamplesPerPixel, samplesPerPixel);
    }

    @Nullable
    public final Number getRowsPerStrip() {
        Number number;
        try {
            number = this.getNumberEntryValue(FieldTagType.RowsPerStrip);
        }
        catch (TiffException err) {
            number = null;
        }
        return number;
    }

    @Nullable
    public final List<Number> getStripByteCounts() {
        return this.getNumberListEntryValue(FieldTagType.StripByteCounts);
    }

    @Nullable
    public final List<Long> getXResolution() {
        return this.getLongListEntryValue(FieldTagType.XResolution);
    }

    public final void setXResolution(@Nullable List<Long> xResolution) {
        List<Long> list = xResolution;
        Intrinsics.checkNotNull(list);
        this.setUnsignedLongListEntryValue(FieldTagType.XResolution, list);
    }

    @Nullable
    public final List<Long> getYResolution() {
        return this.getLongListEntryValue(FieldTagType.YResolution);
    }

    public final void setYResolution(@Nullable List<Long> yResolution) {
        List<Long> list = yResolution;
        Intrinsics.checkNotNull(list);
        this.setUnsignedLongListEntryValue(FieldTagType.YResolution, list);
    }

    @Nullable
    public final Integer getResolutionUnit() {
        return this.getIntegerEntryValue(FieldTagType.ResolutionUnit);
    }

    @Nullable
    public final List<Integer> getColorMap() {
        return this.getIntegerListEntryValue(FieldTagType.ColorMap);
    }

    public final void setColorMap(@Nullable List<Integer> colorMap) {
        List<Integer> list = colorMap;
        Intrinsics.checkNotNull(list);
        this.setUnsignedIntegerListEntryValue(FieldTagType.ColorMap, list);
    }

    @Nullable
    public final Number getTileWidth() {
        return this.isTiled ? (Number)this.getNumberEntryValue(FieldTagType.TileWidth) : (Number)this.getImageWidth();
    }

    @Nullable
    public final Number getTileHeight() {
        return this.isTiled ? (Number)this.getNumberEntryValue(FieldTagType.TileLength) : (Number)this.getRowsPerStrip();
    }

    @Nullable
    public final List<Long> getTileOffsets() {
        return this.getLongListEntryValue(FieldTagType.TileOffsets);
    }

    public final void setTileOffsets(@Nullable List<Long> tileOffsets) {
        List<Long> list = tileOffsets;
        Intrinsics.checkNotNull(list);
        this.setUnsignedLongListEntryValue(FieldTagType.TileOffsets, list);
    }

    @Nullable
    public final List<Number> getTileByteCounts() {
        return this.getNumberListEntryValue(FieldTagType.TileByteCounts);
    }

    @Nullable
    public final List<Integer> getSampleFormat() {
        return this.getIntegerListEntryValue(FieldTagType.SampleFormat);
    }

    public final void setSampleFormat(@Nullable List<Integer> sampleFormat) {
        List<Integer> list = sampleFormat;
        Intrinsics.checkNotNull(list);
        this.setUnsignedIntegerListEntryValue(FieldTagType.SampleFormat, list);
    }

    @Nullable
    public final Integer getMaxSampleFormat() {
        return this.getMaxIntegerEntryValue(FieldTagType.SampleFormat);
    }

    private final int getBytesPerPixel() {
        int bitsPerSample = 0;
        List<Integer> list = this.getBitsPerSample();
        Intrinsics.checkNotNull(list);
        List<Integer> bitsPerSamples = list;
        int n = bitsPerSamples.size();
        for (int i = 0; i < n; ++i) {
            int bits = ((Number)bitsPerSamples.get(i)).intValue();
            if (bits % 8 != 0) {
                throw new TiffException("Sample bit-width of " + bits + " is not supported");
            }
            if (bits != ((Number)bitsPerSamples.get(0)).intValue()) {
                throw new TiffException("Differing size of samples in a pixel are not supported. sample 0 = " + ((Number)bitsPerSamples.get(0)).intValue() + ", sample " + i + " = " + bits);
            }
            bitsPerSample += bits;
        }
        return bitsPerSample / 8;
    }

    public final void addEntry(@NotNull FileDirectoryEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.entries.remove(entry);
        this.entries.add(entry);
        ((Map)this.fieldTagTypeMapping).put(entry.getFieldTag(), entry);
    }

    public final void setCache(boolean cacheData) {
        if (cacheData) {
            if (this.cache == null) {
                this.cache = new HashMap();
            }
        } else {
            this.cache = null;
        }
    }

    public final int numEntries() {
        return this.entries.size();
    }

    @NotNull
    public final FileDirectoryEntry get(@NotNull FieldTagType fieldTagType) {
        Intrinsics.checkNotNullParameter((Object)((Object)fieldTagType), (String)"fieldTagType");
        FileDirectoryEntry fileDirectoryEntry = this.fieldTagTypeMapping.get((Object)fieldTagType);
        Intrinsics.checkNotNull((Object)fileDirectoryEntry);
        return fileDirectoryEntry;
    }

    @NotNull
    public final Set<FileDirectoryEntry> getEntries() {
        return CollectionsKt.toSet((Iterable)this.entries);
    }

    @NotNull
    public final Map<FieldTagType, FileDirectoryEntry> getFieldTagTypeMapping() {
        return MapsKt.toMap((Map)this.fieldTagTypeMapping);
    }

    public final void setImageWidth(int width) {
        this.setUnsignedIntegerEntryValue(FieldTagType.ImageWidth, width);
    }

    public final void setImageWidthAsLong(long width) {
        this.setUnsignedLongEntryValue(FieldTagType.ImageWidth, width);
    }

    public final void setImageHeight(int height) {
        this.setUnsignedIntegerEntryValue(FieldTagType.ImageLength, height);
    }

    public final void setImageHeightAsLong(long height) {
        this.setUnsignedLongEntryValue(FieldTagType.ImageLength, height);
    }

    public final void setBitsPerSample(int bitsPerSample) {
        this.setBitsPerSample(this.createSingleIntegerList(bitsPerSample));
    }

    public final void setCompression(int compression) {
        this.setUnsignedIntegerEntryValue(FieldTagType.Compression, compression);
    }

    public final void setPhotometricInterpretation(int photometricInterpretation) {
        this.setUnsignedIntegerEntryValue(FieldTagType.PhotometricInterpretation, photometricInterpretation);
    }

    public final void setStripOffsets(@NotNull List<Integer> stripOffsets) {
        Intrinsics.checkNotNullParameter(stripOffsets, (String)"stripOffsets");
        this.setUnsignedIntegerListEntryValue(FieldTagType.StripOffsets, stripOffsets);
    }

    public final void setStripOffsetsAsLongs(@NotNull List<Long> stripOffsets) {
        Intrinsics.checkNotNullParameter(stripOffsets, (String)"stripOffsets");
        this.setUnsignedLongListEntryValue(FieldTagType.StripOffsets, stripOffsets);
    }

    public final void setStripOffsets(int stripOffset) {
        this.setStripOffsets(this.createSingleIntegerList(stripOffset));
    }

    public final void setStripOffsets(long stripOffset) {
        this.setStripOffsetsAsLongs(this.createSingleLongList(stripOffset));
    }

    public final void setRowsPerStrip(int rowsPerStrip) {
        this.setUnsignedIntegerEntryValue(FieldTagType.RowsPerStrip, rowsPerStrip);
    }

    public final void setRowsPerStripAsLong(long rowsPerStrip) {
        this.setUnsignedLongEntryValue(FieldTagType.RowsPerStrip, rowsPerStrip);
    }

    public final void setStripByteCounts(@NotNull List<Integer> stripByteCounts) {
        Intrinsics.checkNotNullParameter(stripByteCounts, (String)"stripByteCounts");
        this.setUnsignedIntegerListEntryValue(FieldTagType.StripByteCounts, stripByteCounts);
    }

    public final void setStripByteCountsAsLongs(@NotNull List<Long> stripByteCounts) {
        Intrinsics.checkNotNullParameter(stripByteCounts, (String)"stripByteCounts");
        this.setUnsignedLongListEntryValue(FieldTagType.StripByteCounts, stripByteCounts);
    }

    public final void setStripByteCounts(int stripByteCount) {
        this.setStripByteCounts(this.createSingleIntegerList(stripByteCount));
    }

    public final void setStripByteCounts(long stripByteCount) {
        this.setStripByteCountsAsLongs(this.createSingleLongList(stripByteCount));
    }

    public final void setXResolution(long xResolution) {
        this.setXResolution(this.createSingleLongList(xResolution));
    }

    public final void setYResolution(long yResolution) {
        this.setYResolution(this.createSingleLongList(yResolution));
    }

    @Nullable
    public final Integer getPlanarConfiguration() {
        return this.getIntegerEntryValue(FieldTagType.PlanarConfiguration);
    }

    public final void setPlanarConfiguration(int planarConfiguration) {
        this.setUnsignedIntegerEntryValue(FieldTagType.PlanarConfiguration, planarConfiguration);
    }

    public final void setResolutionUnit(int resolutionUnit) {
        this.setUnsignedIntegerEntryValue(FieldTagType.ResolutionUnit, resolutionUnit);
    }

    public final void setColorMap(int colorMap) {
        this.setColorMap(this.createSingleIntegerList(colorMap));
    }

    public final void setTileWidth(int tileWidth) {
        this.setUnsignedIntegerEntryValue(FieldTagType.TileWidth, tileWidth);
    }

    public final void setTileWidthAsLong(long tileWidth) {
        this.setUnsignedLongEntryValue(FieldTagType.TileWidth, tileWidth);
    }

    public final void setTileHeight(int tileHeight) {
        this.setUnsignedIntegerEntryValue(FieldTagType.TileLength, tileHeight);
    }

    public final void setTileHeightAsLong(long tileHeight) {
        this.setUnsignedLongEntryValue(FieldTagType.TileLength, tileHeight);
    }

    public final void setTileOffsets(long tileOffset) {
        this.setTileOffsets(this.createSingleLongList(tileOffset));
    }

    public final void setTileByteCounts(@NotNull List<Integer> tileByteCounts) {
        Intrinsics.checkNotNullParameter(tileByteCounts, (String)"tileByteCounts");
        this.setUnsignedIntegerListEntryValue(FieldTagType.TileByteCounts, tileByteCounts);
    }

    public final void setTileByteCountsAsLongs(@NotNull List<Long> tileByteCounts) {
        Intrinsics.checkNotNullParameter(tileByteCounts, (String)"tileByteCounts");
        this.setUnsignedLongListEntryValue(FieldTagType.TileByteCounts, tileByteCounts);
    }

    public final void setTileByteCounts(int tileByteCount) {
        this.setTileByteCounts(this.createSingleIntegerList(tileByteCount));
    }

    public final void setTileByteCounts(long tileByteCount) {
        this.setTileByteCountsAsLongs(this.createSingleLongList(tileByteCount));
    }

    public final void setSampleFormat(int sampleFormat) {
        this.setSampleFormat(this.createSingleIntegerList(sampleFormat));
    }

    @NotNull
    public final Rasters readRasters() {
        return FileDirectory.readRasters$default(this, FileDirectoryKt.getWindow(this), null, false, false, 14, null);
    }

    @NotNull
    public final Rasters readInterleavedRasters() {
        return FileDirectory.readInterleavedRasters$default(this, FileDirectoryKt.getWindow(this), null, 2, null);
    }

    @NotNull
    public final Rasters readRasters(@NotNull int[] samples) {
        Intrinsics.checkNotNullParameter((Object)samples, (String)"samples");
        return FileDirectory.readRasters$default(this, FileDirectoryKt.getWindow(this), samples, false, false, 12, null);
    }

    @NotNull
    public final Rasters readInterleavedRasters(@NotNull int[] samples) {
        Intrinsics.checkNotNullParameter((Object)samples, (String)"samples");
        return this.readInterleavedRasters(FileDirectoryKt.getWindow(this), samples);
    }

    @NotNull
    public final Rasters readInterleavedRasters(@NotNull ImageWindow window, @Nullable int[] samples) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        return this.readRasters(window, samples, false, true);
    }

    public static /* synthetic */ Rasters readInterleavedRasters$default(FileDirectory fileDirectory, ImageWindow imageWindow, int[] nArray, int n, Object object) {
        if ((n & 2) != 0) {
            nArray = null;
        }
        return fileDirectory.readInterleavedRasters(imageWindow, nArray);
    }

    @NotNull
    public final Rasters readRasters(boolean sampleValues, boolean interleaveValues) {
        return this.readRasters(FileDirectoryKt.getWindow(this), sampleValues, interleaveValues);
    }

    @NotNull
    public final Rasters readRasters(@NotNull ImageWindow window, boolean sampleValues, boolean interleaveValues) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        return this.readRasters(window, null, sampleValues, interleaveValues);
    }

    @NotNull
    public final Rasters readRasters(@NotNull int[] samples, boolean sampleValues, boolean interleaveValues) {
        Intrinsics.checkNotNullParameter((Object)samples, (String)"samples");
        return this.readRasters(FileDirectoryKt.getWindow(this), samples, sampleValues, interleaveValues);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Rasters readRasters(@NotNull ImageWindow window, @Nullable int[] samples, boolean sampleValues, boolean interleaveValues) {
        Object object;
        int n;
        int n22;
        int i;
        int n3;
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        int[] samples2 = samples;
        Number number = this.getImageWidth();
        Intrinsics.checkNotNull((Object)number);
        int width = number.intValue();
        Number number2 = this.getImageHeight();
        Intrinsics.checkNotNull((Object)number2);
        int height = number2.intValue();
        if (window.getMinX() < 0 || window.getMinY() < 0 || window.getMaxX() > width || window.getMaxY() > height) {
            throw new TiffException("Window is out of the image bounds. Width: " + width + ", Height: " + height + ", Window: " + window);
        }
        if (window.getMinX() > window.getMaxX() || window.getMinY() > window.getMaxY()) {
            throw new TiffException("Invalid window range: " + window);
        }
        int windowWidth = window.getMaxX() - window.getMinX();
        int windowHeight = window.getMaxY() - window.getMinY();
        int numPixels = windowWidth * windowHeight;
        int samplesPerPixel = this.getSamplesPerPixel();
        if (samples2 == null) {
            samples2 = new int[samplesPerPixel];
            n3 = samples2.length;
            for (i = 0; i < n3; ++i) {
                samples2[i] = i;
            }
        } else {
            n3 = samples2.length;
            for (i = 0; i < n3; ++i) {
                if (samples2[i] < samplesPerPixel) continue;
                throw new TiffException("Invalid sample index: " + samples2[i]);
            }
        }
        List<Integer> bitsPerSample = this.getBitsPerSample();
        int bytesPerPixel = 0;
        for (int i2 = 0; i2 < samplesPerPixel; ++i2) {
            List<Integer> list = bitsPerSample;
            Intrinsics.checkNotNull(list);
            bytesPerPixel += ((Number)list.get(i2)).intValue() / 8;
        }
        ByteBuffer interleave = null;
        if (interleaveValues) {
            ByteBuffer byteBuffer;
            ByteBuffer $this$readRasters_u24lambda_u2d0 = byteBuffer = ByteBuffer.Companion.allocate(numPixels * bytesPerPixel);
            n22 = 0;
            $this$readRasters_u24lambda_u2d0.order(this.reader.getByteReaderOrder());
            interleave = byteBuffer;
        }
        ByteBuffer[] sample = null;
        if (sampleValues) {
            int $this$readRasters_u24lambda_u2d0 = 0;
            ByteBuffer[] n22 = new ByteBuffer[samplesPerPixel];
            while ($this$readRasters_u24lambda_u2d0 < samplesPerPixel) {
                void $this$readRasters_u24lambda_u2d1;
                n = $this$readRasters_u24lambda_u2d0++;
                List<Integer> list = bitsPerSample;
                Intrinsics.checkNotNull(list);
                Object object2 = object = ByteBuffer.Companion.allocate(numPixels * ((Number)list.get(n)).intValue() / 8);
                int n4 = n;
                ByteBuffer[] byteBufferArray = n22;
                boolean bl = false;
                $this$readRasters_u24lambda_u2d1.order(this.reader.getByteReaderOrder());
                Unit unit = Unit.INSTANCE;
                byteBufferArray[n4] = object;
            }
            sample = n22;
        }
        n22 = 0;
        n = samples2.length;
        object = new FieldType[n];
        while (n22 < n) {
            int n5 = n22++;
            object[n5] = this.getFieldTypeForSample(samples2[n5]);
        }
        FieldType[] fieldTypes = object;
        Rasters rasters = new Rasters(windowWidth, windowHeight, fieldTypes, sample, interleave);
        this.readRaster(window, samples2, rasters);
        return rasters;
    }

    public static /* synthetic */ Rasters readRasters$default(FileDirectory fileDirectory, ImageWindow imageWindow, int[] nArray, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            nArray = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return fileDirectory.readRasters(imageWindow, nArray, bl, bl2);
    }

    private final void readRaster(ImageWindow window, int[] samples, Rasters rasters) {
        int sampleOffset;
        Number number = this.getTileWidth();
        Intrinsics.checkNotNull((Object)number);
        int tileWidth = number.intValue();
        Number number2 = this.getTileHeight();
        Intrinsics.checkNotNull((Object)number2);
        int tileHeight = number2.intValue();
        int minXTile = window.getMinX() / tileWidth;
        int maxXTile = (window.getMaxX() + tileWidth - 1) / tileWidth;
        int minYTile = window.getMinY() / tileHeight;
        int maxYTile = (window.getMaxY() + tileHeight - 1) / tileHeight;
        int windowWidth = window.getMaxX() - window.getMinX();
        int bytesPerPixel = this.getBytesPerPixel();
        int n = samples.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            sampleOffset = 0;
            if (this.planarConfiguration == 1) {
                sampleOffset = this.sum(this.getBitsPerSample(), 0, samples[n2]) / 8;
            }
            nArray[n2] = sampleOffset;
        }
        int[] srcSampleOffsets = nArray;
        n = 0;
        int n3 = samples.length;
        FieldType[] fieldTypeArray = new FieldType[n3];
        while (n < n3) {
            sampleOffset = n++;
            fieldTypeArray[sampleOffset] = this.getFieldTypeForSample(samples[sampleOffset]);
        }
        FieldType[] sampleFieldTypes = fieldTypeArray;
        for (int yTile = minYTile; yTile < maxYTile; ++yTile) {
            for (int xTile = minXTile; xTile < maxXTile; ++xTile) {
                int firstLine = yTile * tileHeight;
                int firstCol = xTile * tileWidth;
                int lastLine = (yTile + 1) * tileHeight;
                int lastCol = (xTile + 1) * tileWidth;
                int n4 = samples.length;
                for (int sampleIndex = 0; sampleIndex < n4; ++sampleIndex) {
                    int sample = samples[sampleIndex];
                    if (this.planarConfiguration == 2) {
                        bytesPerPixel = this.getSampleByteSize(sample);
                    }
                    byte[] block = this.getTileOrStrip(xTile, yTile, sample);
                    ByteReader blockReader = new ByteReader(block, this.reader.getByteReaderOrder());
                    int n5 = Math.min(tileHeight, tileHeight - (lastLine - window.getMaxY()));
                    for (int y = Math.max(0, window.getMinY() - firstLine); y < n5; ++y) {
                        int n6 = Math.min(tileWidth, tileWidth - (lastCol - window.getMaxX()));
                        for (int x = Math.max(0, window.getMinX() - firstCol); x < n6; ++x) {
                            int windowCoordinate;
                            int pixelOffset = (y * tileWidth + x) * bytesPerPixel;
                            int valueOffset = pixelOffset + srcSampleOffsets[sampleIndex];
                            blockReader.setNextByte(valueOffset);
                            FieldType fieldType = sampleFieldTypes[sampleIndex];
                            Intrinsics.checkNotNull((Object)((Object)fieldType));
                            Number value = this.readValue(blockReader, fieldType);
                            if (rasters.hasInterleaveValues()) {
                                windowCoordinate = (y + firstLine - window.getMinY()) * windowWidth + (x + firstCol - window.getMinX());
                                rasters.addToInterleave(sampleIndex, windowCoordinate, value);
                            }
                            if (!rasters.hasSampleValues()) continue;
                            windowCoordinate = (y + firstLine - window.getMinY()) * windowWidth + x + firstCol - window.getMinX();
                            rasters.addToSample(sampleIndex, windowCoordinate, value);
                        }
                    }
                }
            }
        }
    }

    @NotNull
    public final TypedRasters readTypedRasters() {
        int sampleOffset;
        int it;
        int n;
        ImageWindow window = FileDirectoryKt.getWindow(this);
        int width = this.getImageWidth().intValue();
        int height = this.getImageHeight().intValue();
        if (window.getMinX() < 0 || window.getMinY() < 0 || window.getMaxX() > width || window.getMaxY() > height) {
            throw new TiffException("Window is out of the image bounds. Width: " + width + ", Height: " + height + ", Window: " + window);
        }
        if (window.getMinX() > window.getMaxX() || window.getMinY() > window.getMaxY()) {
            throw new TiffException("Invalid window range: " + window);
        }
        int windowWidth = window.getMaxX() - window.getMinX();
        int windowHeight = window.getMaxY() - window.getMinY();
        int numPixels = windowWidth * windowHeight;
        int samplesPerPixel = this.getSamplesPerPixel();
        List<Integer> bitsPerSample = this.getBitsPerSample();
        int bytesPerPixel = 0;
        for (int i = 0; i < samplesPerPixel; ++i) {
            List<Integer> list = bitsPerSample;
            Intrinsics.checkNotNull(list);
            bytesPerPixel += ((Number)list.get(i)).intValue() / 8;
        }
        ArrayList<TypedSample> arrayList = new ArrayList<TypedSample>(samplesPerPixel);
        for (n = 0; n < samplesPerPixel; ++n) {
            TypedSample typedSample;
            int n2;
            int n3 = n2 = n;
            ArrayList<TypedSample> arrayList2 = arrayList;
            boolean bl = false;
            FieldType fieldType = this.getFieldTypeForSample(it);
            switch (WhenMappings.$EnumSwitchMapping$0[fieldType.ordinal()]) {
                case 1: {
                    typedSample = new TypedSample.ByteSample(fieldType, new byte[numPixels]);
                    break;
                }
                case 2: {
                    typedSample = new TypedSample.ShortSample(fieldType, new short[numPixels]);
                    break;
                }
                case 3: {
                    typedSample = new TypedSample.IntSample(fieldType, new int[numPixels]);
                    break;
                }
                case 4: {
                    typedSample = new TypedSample.ByteSample(fieldType, new byte[numPixels]);
                    break;
                }
                case 5: {
                    typedSample = new TypedSample.ShortSample(fieldType, new short[numPixels]);
                    break;
                }
                case 6: {
                    typedSample = new TypedSample.IntSample(fieldType, new int[numPixels]);
                    break;
                }
                case 7: {
                    typedSample = new TypedSample.FloatSample(fieldType, new float[numPixels]);
                    break;
                }
                case 8: {
                    typedSample = new TypedSample.DoubleSample(fieldType, new double[numPixels]);
                    break;
                }
                default: {
                    throw new TiffException("Unsupported raster field type: " + (Object)((Object)fieldType));
                }
            }
            arrayList2.add(typedSample);
        }
        List samples = arrayList;
        n = 0;
        FieldType[] fieldTypeArray = new FieldType[samplesPerPixel];
        while (n < samplesPerPixel) {
            it = n++;
            fieldTypeArray[it] = this.getFieldTypeForSample(it);
        }
        FieldType[] fieldTypes = fieldTypeArray;
        Number number = this.getTileWidth();
        Intrinsics.checkNotNull((Object)number);
        int tileWidth = number.intValue();
        Number number2 = this.getTileHeight();
        Intrinsics.checkNotNull((Object)number2);
        int tileHeight = number2.intValue();
        int minXTile = window.getMinX() / tileWidth;
        int maxXTile = (window.getMaxX() + tileWidth - 1) / tileWidth;
        int minYTile = window.getMinY() / tileHeight;
        int maxYTile = (window.getMaxY() + tileHeight - 1) / tileHeight;
        int[] nArray = new int[samplesPerPixel];
        for (int i = 0; i < samplesPerPixel; ++i) {
            int n4 = i;
            sampleOffset = 0;
            if (this.planarConfiguration == 1) {
                sampleOffset = this.sum(bitsPerSample, 0, n4) / 8;
            }
            nArray[n4] = sampleOffset;
        }
        int[] srcSampleOffsets = nArray;
        int n5 = 0;
        FieldType[] fieldTypeArray2 = new FieldType[samplesPerPixel];
        while (n5 < samplesPerPixel) {
            sampleOffset = n5++;
            fieldTypeArray2[sampleOffset] = this.getFieldTypeForSample(sampleOffset);
        }
        FieldType[] sampleFieldTypes = fieldTypeArray2;
        for (int yTile = minYTile; yTile < maxYTile; ++yTile) {
            for (int xTile = minXTile; xTile < maxXTile; ++xTile) {
                int firstLine = yTile * tileHeight;
                int firstCol = xTile * tileWidth;
                int lastLine = (yTile + 1) * tileHeight;
                int lastCol = (xTile + 1) * tileWidth;
                for (int sampleIndex = 0; sampleIndex < samplesPerPixel; ++sampleIndex) {
                    if (this.planarConfiguration == 2) {
                        bytesPerPixel = this.getSampleByteSize(sampleIndex);
                    }
                    byte[] block = this.getTileOrStrip(xTile, yTile, sampleIndex);
                    ByteReader blockReader = new ByteReader(block, this.reader.getByteReaderOrder());
                    int n6 = Math.min(tileHeight, tileHeight - (lastLine - window.getMaxY()));
                    for (int y = Math.max(0, window.getMinY() - firstLine); y < n6; ++y) {
                        int n7 = Math.min(tileWidth, tileWidth - (lastCol - window.getMaxX()));
                        for (int x = Math.max(0, window.getMinX() - firstCol); x < n7; ++x) {
                            int pixelOffset = (y * tileWidth + x) * bytesPerPixel;
                            int valueOffset = pixelOffset + srcSampleOffsets[sampleIndex];
                            blockReader.setNextByte(valueOffset);
                            Number value = this.readValue(blockReader, sampleFieldTypes[sampleIndex]);
                            int windowCoordinate = (y + firstLine - window.getMinY()) * windowWidth + x + firstCol - window.getMinX();
                            TypedSample typedSample = (TypedSample)samples.get(sampleIndex);
                            if (typedSample instanceof TypedSample.ByteSample) {
                                ((TypedSample.ByteSample)typedSample).getData()[windowCoordinate] = value.byteValue();
                            } else if (typedSample instanceof TypedSample.ShortSample) {
                                ((TypedSample.ShortSample)typedSample).getData()[windowCoordinate] = value.shortValue();
                            } else if (typedSample instanceof TypedSample.IntSample) {
                                ((TypedSample.IntSample)typedSample).getData()[windowCoordinate] = value.intValue();
                            } else if (typedSample instanceof TypedSample.FloatSample) {
                                ((TypedSample.FloatSample)typedSample).getData()[windowCoordinate] = value.floatValue();
                            } else if (typedSample instanceof TypedSample.DoubleSample) {
                                ((TypedSample.DoubleSample)typedSample).getData()[windowCoordinate] = value.doubleValue();
                            } else {
                                throw new NoWhenBranchMatchedException();
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                }
            }
        }
        return new TypedRasters(windowWidth, windowHeight, samples);
    }

    private final Number readValue(ByteReader reader, FieldType fieldType) {
        Number number;
        switch (WhenMappings.$EnumSwitchMapping$0[fieldType.ordinal()]) {
            case 1: {
                number = reader.readUnsignedByte();
                break;
            }
            case 2: {
                number = reader.readUnsignedShort();
                break;
            }
            case 3: {
                number = reader.readUnsignedInt();
                break;
            }
            case 4: {
                number = reader.readByte();
                break;
            }
            case 5: {
                number = reader.readShort();
                break;
            }
            case 6: {
                number = reader.readInt();
                break;
            }
            case 7: {
                number = Float.valueOf(reader.readFloat());
                break;
            }
            case 8: {
                number = reader.readDouble();
                break;
            }
            default: {
                throw new TiffException("Unsupported raster field type: " + (Object)((Object)fieldType));
            }
        }
        return number;
    }

    @NotNull
    public final FieldType getFieldTypeForSample(int sampleIndex) {
        List<Integer> sampleFormatList = this.getSampleFormat();
        int sampleFormat = sampleFormatList == null ? 1 : ((Number)sampleFormatList.get(sampleIndex < sampleFormatList.size() ? sampleIndex : 0)).intValue();
        List<Integer> list = this.getBitsPerSample();
        Intrinsics.checkNotNull(list);
        int bitsPerSample = ((Number)list.get(sampleIndex)).intValue();
        return FieldType.Companion.getFieldType(sampleFormat, bitsPerSample);
    }

    /*
     * Unable to fully structure code
     */
    private final byte[] getTileOrStrip(int x, int y, int sample) {
        tileOrStrip = null;
        v0 = this.getImageWidth();
        Intrinsics.checkNotNull((Object)v0);
        imageWidth = v0.intValue();
        v1 = this.getImageHeight();
        Intrinsics.checkNotNull((Object)v1);
        imageHeight = v1.intValue();
        v2 = this.getTileWidth();
        Intrinsics.checkNotNull((Object)v2);
        tileWidth = v2.intValue();
        v3 = this.getTileHeight();
        Intrinsics.checkNotNull((Object)v3);
        tileHeight = v3.intValue();
        numTilesPerRow = (imageWidth + tileWidth - 1) / tileWidth;
        numTilesPerCol = (imageHeight + tileHeight - 1) / tileHeight;
        switch (this.planarConfiguration) {
            case 1: {
                v4 = y * numTilesPerRow + x;
                break;
            }
            case 2: {
                v4 = sample * numTilesPerRow * numTilesPerCol + y * numTilesPerRow + x;
                break;
            }
            default: {
                v4 = index = 0;
            }
        }
        if (this.cache == null) ** GOTO lbl-1000
        v5 = this.cache;
        Intrinsics.checkNotNull(v5);
        if (v5.containsKey(index)) {
            v6 = this.cache;
            Intrinsics.checkNotNull(v6);
            tileOrStrip = v6.get(index);
        } else if (this.lastBlockIndex == index && this.lastBlock != null) {
            tileOrStrip = this.lastBlock;
        } else {
            offset = 0;
            byteCount = 0;
            if (this.isTiled) {
                v7 = this.getTileOffsets();
                Intrinsics.checkNotNull(v7);
                offset = (int)((Number)v7.get(index)).longValue();
                v8 = this.getTileByteCounts();
                Intrinsics.checkNotNull(v8);
                byteCount = v8.get(index).intValue();
            } else {
                v9 = this.getStripOffsets();
                Intrinsics.checkNotNull(v9);
                offset = v9.get(index).intValue();
                v10 = this.getStripByteCounts();
                Intrinsics.checkNotNull(v10);
                byteCount = v10.get(index).intValue();
            }
            this.reader.setNextByte(offset);
            bytes = this.reader.readBytes(byteCount);
            v11 = this.decoder;
            Intrinsics.checkNotNull((Object)v11);
            tileOrStrip = v11.decode(bytes, this.reader.getByteReaderOrder());
            if (this.cache != null) {
                var15_15 = index;
                v12 = this.cache;
                Intrinsics.checkNotNull(v12);
                v12.put(var15_15, tileOrStrip);
            } else {
                this.lastBlockIndex = index;
                this.lastBlock = tileOrStrip;
            }
        }
        Intrinsics.checkNotNull((Object)tileOrStrip);
        return tileOrStrip;
    }

    private final int getSampleByteSize(int sampleIndex) {
        List<Integer> bitsPerSample;
        List<Integer> list = bitsPerSample = this.getBitsPerSample();
        Intrinsics.checkNotNull(list);
        if (sampleIndex >= list.size()) {
            throw new TiffException("Sample index " + sampleIndex + " is out of range");
        }
        int bits = ((Number)bitsPerSample.get(sampleIndex)).intValue();
        if (bits % 8 != 0) {
            throw new TiffException("Sample bit-width of " + bits + " is not supported");
        }
        return bits / 8;
    }

    public final int getIntegerEntryValue(@NotNull FieldTagType fieldTagType) {
        Intrinsics.checkNotNullParameter((Object)((Object)fieldTagType), (String)"fieldTagType");
        return ((Number)this.getEntryValue(fieldTagType)).intValue();
    }

    public final void setUnsignedIntegerEntryValue(@NotNull FieldTagType fieldTagType, int value) {
        Intrinsics.checkNotNullParameter((Object)((Object)fieldTagType), (String)"fieldTagType");
        this.setEntryValue(fieldTagType, FieldType.SHORT, 1L, value);
    }

    @NotNull
    public final Number getNumberEntryValue(@NotNull FieldTagType fieldTagType) {
        Intrinsics.checkNotNullParameter((Object)((Object)fieldTagType), (String)"fieldTagType");
        return (Number)this.getEntryValue(fieldTagType);
    }

    public final void setUnsignedLongEntryValue(@NotNull FieldTagType fieldTagType, long value) {
        Intrinsics.checkNotNullParameter((Object)((Object)fieldTagType), (String)"fieldTagType");
        this.setEntryValue(fieldTagType, FieldType.LONG, 1L, value);
    }

    @Nullable
    public final String getStringEntryValue(@NotNull FieldTagType fieldTagType) {
        Intrinsics.checkNotNullParameter((Object)((Object)fieldTagType), (String)"fieldTagType");
        String value = null;
        List values = (List)this.getEntryValue(fieldTagType);
        if (values != null && !values.isEmpty()) {
            value = (String)values.get(0);
        }
        return value;
    }

    public final void setStringEntryValue(@NotNull FieldTagType fieldTagType, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)((Object)fieldTagType), (String)"fieldTagType");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        this.setEntryValue(fieldTagType, FieldType.ASCII, value.length() + 1, values);
    }

    @Nullable
    public final List<Integer> getIntegerListEntryValue(@NotNull FieldTagType fieldTagType) {
        Intrinsics.checkNotNullParameter((Object)((Object)fieldTagType), (String)"fieldTagType");
        return (List)this.getEntryValue(fieldTagType);
    }

    public final void setUnsignedIntegerListEntryValue(@NotNull FieldTagType fieldTagType, @NotNull List<Integer> value) {
        Intrinsics.checkNotNullParameter((Object)((Object)fieldTagType), (String)"fieldTagType");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.setEntryValue(fieldTagType, FieldType.SHORT, value.size(), value);
    }

    @Nullable
    public final Integer getMaxIntegerEntryValue(@NotNull FieldTagType fieldTagType) {
        Intrinsics.checkNotNullParameter((Object)((Object)fieldTagType), (String)"fieldTagType");
        Integer maxValue = null;
        List<Integer> values = this.getIntegerListEntryValue(fieldTagType);
        if (values != null) {
            maxValue = (Integer)CollectionsKt.maxOrNull((Iterable)values);
        }
        return maxValue;
    }

    @Nullable
    public final List<Number> getNumberListEntryValue(@NotNull FieldTagType fieldTagType) {
        Intrinsics.checkNotNullParameter((Object)((Object)fieldTagType), (String)"fieldTagType");
        return (List)this.getEntryValue(fieldTagType);
    }

    @Nullable
    public final List<Long> getLongListEntryValue(@NotNull FieldTagType fieldTagType) {
        Intrinsics.checkNotNullParameter((Object)((Object)fieldTagType), (String)"fieldTagType");
        return (List)this.getEntryValue(fieldTagType);
    }

    public final void setUnsignedLongListEntryValue(@NotNull FieldTagType fieldTagType, @NotNull List<Long> value) {
        Intrinsics.checkNotNullParameter((Object)((Object)fieldTagType), (String)"fieldTagType");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.setEntryValue(fieldTagType, FieldType.LONG, value.size(), value);
    }

    private final <T> T getEntryValue(FieldTagType fieldTagType) {
        FileDirectoryEntry fileDirectoryEntry = this.fieldTagTypeMapping.get((Object)fieldTagType);
        Object object = fileDirectoryEntry != null ? fileDirectoryEntry.getValues() : null;
        if (object == null) {
            throw new TiffException("The entry value not found for " + (Object)((Object)fieldTagType) + " field tag");
        }
        return (T)object;
    }

    private final void setEntryValue(FieldTagType fieldTagType, FieldType fieldType, long typeCount, Object values) {
        FileDirectoryEntry entry = new FileDirectoryEntry(fieldTagType, fieldType, typeCount, values);
        this.addEntry(entry);
    }

    private final int sum(List<Integer> values, int start, int end) {
        int sum = 0;
        for (int i = start; i < end; ++i) {
            List<Integer> list = values;
            Intrinsics.checkNotNull(list);
            sum += ((Number)list.get(i)).intValue();
        }
        return sum;
    }

    private final List<Integer> createSingleIntegerList(int value) {
        ArrayList<Integer> valueList = new ArrayList<Integer>();
        valueList.add(value);
        return valueList;
    }

    private final List<Long> createSingleLongList(long value) {
        ArrayList<Long> valueList = new ArrayList<Long>();
        valueList.add(value);
        return valueList;
    }

    public final long size() {
        return 2 + this.entries.size() * 12 + 4;
    }

    public final long sizeWithValues() {
        long size = 6L;
        for (FileDirectoryEntry entry : this.entries) {
            size += entry.sizeWithValues();
        }
        return size;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FieldType.values().length];
            nArray[FieldType.BYTE.ordinal()] = 1;
            nArray[FieldType.SHORT.ordinal()] = 2;
            nArray[FieldType.LONG.ordinal()] = 3;
            nArray[FieldType.SBYTE.ordinal()] = 4;
            nArray[FieldType.SSHORT.ordinal()] = 5;
            nArray[FieldType.SLONG.ordinal()] = 6;
            nArray[FieldType.FLOAT.ordinal()] = 7;
            nArray[FieldType.DOUBLE.ordinal()] = 8;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

