/*
 * Decompiled with CFR 0.152.
 */
package ag.granular.tiff;

import ag.granular.io.ByteBuffer;
import ag.granular.io.ByteOrder;
import ag.granular.tiff.FieldType;
import ag.granular.tiff.util.TiffException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\b\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0017\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0006\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!J\u001e\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!J\u0018\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\b\b\u0002\u0010%\u001a\u00020\u0003J#\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010(J#\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0002\u00a2\u0006\u0002\u0010,J\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00030.J\u0018\u0010/\u001a\u0004\u0018\u00010!2\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u0003J\u0016\u00102\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u0003J\u0006\u00103\u001a\u00020\tJ!\u00104\u001a\b\u0012\u0004\u0012\u00020!0\u00062\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u0003\u00a2\u0006\u0002\u00105J\u0016\u00106\u001a\u0002072\u0006\u00101\u001a\u00020\u00032\u0006\u00108\u001a\u000209J\u001e\u0010:\u001a\u00020!2\u0006\u0010;\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u0003J\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00030.J\"\u0010=\u001a\u00020!2\b\u0010>\u001a\u0004\u0018\u00010\t2\u0006\u0010?\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J\u0016\u0010@\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u0003J\u001e\u0010A\u001a\u0002072\u0006\u00101\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u00032\u0006\u00108\u001a\u000209J\u0011\u0010B\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\u0002\u0010CJ\u0006\u0010D\u001a\u00020EJ\u0006\u0010F\u001a\u00020EJ\u0018\u0010G\u001a\u00020!2\u0006\u0010>\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u0007H\u0002J\u0018\u0010H\u001a\u00020\u00032\u0006\u0010I\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003H\u0002J\u001e\u0010J\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!J\u000e\u0010K\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\tJ)\u0010L\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u00032\f\u0010M\u001a\b\u0012\u0004\u0012\u00020!0\u0006\u00a2\u0006\u0002\u0010NJ&\u0010O\u001a\u00020\u001d2\u0006\u0010;\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!J\u0019\u0010P\u001a\u00020\u001d2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\u0002\u0010QJ\u0006\u0010R\u001a\u00020\u0003J\u0006\u0010S\u001a\u00020\u0003J*\u0010T\u001a\u00020\u001d2\b\u0010>\u001a\u0004\u0018\u00010\t2\u0006\u0010U\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010V\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u0003H\u0002J\u0010\u0010W\u001a\u00020\u001d2\u0006\u0010;\u001a\u00020\u0003H\u0002J\b\u0010X\u001a\u00020\u001dH\u0002J \u0010Y\u001a\u00020\u001d2\u0006\u0010Z\u001a\u00020\t2\u0006\u0010[\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u0007H\u0002J \u0010Y\u001a\u00020\u001d2\u0006\u0010>\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!H\u0002R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0016\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0012\u00a8\u0006\\"}, d2={"Lag/granular/tiff/Rasters;", "", "width", "", "height", "fieldTypes", "", "Lag/granular/tiff/FieldType;", "sampleValues", "Lag/granular/io/ByteBuffer;", "interleaveValues", "(II[Lag/granular/tiff/FieldType;[Lag/granular/io/ByteBuffer;Lag/granular/io/ByteBuffer;)V", "bitsPerSample", "", "getFieldTypes", "()[Lag/granular/tiff/FieldType;", "[Lag/granular/tiff/FieldType;", "getHeight", "()I", "numPixels", "getNumPixels", "pixelSize", "Ljava/lang/Integer;", "sampleFormat", "[Lag/granular/io/ByteBuffer;", "samplesPerPixel", "getSamplesPerPixel", "getWidth", "addToInterleave", "", "sampleIndex", "coordinate", "value", "", "addToSample", "calculateRowsPerStrip", "planarConfiguration", "maxBytesPerStrip", "createFieldTypeArray", "fieldType", "(ILag/granular/tiff/FieldType;)[Lag/granular/tiff/FieldType;", "bitsPerSamples", "", "sampleFormats", "([I[I)[Lag/granular/tiff/FieldType;", "getBitsPerSample", "", "getFirstPixelSample", "x", "y", "getInterleaveIndex", "getInterleaveValues", "getPixel", "(II)[Ljava/lang/Number;", "getPixelRow", "", "newOrder", "Lag/granular/io/ByteOrder;", "getPixelSample", "sample", "getSampleFormat", "getSampleFromByteBuffer", "buffer", "index", "getSampleIndex", "getSampleRow", "getSampleValues", "()[Lag/granular/io/ByteBuffer;", "hasInterleaveValues", "", "hasSampleValues", "readSample", "rowsPerStrip", "bytesPerPixel", "setFirstPixelSample", "setInterleaveValues", "setPixel", "values", "(II[Ljava/lang/Number;)V", "setPixelSample", "setSampleValues", "([Lag/granular/io/ByteBuffer;)V", "size", "sizePixel", "updateSampleInByteBuffer", "bufferIndex", "validateCoordinates", "validateSample", "validateValues", "writeSample", "outBuffer", "inBuffer", "tiffany"})
public final class Rasters {
    private final int width;
    private final int height;
    @NotNull
    private final FieldType[] fieldTypes;
    @Nullable
    private ByteBuffer[] sampleValues;
    @Nullable
    private ByteBuffer interleaveValues;
    @Nullable
    private Integer pixelSize;
    @Nullable
    private List<Integer> bitsPerSample;
    @Nullable
    private List<Integer> sampleFormat;

    public Rasters(int width, int height, @NotNull FieldType[] fieldTypes, @Nullable ByteBuffer[] sampleValues, @Nullable ByteBuffer interleaveValues) {
        Intrinsics.checkNotNullParameter((Object)fieldTypes, (String)"fieldTypes");
        this.width = width;
        this.height = height;
        this.fieldTypes = fieldTypes;
        this.sampleValues = sampleValues;
        this.interleaveValues = interleaveValues;
        this.validateValues();
    }

    public /* synthetic */ Rasters(int n, int n2, FieldType[] fieldTypeArray, ByteBuffer[] byteBufferArray, ByteBuffer byteBuffer, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            byteBuffer = null;
        }
        this(n, n2, fieldTypeArray, byteBufferArray, byteBuffer);
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final FieldType[] getFieldTypes() {
        return this.fieldTypes;
    }

    public final int getNumPixels() {
        return this.width * this.height;
    }

    public final int getSamplesPerPixel() {
        return this.fieldTypes.length;
    }

    private final void validateValues() {
        if (this.sampleValues == null && this.interleaveValues == null) {
            throw new TiffException("Results must be sample and/or interleave based");
        }
    }

    private final FieldType[] createFieldTypeArray(int samplesPerPixel, FieldType fieldType) {
        int n = 0;
        FieldType[] fieldTypeArray = new FieldType[samplesPerPixel];
        while (n < samplesPerPixel) {
            int n2 = n++;
            fieldTypeArray[n2] = fieldType;
        }
        return fieldTypeArray;
    }

    private final FieldType[] createFieldTypeArray(int[] bitsPerSamples, int[] sampleFormats) {
        if (bitsPerSamples.length != sampleFormats.length) {
            throw new TiffException("Equal number of bits per samples and sample formats expected. Bits Per Samples: " + bitsPerSamples + ", Sample Formats: " + sampleFormats);
        }
        int n = 0;
        int n2 = bitsPerSamples.length;
        FieldType[] fieldTypeArray = new FieldType[n2];
        while (n < n2) {
            int n3 = n++;
            fieldTypeArray[n3] = FieldType.Companion.getFieldType(sampleFormats[n3], bitsPerSamples[n3]);
        }
        return fieldTypeArray;
    }

    public final boolean hasSampleValues() {
        return this.sampleValues != null;
    }

    public final boolean hasInterleaveValues() {
        return this.interleaveValues != null;
    }

    private final void updateSampleInByteBuffer(ByteBuffer buffer, int bufferIndex, int sampleIndex, Number value) {
        block3: {
            block2: {
                if (bufferIndex < 0) break block2;
                ByteBuffer byteBuffer = buffer;
                Intrinsics.checkNotNull((Object)byteBuffer);
                if (bufferIndex < byteBuffer.capacity()) break block3;
            }
            StringBuilder stringBuilder = new StringBuilder().append("index: ").append(bufferIndex).append(". Buffer capacity: ");
            ByteBuffer byteBuffer = buffer;
            Intrinsics.checkNotNull((Object)byteBuffer);
            throw new IndexOutOfBoundsException(stringBuilder.append(byteBuffer.capacity()).toString());
        }
        buffer.position(bufferIndex);
        this.writeSample(buffer, this.fieldTypes[sampleIndex], value);
    }

    private final Number getSampleFromByteBuffer(ByteBuffer buffer, int index, int sampleIndex) {
        block3: {
            block2: {
                if (index < 0) break block2;
                ByteBuffer byteBuffer = buffer;
                Intrinsics.checkNotNull((Object)byteBuffer);
                if (index < byteBuffer.capacity()) break block3;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Requested index: ").append(index).append(", but size of buffer is: ");
            ByteBuffer byteBuffer = buffer;
            Intrinsics.checkNotNull((Object)byteBuffer);
            throw new IndexOutOfBoundsException(stringBuilder.append(byteBuffer.capacity()).toString());
        }
        buffer.position(index);
        return this.readSample(buffer, this.fieldTypes[sampleIndex]);
    }

    public final void addToSample(int sampleIndex, int coordinate, @NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNull((Object)this.sampleValues);
        this.updateSampleInByteBuffer(this.sampleValues[sampleIndex], coordinate * this.fieldTypes[sampleIndex].getBytes(), sampleIndex, value);
    }

    public final void addToInterleave(int sampleIndex, int coordinate, @NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int bufferPos = coordinate * this.sizePixel();
        for (int i = 0; i < sampleIndex; ++i) {
            bufferPos += this.fieldTypes[i].getBytes();
        }
        this.updateSampleInByteBuffer(this.interleaveValues, bufferPos, sampleIndex, value);
    }

    @NotNull
    public final List<Integer> getBitsPerSample() {
        List result = this.bitsPerSample;
        if (result == null) {
            result = new ArrayList(this.fieldTypes.length);
            for (FieldType fieldType : this.fieldTypes) {
                ((ArrayList)result).add(fieldType.getBits());
            }
            this.bitsPerSample = result;
        }
        return result;
    }

    @NotNull
    public final List<Integer> getSampleFormat() {
        List result = this.sampleFormat;
        if (result == null) {
            result = new ArrayList(this.fieldTypes.length);
            for (FieldType fieldType : this.fieldTypes) {
                ((ArrayList)result).add(FieldType.Companion.getSampleFormat(fieldType));
            }
            this.sampleFormat = result;
        }
        return result;
    }

    @NotNull
    public final ByteBuffer[] getSampleValues() {
        Intrinsics.checkNotNull((Object)this.sampleValues);
        int n = this.sampleValues.length;
        for (int i = 0; i < n; ++i) {
            Intrinsics.checkNotNull((Object)this.sampleValues);
            this.sampleValues[i].rewind();
        }
        Intrinsics.checkNotNull((Object)this.sampleValues);
        return this.sampleValues;
    }

    public final void setSampleValues(@NotNull ByteBuffer[] sampleValues) {
        Intrinsics.checkNotNullParameter((Object)sampleValues, (String)"sampleValues");
        this.sampleValues = sampleValues;
        this.sampleFormat = null;
        this.bitsPerSample = null;
        this.pixelSize = null;
        this.validateValues();
    }

    @NotNull
    public final ByteBuffer getInterleaveValues() {
        ByteBuffer byteBuffer = this.interleaveValues;
        Intrinsics.checkNotNull((Object)byteBuffer);
        byteBuffer.rewind();
        ByteBuffer byteBuffer2 = this.interleaveValues;
        Intrinsics.checkNotNull((Object)byteBuffer2);
        return byteBuffer2;
    }

    public final void setInterleaveValues(@NotNull ByteBuffer interleaveValues) {
        Intrinsics.checkNotNullParameter((Object)interleaveValues, (String)"interleaveValues");
        this.interleaveValues = interleaveValues;
        this.validateValues();
    }

    @NotNull
    public final Number[] getPixel(int x, int y) {
        Number[] numberArray;
        this.validateCoordinates(x, y);
        if (this.sampleValues != null) {
            int sampleIndex = this.getSampleIndex(x, y);
            int n = 0;
            int n2 = this.getSamplesPerPixel();
            Number[] numberArray2 = new Number[n2];
            while (n < n2) {
                int n3 = n++;
                int bufferIndex = sampleIndex * this.fieldTypes[n3].getBytes();
                Intrinsics.checkNotNull((Object)this.sampleValues);
                numberArray2[n3] = this.getSampleFromByteBuffer(this.sampleValues[n3], bufferIndex, n3);
            }
            numberArray = numberArray2;
        } else {
            int interleaveIndex = this.getInterleaveIndex(x, y);
            int n = 0;
            int n4 = this.getSamplesPerPixel();
            Number[] numberArray3 = new Number[n4];
            while (n < n4) {
                int n5 = n++;
                Number s = this.getSampleFromByteBuffer(this.interleaveValues, interleaveIndex, n5);
                interleaveIndex += this.fieldTypes[n5].getBytes();
                numberArray3[n5] = s;
            }
            numberArray = numberArray3;
        }
        return numberArray;
    }

    public final void setPixel(int x, int y, @NotNull Number[] values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.validateCoordinates(x, y);
        this.validateSample(values.length + 1);
        if (this.sampleValues != null) {
            int n = this.getSamplesPerPixel();
            for (int i = 0; i < n; ++i) {
                int bufferIndex = this.getSampleIndex(x, y) * this.fieldTypes[i].getBytes();
                Intrinsics.checkNotNull((Object)this.sampleValues);
                this.updateSampleInByteBuffer(this.sampleValues[i], bufferIndex, i, values[i]);
            }
        } else {
            int interleaveIndex = this.getSampleIndex(x, y) * this.sizePixel();
            int n = this.getSamplesPerPixel();
            for (int i = 0; i < n; ++i) {
                this.updateSampleInByteBuffer(this.interleaveValues, interleaveIndex, i, values[i]);
                interleaveIndex += this.fieldTypes[i].getBytes();
            }
        }
    }

    @NotNull
    public final byte[] getPixelRow(int y, @NotNull ByteOrder newOrder) {
        Intrinsics.checkNotNullParameter((Object)((Object)newOrder), (String)"newOrder");
        ByteBuffer outBuffer = ByteBuffer.Companion.allocate(this.width * this.sizePixel());
        outBuffer.order(newOrder);
        if (this.sampleValues != null) {
            int i;
            int n = this.getSamplesPerPixel();
            for (i = 0; i < n; ++i) {
                Intrinsics.checkNotNull((Object)this.sampleValues);
                this.sampleValues[i].position(y * this.width * this.fieldTypes[i].getBytes());
            }
            n = this.width;
            for (i = 0; i < n; ++i) {
                int n2 = this.getSamplesPerPixel();
                for (int j = 0; j < n2; ++j) {
                    Intrinsics.checkNotNull((Object)this.sampleValues);
                    this.writeSample(outBuffer, this.sampleValues[j], this.fieldTypes[j]);
                }
            }
        } else {
            ByteBuffer byteBuffer = this.interleaveValues;
            Intrinsics.checkNotNull((Object)byteBuffer);
            byteBuffer.position(y * this.width * this.sizePixel());
            int n = this.width;
            for (int i = 0; i < n; ++i) {
                int n3 = this.getSamplesPerPixel();
                for (int j = 0; j < n3; ++j) {
                    ByteBuffer byteBuffer2 = this.interleaveValues;
                    Intrinsics.checkNotNull((Object)byteBuffer2);
                    this.writeSample(outBuffer, byteBuffer2, this.fieldTypes[j]);
                }
            }
        }
        return outBuffer.array();
    }

    @NotNull
    public final byte[] getSampleRow(int y, int sample, @NotNull ByteOrder newOrder) {
        Intrinsics.checkNotNullParameter((Object)((Object)newOrder), (String)"newOrder");
        ByteBuffer outBuffer = ByteBuffer.Companion.allocate(this.width * this.fieldTypes[sample].getBytes());
        outBuffer.order(newOrder);
        if (this.sampleValues != null) {
            Intrinsics.checkNotNull((Object)this.sampleValues);
            this.sampleValues[sample].position(y * this.width * this.fieldTypes[sample].getBytes());
            int n = this.width;
            for (int x = 0; x < n; ++x) {
                Intrinsics.checkNotNull((Object)this.sampleValues);
                this.writeSample(outBuffer, this.sampleValues[sample], this.fieldTypes[sample]);
            }
        } else {
            int i;
            int sampleOffset = 0;
            for (i = 0; i < sample; ++i) {
                sampleOffset += this.fieldTypes[sample].getBytes();
            }
            int n = this.width;
            for (i = 0; i < n; ++i) {
                ByteBuffer byteBuffer = this.interleaveValues;
                Intrinsics.checkNotNull((Object)byteBuffer);
                byteBuffer.position((y * this.width + i) * this.sizePixel() + sampleOffset);
                ByteBuffer byteBuffer2 = this.interleaveValues;
                Intrinsics.checkNotNull((Object)byteBuffer2);
                this.writeSample(outBuffer, byteBuffer2, this.fieldTypes[sample]);
            }
        }
        return outBuffer.array();
    }

    @NotNull
    public final Number getPixelSample(int sample, int x, int y) {
        this.validateCoordinates(x, y);
        this.validateSample(sample);
        Number pixelSample = null;
        if (this.sampleValues != null) {
            int bufferPos = this.getSampleIndex(x, y) * this.fieldTypes[sample].getBytes();
            Intrinsics.checkNotNull((Object)this.sampleValues);
            pixelSample = this.getSampleFromByteBuffer(this.sampleValues[sample], bufferPos, sample);
        } else {
            int bufferPos = this.getInterleaveIndex(x, y);
            for (int i = 0; i < sample; ++i) {
                bufferPos += this.fieldTypes[sample].getBytes();
            }
            pixelSample = this.getSampleFromByteBuffer(this.interleaveValues, bufferPos, sample);
        }
        return pixelSample;
    }

    public final void setPixelSample(int sample, int x, int y, @NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.validateCoordinates(x, y);
        this.validateSample(sample);
        if (this.sampleValues != null) {
            int sampleIndex = this.getSampleIndex(x, y) * this.fieldTypes[sample].getBytes();
            Intrinsics.checkNotNull((Object)this.sampleValues);
            this.updateSampleInByteBuffer(this.sampleValues[sample], sampleIndex, sample, value);
        }
        if (this.interleaveValues != null) {
            int interleaveIndex = this.getSampleIndex(x, y) * this.sizePixel();
            for (int i = 0; i < sample; ++i) {
                interleaveIndex += this.fieldTypes[sample].getBytes();
            }
            this.updateSampleInByteBuffer(this.interleaveValues, interleaveIndex, sample, value);
        }
    }

    @Nullable
    public final Number getFirstPixelSample(int x, int y) {
        return this.getPixelSample(0, x, y);
    }

    public final void setFirstPixelSample(int x, int y, @NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setPixelSample(0, x, y, value);
    }

    public final int getSampleIndex(int x, int y) {
        return y * this.width + x;
    }

    public final int getInterleaveIndex(int x, int y) {
        return y * this.width * this.sizePixel() + x * this.sizePixel();
    }

    public final int size() {
        return this.getNumPixels() * this.sizePixel();
    }

    public final int sizePixel() {
        if (this.pixelSize != null) {
            Integer n = this.pixelSize;
            Intrinsics.checkNotNull((Object)n);
            return n;
        }
        int size = 0;
        int n = this.getSamplesPerPixel();
        for (int i = 0; i < n; ++i) {
            size += this.fieldTypes[i].getBytes();
        }
        this.pixelSize = size;
        return size;
    }

    private final void validateCoordinates(int x, int y) {
        if (x < 0 || x >= this.width || y < 0 || y > this.height) {
            throw new TiffException("Pixel oustide of raster range. Width: " + this.width + ", Height: " + this.height + ", x: " + x + ", y: " + y);
        }
    }

    private final void validateSample(int sample) {
        if (sample < 0 || sample >= this.getSamplesPerPixel()) {
            throw new TiffException("Pixel sample out of bounds. sample: " + sample + ", samples per pixel: " + this.getSamplesPerPixel());
        }
    }

    public final int calculateRowsPerStrip(int planarConfiguration, int maxBytesPerStrip) {
        Integer rowsPerStrip = null;
        if (planarConfiguration == 1) {
            rowsPerStrip = this.rowsPerStrip(this.sizePixel(), maxBytesPerStrip);
        } else {
            int n = this.getSamplesPerPixel();
            for (int sample = 0; sample < n; ++sample) {
                int rowsPerStripForSample = this.rowsPerStrip(this.fieldTypes[sample].getBytes(), maxBytesPerStrip);
                if (rowsPerStrip != null && rowsPerStripForSample >= rowsPerStrip) continue;
                rowsPerStrip = rowsPerStripForSample;
            }
        }
        Integer n = rowsPerStrip;
        Intrinsics.checkNotNull((Object)n);
        return n;
    }

    public static /* synthetic */ int calculateRowsPerStrip$default(Rasters rasters, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 8000;
        }
        return rasters.calculateRowsPerStrip(n, n2);
    }

    private final int rowsPerStrip(int bytesPerPixel, int maxBytesPerStrip) {
        int bytesPerRow = bytesPerPixel * this.width;
        return Math.max(1, maxBytesPerStrip / bytesPerRow);
    }

    private final Number readSample(ByteBuffer buffer, FieldType fieldType) {
        Number number;
        switch (WhenMappings.$EnumSwitchMapping$0[fieldType.ordinal()]) {
            case 1: {
                number = (short)(buffer.get() & 0xFF);
                break;
            }
            case 2: {
                number = buffer.getShort() & 0xFFFF;
                break;
            }
            case 3: {
                number = buffer.getInt() & 0xFFFFFFF;
                break;
            }
            case 4: {
                number = buffer.get();
                break;
            }
            case 5: {
                number = buffer.getShort();
                break;
            }
            case 6: {
                number = buffer.getInt();
                break;
            }
            case 7: {
                number = Float.valueOf(buffer.getFloat());
                break;
            }
            case 8: {
                number = buffer.getDouble();
                break;
            }
            default: {
                throw new TiffException("Unsupported raster field type: " + (Object)((Object)fieldType));
            }
        }
        return number;
    }

    private final void writeSample(ByteBuffer buffer, FieldType fieldType, Number value) {
        switch (WhenMappings.$EnumSwitchMapping$0[fieldType.ordinal()]) {
            case 1: 
            case 4: {
                buffer.put(value.byteValue());
                break;
            }
            case 2: 
            case 5: {
                buffer.putShort(value.shortValue());
                break;
            }
            case 3: 
            case 6: {
                buffer.putInt(value.intValue());
                break;
            }
            case 7: {
                buffer.putFloat(value.floatValue());
                break;
            }
            case 8: {
                buffer.putDouble(value.doubleValue());
                break;
            }
            default: {
                throw new TiffException("Unsupported raster field type: " + (Object)((Object)fieldType));
            }
        }
    }

    private final void writeSample(ByteBuffer outBuffer, ByteBuffer inBuffer, FieldType fieldType) {
        switch (WhenMappings.$EnumSwitchMapping$0[fieldType.ordinal()]) {
            case 1: 
            case 4: {
                outBuffer.put(inBuffer.get());
                break;
            }
            case 2: 
            case 5: {
                outBuffer.putShort(inBuffer.getShort());
                break;
            }
            case 3: 
            case 6: {
                outBuffer.putInt(inBuffer.getInt());
                break;
            }
            case 7: {
                outBuffer.putFloat(inBuffer.getFloat());
                break;
            }
            case 8: {
                outBuffer.putDouble(inBuffer.getDouble());
                break;
            }
            default: {
                throw new TiffException("Unsupported raster field type: " + (Object)((Object)fieldType));
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FieldType.values().length];
            nArray[FieldType.BYTE.ordinal()] = 1;
            nArray[FieldType.SHORT.ordinal()] = 2;
            nArray[FieldType.LONG.ordinal()] = 3;
            nArray[FieldType.SBYTE.ordinal()] = 4;
            nArray[FieldType.SSHORT.ordinal()] = 5;
            nArray[FieldType.SLONG.ordinal()] = 6;
            nArray[FieldType.FLOAT.ordinal()] = 7;
            nArray[FieldType.DOUBLE.ordinal()] = 8;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

