/*
 * Decompiled with CFR 0.152.
 */
package ag.granular.tiff;

import ag.granular.io.ByteOrder;
import ag.granular.tiff.FieldTagType;
import ag.granular.tiff.FieldType;
import ag.granular.tiff.FileDirectory;
import ag.granular.tiff.FileDirectoryEntry;
import ag.granular.tiff.TIFFImage;
import ag.granular.tiff.io.ByteReader;
import ag.granular.tiff.util.TiffException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J*\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u0016\u001a\u00020\u0010J*\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0017\u0010\u0018\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u0002H\u00170\u0019\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lag/granular/tiff/TiffReader;", "", "bytes", "", "cache", "", "([BZ)V", "reader", "Lag/granular/tiff/io/ByteReader;", "getValues", "", "fieldType", "Lag/granular/tiff/FieldType;", "typeCount", "", "parseTIFFImage", "Lag/granular/tiff/TIFFImage;", "byteOffset", "", "readFieldValues", "fieldTag", "Lag/granular/tiff/FieldTagType;", "readTiff", "T", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "tiffany"})
public final class TiffReader {
    private final boolean cache;
    @NotNull
    private final ByteReader reader;

    public TiffReader(@NotNull byte[] bytes, boolean cache) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.cache = cache;
        this.reader = new ByteReader(bytes, ByteOrder.LITTLE_ENDIAN);
    }

    public /* synthetic */ TiffReader(byte[] byArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(byArray, bl);
    }

    public final <T> T readTiff(@NotNull Function1<? super TIFFImage, ? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        TIFFImage tiffImage = this.readTiff();
        Object res = block.invoke((Object)tiffImage);
        return (T)res;
    }

    @NotNull
    public final TIFFImage readTiff() {
        ByteOrder byteOrder;
        String byteOrderString;
        String string;
        try {
            String string2 = this.reader.readString(2);
            if (string2 == null) {
                throw new TiffException("Failed to read byte order, byteOrderString is null");
            }
            string = string2;
        }
        catch (Exception e) {
            throw new TiffException("Failed to read byte order", e);
        }
        String e = byteOrderString = string;
        if (Intrinsics.areEqual((Object)e, (Object)"II")) {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else if (Intrinsics.areEqual((Object)e, (Object)"MM")) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        } else {
            throw new TiffException("Invalid byte order: " + byteOrderString);
        }
        ByteOrder byteOrder2 = byteOrder;
        this.reader.setByteReaderOrder(byteOrder2);
        int tiffIdentifier = this.reader.readUnsignedShort();
        if (tiffIdentifier != 42) {
            throw new TiffException("Invalid file identifier, not a TIFF");
        }
        int byteOffset = (int)this.reader.readUnsignedInt();
        return this.parseTIFFImage(this.reader, byteOffset, this.cache);
    }

    private final TIFFImage parseTIFFImage(ByteReader reader, int byteOffset, boolean cache) {
        int byteOffset2 = byteOffset;
        List fileDirectories = new ArrayList();
        while (byteOffset2 != 0) {
            reader.setNextByte(byteOffset2);
            LinkedHashSet<FileDirectoryEntry> entries = new LinkedHashSet<FileDirectoryEntry>();
            int numDirectoryEntries = reader.readUnsignedShort();
            for (int entryCount = 0; entryCount < numDirectoryEntries; ++entryCount) {
                Object values;
                int fieldTagValue = reader.readUnsignedShort();
                FieldTagType fieldTag = FieldTagType.Companion.getById(fieldTagValue);
                int fieldTypeValue = reader.readUnsignedShort();
                FieldType fieldType = FieldType.Companion.getFieldType(fieldTypeValue);
                long typeCount = reader.readUnsignedInt();
                int nextByte = reader.getNextByte();
                Object object = values = this.readFieldValues(reader, fieldTag, fieldType, typeCount);
                Intrinsics.checkNotNull((Object)object);
                FileDirectoryEntry entry = new FileDirectoryEntry(fieldTag, fieldType, typeCount, object);
                entries.add(entry);
                reader.setNextByte(nextByte + 4);
            }
            FileDirectory fileDirectory = new FileDirectory(entries, reader, cache);
            fileDirectories.add(fileDirectory);
            byteOffset2 = (int)reader.readUnsignedInt();
        }
        return new TIFFImage(fileDirectories);
    }

    private final Object readFieldValues(ByteReader reader, FieldTagType fieldTag, FieldType fieldType, long typeCount) {
        if ((long)fieldType.getBytes() * typeCount > 4L) {
            int valueOffset = (int)reader.readUnsignedInt();
            reader.setNextByte(valueOffset);
        }
        List<Object> valuesList = this.getValues(reader, fieldType, typeCount);
        Object values = null;
        values = typeCount == 1L && !fieldTag.isArray() && fieldType != FieldType.RATIONAL && fieldType != FieldType.SRATIONAL ? valuesList.get(0) : valuesList;
        return values;
    }

    private final List<Object> getValues(ByteReader reader, FieldType fieldType, long typeCount) {
        List values = new ArrayList();
        block15: for (long i = 0L; i < typeCount; ++i) {
            switch (WhenMappings.$EnumSwitchMapping$0[fieldType.ordinal()]) {
                case 1: {
                    try {
                        values.add(reader.readString(1));
                        continue block15;
                    }
                    catch (Exception e) {
                        throw new TiffException("Failed to read ASCII character", e);
                    }
                }
                case 2: 
                case 3: {
                    values.add(reader.readUnsignedByte());
                    continue block15;
                }
                case 4: {
                    values.add(reader.readByte());
                    continue block15;
                }
                case 5: {
                    values.add(reader.readUnsignedShort());
                    continue block15;
                }
                case 6: {
                    values.add(reader.readShort());
                    continue block15;
                }
                case 7: {
                    values.add(reader.readUnsignedInt());
                    continue block15;
                }
                case 8: {
                    values.add(reader.readInt());
                    continue block15;
                }
                case 9: {
                    values.add(reader.readUnsignedInt());
                    values.add(reader.readUnsignedInt());
                    continue block15;
                }
                case 10: {
                    values.add(reader.readInt());
                    values.add(reader.readInt());
                    continue block15;
                }
                case 11: {
                    values.add(Float.valueOf(reader.readFloat()));
                    continue block15;
                }
                case 12: {
                    values.add(reader.readDouble());
                    continue block15;
                }
                default: {
                    throw new TiffException("Invalid field type: " + (Object)((Object)fieldType));
                }
            }
        }
        if (fieldType == FieldType.ASCII) {
            List stringValues = new ArrayList();
            StringBuilder builder = new StringBuilder();
            for (Object value : values) {
                if (value == null) {
                    if (!(((CharSequence)builder).length() > 0)) continue;
                    String string = builder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
                    stringValues.add(string);
                    builder = new StringBuilder();
                    continue;
                }
                builder.append(value.toString());
            }
            return stringValues;
        }
        return CollectionsKt.filterNotNull((Iterable)values);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FieldType.values().length];
            nArray[FieldType.ASCII.ordinal()] = 1;
            nArray[FieldType.BYTE.ordinal()] = 2;
            nArray[FieldType.UNDEFINED.ordinal()] = 3;
            nArray[FieldType.SBYTE.ordinal()] = 4;
            nArray[FieldType.SHORT.ordinal()] = 5;
            nArray[FieldType.SSHORT.ordinal()] = 6;
            nArray[FieldType.LONG.ordinal()] = 7;
            nArray[FieldType.SLONG.ordinal()] = 8;
            nArray[FieldType.RATIONAL.ordinal()] = 9;
            nArray[FieldType.SRATIONAL.ordinal()] = 10;
            nArray[FieldType.FLOAT.ordinal()] = 11;
            nArray[FieldType.DOUBLE.ordinal()] = 12;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

