/*
 * Decompiled with CFR 0.152.
 */
package ag.granular.tiff;

import ag.granular.io.ByteOrder;
import ag.granular.tiff.FieldType;
import ag.granular.tiff.FileDirectory;
import ag.granular.tiff.FileDirectoryEntry;
import ag.granular.tiff.Rasters;
import ag.granular.tiff.TIFFImage;
import ag.granular.tiff.compression.CompressionEncoder;
import ag.granular.tiff.compression.DeflateCompression;
import ag.granular.tiff.compression.LZWCompression;
import ag.granular.tiff.compression.PackbitsCompression;
import ag.granular.tiff.compression.RawCompression;
import ag.granular.tiff.io.ByteWriter;
import ag.granular.tiff.util.TiffException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J(\u0010\u0017\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0016\u0010\u0019\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a8\u0006\u001f"}, d2={"Lag/granular/tiff/TiffWriter;", "", "()V", "getEncoder", "Lag/granular/tiff/compression/CompressionEncoder;", "fileDirectory", "Lag/granular/tiff/FileDirectory;", "populateRasterEntries", "", "populateStripEntries", "writeFillerBytes", "writer", "Lag/granular/tiff/io/ByteWriter;", "count", "", "writeImageFileDirectories", "tiffImage", "Lag/granular/tiff/TIFFImage;", "writeRasters", "", "byteOrder", "Lag/granular/io/ByteOrder;", "offset", "writeStripRasters", "encoder", "writeTiff", "writeTiffToBytes", "writeValues", "", "entry", "Lag/granular/tiff/FileDirectoryEntry;", "tiffany"})
public final class TiffWriter {
    @NotNull
    public final byte[] writeTiffToBytes(@NotNull TIFFImage tiffImage) {
        Intrinsics.checkNotNullParameter((Object)tiffImage, (String)"tiffImage");
        ByteWriter writer = new ByteWriter(null, 1, null);
        byte[] bytes = this.writeTiffToBytes(writer, tiffImage);
        writer.close();
        return bytes;
    }

    @NotNull
    public final byte[] writeTiffToBytes(@NotNull ByteWriter writer, @NotNull TIFFImage tiffImage) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)tiffImage, (String)"tiffImage");
        this.writeTiff(writer, tiffImage);
        return writer.getBytes();
    }

    public final void writeTiff(@NotNull ByteWriter writer, @NotNull TIFFImage tiffImage) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)tiffImage, (String)"tiffImage");
        String byteOrder = writer.getByteOrder() == ByteOrder.BIG_ENDIAN ? "MM" : "II";
        writer.writeString(byteOrder);
        writer.writeUnsignedShort(42);
        writer.writeUnsignedInt(8L);
        this.writeImageFileDirectories(writer, tiffImage);
    }

    private final void writeImageFileDirectories(ByteWriter writer, TIFFImage tiffImage) {
        int n = tiffImage.getFileDirectories().size();
        for (int i = 0; i < n; ++i) {
            FileDirectory fileDirectory = tiffImage.getFileDirectories().get(i);
            this.populateRasterEntries(fileDirectory);
            int startOfDirectory = writer.size();
            long afterDirectory = (long)startOfDirectory + fileDirectory.size();
            long afterValues = (long)startOfDirectory + fileDirectory.sizeWithValues();
            writer.writeUnsignedShort(fileDirectory.numEntries());
            ArrayList<FileDirectoryEntry> entryValues = new ArrayList<FileDirectoryEntry>();
            long nextByte = afterDirectory;
            ArrayList<Long> valueBytesCheck = new ArrayList<Long>();
            if (fileDirectory.isTiled()) {
                throw new TiffException("Tiled images are not supported");
            }
            byte[] rastersBytes = this.writeRasters(writer.getByteOrder(), fileDirectory, afterValues);
            for (FileDirectoryEntry entry : fileDirectory.getEntries()) {
                writer.writeUnsignedShort(entry.getFieldTag().getId());
                writer.writeUnsignedShort(entry.getFieldType().getValue());
                writer.writeUnsignedInt(entry.getTypeCount());
                long valueBytes = (long)entry.getFieldType().getBytes() * entry.getTypeCount();
                if (valueBytes > 4L) {
                    entryValues.add(entry);
                    writer.writeUnsignedInt(nextByte);
                    valueBytesCheck.add(nextByte);
                    nextByte += entry.sizeOfValues();
                    continue;
                }
                int bytesWritten = this.writeValues(writer, entry);
                if ((long)bytesWritten != valueBytes) {
                    throw new TiffException("Unexpected bytes written. Expected: " + valueBytes + ", Actual: " + bytesWritten);
                }
                this.writeFillerBytes(writer, (long)4 - valueBytes);
            }
            if (i + 1 == tiffImage.getFileDirectories().size()) {
                this.writeFillerBytes(writer, 4L);
            } else {
                long nextFileDirectory = afterValues + (long)rastersBytes.length;
                writer.writeUnsignedInt(nextFileDirectory);
            }
            int n2 = entryValues.size();
            for (int entryIndex = 0; entryIndex < n2; ++entryIndex) {
                long valueBytes;
                Object e = entryValues.get(entryIndex);
                Intrinsics.checkNotNullExpressionValue(e, (String)"entryValues[entryIndex]");
                FileDirectoryEntry entry = (FileDirectoryEntry)e;
                Object e2 = valueBytesCheck.get(entryIndex);
                Intrinsics.checkNotNullExpressionValue(e2, (String)"valueBytesCheck[entryIndex]");
                long entryValuesByte = ((Number)e2).longValue();
                if (entryValuesByte != (long)writer.size()) {
                    throw new TiffException("Entry values byte does not match the write location. Entry Values Byte: " + entryValuesByte + ", Current Byte: " + writer.size());
                }
                int bytesWritten = this.writeValues(writer, entry);
                if ((long)bytesWritten == (valueBytes = (long)entry.getFieldType().getBytes() * entry.getTypeCount())) continue;
                throw new TiffException("Unexpected bytes written. Expected: " + valueBytes + ", Actual: " + bytesWritten);
            }
            writer.writeBytes(rastersBytes);
        }
    }

    private final void populateRasterEntries(FileDirectory fileDirectory) {
        Rasters rasters = fileDirectory.getWriteRasters();
        if (rasters == null) {
            throw new TiffException("File Directory Writer Rasters is required to create a TIFF");
        }
        Rasters rasters2 = rasters;
        if (fileDirectory.isTiled()) {
            throw new TiffException("Tiled images are not supported");
        }
        this.populateStripEntries(fileDirectory);
    }

    private final void populateStripEntries(FileDirectory fileDirectory) {
        ArrayList<Number> arrayList;
        int n;
        int stripsPerSample;
        Number number = fileDirectory.getRowsPerStrip();
        int rowsPerStrip = number != null ? number.intValue() : 0;
        int imageHeight = fileDirectory.getImageHeight().intValue();
        int strips = stripsPerSample = (imageHeight + rowsPerStrip - 1) / rowsPerStrip;
        Integer n2 = fileDirectory.getPlanarConfiguration();
        int n3 = 2;
        if (n2 != null && n2 == n3) {
            strips *= fileDirectory.getSamplesPerPixel();
        }
        FileDirectory fileDirectory2 = fileDirectory;
        ArrayList<Number> arrayList2 = new ArrayList<Number>(strips);
        int n4 = 0;
        while (n4 < strips) {
            int n5 = n = n4++;
            arrayList = arrayList2;
            boolean bl = false;
            arrayList.add(0L);
        }
        fileDirectory2.setStripOffsetsAsLongs((List<Long>)arrayList2);
        fileDirectory2 = fileDirectory;
        arrayList2 = new ArrayList(strips);
        n4 = 0;
        while (n4 < strips) {
            int it = n = n4++;
            arrayList = arrayList2;
            boolean bl = false;
            arrayList.add(0);
        }
        fileDirectory2.setStripByteCounts((List<Integer>)arrayList2);
    }

    private final byte[] writeRasters(ByteOrder byteOrder, FileDirectory fileDirectory, long offset) {
        Rasters rasters = fileDirectory.getWriteRasters();
        if (rasters == null) {
            throw new TiffException("File Directory Writer Rasters is required to create a TIFF");
        }
        Rasters rasters2 = rasters;
        CompressionEncoder encoder = this.getEncoder(fileDirectory);
        ByteWriter writer = new ByteWriter(byteOrder);
        if (fileDirectory.isTiled()) {
            throw new TiffException("Tiled images are not supported");
        }
        this.writeStripRasters(writer, fileDirectory, offset, encoder);
        byte[] bytes = writer.getBytes();
        writer.close();
        return bytes;
    }

    private final void writeStripRasters(ByteWriter writer, FileDirectory fileDirectory, long offset, CompressionEncoder encoder) {
        int stripsPerSample;
        long offset2 = offset;
        Rasters rasters = fileDirectory.getWriteRasters();
        Intrinsics.checkNotNull((Object)rasters);
        Rasters rasters2 = rasters;
        Number number = fileDirectory.getRowsPerStrip();
        Intrinsics.checkNotNull((Object)number);
        int rowsPerStrip = number.intValue();
        int maxY = fileDirectory.getImageHeight().intValue();
        int strips = stripsPerSample = (maxY + rowsPerStrip - 1) / rowsPerStrip;
        Integer n = fileDirectory.getPlanarConfiguration();
        int n2 = 2;
        if (n != null && n == n2) {
            strips *= fileDirectory.getSamplesPerPixel();
        }
        ArrayList<Long> stripOffsets = new ArrayList<Long>();
        ArrayList<Integer> stripByteCounts = new ArrayList<Integer>();
        int n3 = strips;
        for (int strip = 0; strip < n3; ++strip) {
            int startingY = 0;
            Integer sample = null;
            Integer n4 = fileDirectory.getPlanarConfiguration();
            int n5 = 2;
            if (n4 != null && n4 == n5) {
                sample = strip / stripsPerSample;
                startingY = strip % stripsPerSample * rowsPerStrip;
            } else {
                startingY = strip * rowsPerStrip;
            }
            ByteWriter stripWriter = new ByteWriter(writer.getByteOrder());
            int endingY = Math.min(startingY + rowsPerStrip, maxY);
            for (int y = startingY; y < endingY; ++y) {
                byte[] rowBytes = null;
                rowBytes = sample != null ? rasters2.getSampleRow(y, sample, writer.getByteOrder()) : rasters2.getPixelRow(y, writer.getByteOrder());
                if (encoder.rowEncoding()) {
                    Intrinsics.checkNotNull((Object)rowBytes);
                    rowBytes = encoder.encode(rowBytes, writer.getByteOrder());
                }
                Intrinsics.checkNotNull((Object)rowBytes);
                stripWriter.writeBytes(rowBytes);
            }
            byte[] stripBytes = stripWriter.getBytes();
            stripWriter.close();
            if (!encoder.rowEncoding()) {
                stripBytes = encoder.encode(stripBytes, writer.getByteOrder());
            }
            writer.writeBytes(stripBytes);
            int bytesWritten = stripBytes.length;
            stripByteCounts.add(bytesWritten);
            stripOffsets.add(offset2);
            offset2 += (long)bytesWritten;
        }
        fileDirectory.setStripOffsetsAsLongs((List<Long>)stripOffsets);
        fileDirectory.setStripByteCounts((List<Integer>)stripByteCounts);
    }

    private final CompressionEncoder getEncoder(FileDirectory fileDirectory) {
        CompressionEncoder encoder = null;
        Integer compression = fileDirectory.getCompression();
        if (compression == null) {
            compression = 1;
        }
        switch (compression) {
            case 1: {
                encoder = new RawCompression();
                break;
            }
            case 2: {
                throw new TiffException("CCITT Huffman compression not supported: " + compression);
            }
            case 3: {
                throw new TiffException("T4-encoding compression not supported: " + compression);
            }
            case 4: {
                throw new TiffException("T6-encoding compression not supported: " + compression);
            }
            case 5: {
                encoder = new LZWCompression();
                break;
            }
            case 6: 
            case 7: {
                throw new TiffException("JPEG compression not supported: " + compression);
            }
            case 8: 
            case 32946: {
                encoder = new DeflateCompression();
                break;
            }
            case 32773: {
                encoder = new PackbitsCompression();
                break;
            }
            default: {
                throw new TiffException("Unknown compression method identifier: " + compression);
            }
        }
        return encoder;
    }

    private final void writeFillerBytes(ByteWriter writer, long count) {
        for (long i = 0L; i < count; ++i) {
            writer.writeUnsignedByte((short)0);
        }
    }

    private final int writeValues(ByteWriter writer, FileDirectoryEntry entry) {
        List list;
        if (entry.getTypeCount() == 1L && !entry.getFieldTag().isArray() && entry.getFieldType() != FieldType.RATIONAL && entry.getFieldType() != FieldType.SRATIONAL) {
            ArrayList<Object> arrayList;
            ArrayList<Object> $this$writeValues_u24lambda_u2d2 = arrayList = new ArrayList<Object>();
            boolean bl = false;
            $this$writeValues_u24lambda_u2d2.add(entry.getValues());
            list = arrayList;
        } else {
            list = (List)entry.getValues();
        }
        List valuesList = list;
        int bytesWritten = 0;
        block13: for (Object value : valuesList) {
            switch (WhenMappings.$EnumSwitchMapping$0[entry.getFieldType().ordinal()]) {
                case 1: {
                    if ((long)(bytesWritten += writer.writeString((String)value)) >= entry.getTypeCount()) continue block13;
                    long fillerBytes = entry.getTypeCount() - (long)bytesWritten;
                    this.writeFillerBytes(writer, fillerBytes);
                    bytesWritten += (int)fillerBytes;
                    continue block13;
                }
                case 2: 
                case 3: {
                    writer.writeUnsignedByte((Short)value);
                    ++bytesWritten;
                    continue block13;
                }
                case 4: {
                    writer.writeByte((Byte)value);
                    ++bytesWritten;
                    continue block13;
                }
                case 5: {
                    writer.writeUnsignedShort((Integer)value);
                    bytesWritten += 2;
                    continue block13;
                }
                case 6: {
                    writer.writeShort((Short)value);
                    bytesWritten += 2;
                    continue block13;
                }
                case 7: {
                    writer.writeUnsignedInt((Long)value);
                    bytesWritten += 4;
                    continue block13;
                }
                case 8: {
                    writer.writeInt((Integer)value);
                    bytesWritten += 4;
                    continue block13;
                }
                case 9: {
                    writer.writeUnsignedInt((Long)value);
                    bytesWritten += 4;
                    continue block13;
                }
                case 10: {
                    writer.writeInt((Integer)value);
                    bytesWritten += 4;
                    continue block13;
                }
                case 11: {
                    writer.writeFloat(((Float)value).floatValue());
                    bytesWritten += 4;
                    continue block13;
                }
                case 12: {
                    writer.writeDouble((Double)value);
                    bytesWritten += 8;
                    continue block13;
                }
            }
            throw new TiffException("Invalid field type: " + (Object)((Object)entry.getFieldType()));
        }
        return bytesWritten;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FieldType.values().length];
            nArray[FieldType.ASCII.ordinal()] = 1;
            nArray[FieldType.BYTE.ordinal()] = 2;
            nArray[FieldType.UNDEFINED.ordinal()] = 3;
            nArray[FieldType.SBYTE.ordinal()] = 4;
            nArray[FieldType.SHORT.ordinal()] = 5;
            nArray[FieldType.SSHORT.ordinal()] = 6;
            nArray[FieldType.LONG.ordinal()] = 7;
            nArray[FieldType.SLONG.ordinal()] = 8;
            nArray[FieldType.RATIONAL.ordinal()] = 9;
            nArray[FieldType.SRATIONAL.ordinal()] = 10;
            nArray[FieldType.FLOAT.ordinal()] = 11;
            nArray[FieldType.DOUBLE.ordinal()] = 12;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

