/*
 * Decompiled with CFR 0.152.
 */
package ag.granular.tiff.compression;

import ag.granular.io.ByteOrder;
import ag.granular.tiff.compression.CompressionDecoder;
import ag.granular.tiff.compression.CompressionEncoder;
import ag.granular.tiff.compression.zip.Deflater;
import ag.granular.tiff.compression.zip.Inflater;
import ag.granular.tiff.util.TiffException;
import java.io.ByteArrayOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lag/granular/tiff/compression/DeflateCompression;", "Lag/granular/tiff/compression/CompressionDecoder;", "Lag/granular/tiff/compression/CompressionEncoder;", "()V", "decode", "", "bytes", "byteOrder", "Lag/granular/io/ByteOrder;", "encode", "rowEncoding", "", "tiffany"})
public final class DeflateCompression
implements CompressionDecoder,
CompressionEncoder {
    @Override
    @NotNull
    public byte[] decode(@NotNull byte[] bytes, @NotNull ByteOrder byteOrder) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)((Object)byteOrder), (String)"byteOrder");
        try {
            Inflater inflater = new Inflater();
            inflater.setInput(bytes);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(bytes.length);
            byte[] buffer = new byte[1024];
            while (!inflater.finished()) {
                int count = inflater.inflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            byte[] byArray = outputStream.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"outputStream.toByteArray()");
            return byArray;
        }
        catch (Exception e) {
            throw new TiffException("Failed to inflate", e);
        }
    }

    @Override
    public boolean rowEncoding() {
        return false;
    }

    @Override
    @NotNull
    public byte[] encode(@NotNull byte[] bytes, @NotNull ByteOrder byteOrder) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)((Object)byteOrder), (String)"byteOrder");
        try {
            Deflater deflater = new Deflater();
            deflater.setInput(bytes);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            deflater.finish();
            byte[] buffer = new byte[1024];
            while (!deflater.finished()) {
                int count = deflater.deflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            byte[] byArray = outputStream.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"outputStream.toByteArray()");
            return byArray;
        }
        catch (Exception e) {
            throw new TiffException("Failed close encoded stream", e);
        }
    }
}

