/*
 * Decompiled with CFR 0.152.
 */
package ag.granular.tiff.compression;

import ag.granular.io.ByteOrder;
import ag.granular.tiff.compression.CompressionDecoder;
import ag.granular.tiff.compression.CompressionEncoder;
import ag.granular.tiff.io.ByteReader;
import ag.granular.tiff.util.TiffException;
import java.io.ByteArrayOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lag/granular/tiff/compression/PackbitsCompression;", "Lag/granular/tiff/compression/CompressionDecoder;", "Lag/granular/tiff/compression/CompressionEncoder;", "()V", "decode", "", "bytes", "byteOrder", "Lag/granular/io/ByteOrder;", "encode", "rowEncoding", "", "tiffany"})
public final class PackbitsCompression
implements CompressionDecoder,
CompressionEncoder {
    @Override
    @NotNull
    public byte[] decode(@NotNull byte[] bytes, @NotNull ByteOrder byteOrder) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)((Object)byteOrder), (String)"byteOrder");
        ByteReader reader = new ByteReader(bytes, byteOrder);
        ByteArrayOutputStream decodedStream = new ByteArrayOutputStream();
        block0: while (reader.hasByte()) {
            int header = reader.readByte();
            if (header == -128) continue;
            if (header < 0) {
                short next = reader.readUnsignedByte();
                int i = 0;
                int n = header = -header;
                if (i > n) continue;
                while (true) {
                    decodedStream.write(next);
                    if (i == n) continue block0;
                    ++i;
                }
            }
            int i = 0;
            int n = header;
            if (i > n) continue;
            while (true) {
                decodedStream.write(reader.readUnsignedByte());
                if (i == n) continue block0;
                ++i;
            }
        }
        byte[] byArray = decodedStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decodedStream.toByteArray()");
        return byArray;
    }

    @Override
    public boolean rowEncoding() {
        return true;
    }

    @Override
    @NotNull
    public byte[] encode(@NotNull byte[] bytes, @NotNull ByteOrder byteOrder) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)((Object)byteOrder), (String)"byteOrder");
        throw new TiffException("Packbits encoder is not yet implemented");
    }
}

