/*
 * Decompiled with CFR 0.152.
 */
package ag.granular.tiff.io;

import ag.granular.io.ByteBuffer;
import ag.granular.io.ByteOrder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\bJ\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0011J\u000e\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u001cJ\u000e\u0010 \u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020!J\u000e\u0010\"\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00060\fj\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lag/granular/tiff/io/ByteWriter;", "", "byteOrder", "Lag/granular/io/ByteOrder;", "(Lag/granular/io/ByteOrder;)V", "getByteOrder", "()Lag/granular/io/ByteOrder;", "bytes", "", "getBytes", "()[B", "os", "Ljava/io/ByteArrayOutputStream;", "Lag/granular/io/ByteArrayOutputStream;", "close", "", "size", "", "writeByte", "value", "", "writeBytes", "writeDouble", "", "writeFloat", "", "writeInt", "writeShort", "", "writeString", "", "writeUnsignedByte", "writeUnsignedInt", "", "writeUnsignedShort", "tiffany"})
public final class ByteWriter {
    @NotNull
    private final ByteOrder byteOrder;
    @NotNull
    private final ByteArrayOutputStream os;

    public ByteWriter(@NotNull ByteOrder byteOrder) {
        Intrinsics.checkNotNullParameter((Object)((Object)byteOrder), (String)"byteOrder");
        this.byteOrder = byteOrder;
        this.os = new ByteArrayOutputStream();
    }

    public /* synthetic */ ByteWriter(ByteOrder byteOrder, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        }
        this(byteOrder);
    }

    @NotNull
    public final ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @NotNull
    public final byte[] getBytes() {
        byte[] byArray = this.os.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"os.toByteArray()");
        return byArray;
    }

    public final void close() {
        try {
            this.os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final int size() {
        return this.os.size();
    }

    public final int writeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        byte[] valueBytes = StringsKt.encodeToByteArray((String)value);
        this.os.write(valueBytes);
        return valueBytes.length;
    }

    public final void writeByte(byte value) {
        this.os.write(value);
    }

    public final void writeUnsignedByte(short value) {
        this.os.write(UByte.constructor-impl((byte)((byte)value)) & 0xFF);
    }

    public final void writeBytes(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.os.write(value);
    }

    public final void writeShort(short value) {
        ByteBuffer byteBuffer = ByteBuffer.Companion.allocate(2).order(this.byteOrder).putShort(value);
        byteBuffer.flip();
        this.os.write(byteBuffer.array());
    }

    public final void writeUnsignedShort(int value) {
        ByteBuffer byteBuffer = ByteBuffer.Companion.allocate(2).order(this.byteOrder).putShort((short)(value & 0xFFFF));
        byteBuffer.flip();
        this.os.write(byteBuffer.array());
    }

    public final void writeInt(int value) {
        ByteBuffer byteBuffer = ByteBuffer.Companion.allocate(4).order(this.byteOrder).putInt(value);
        byteBuffer.flip();
        this.os.write(byteBuffer.array());
    }

    public final void writeUnsignedInt(long value) {
        ByteBuffer byteBuffer = ByteBuffer.Companion.allocate(4).order(this.byteOrder).putInt((int)(value & 0xFFFFFFFFL));
        byteBuffer.flip();
        this.os.write(byteBuffer.array());
    }

    public final void writeFloat(float value) {
        ByteBuffer byteBuffer = ByteBuffer.Companion.allocate(4).order(this.byteOrder).putFloat(value);
        byteBuffer.flip();
        this.os.write(byteBuffer.array());
    }

    public final void writeDouble(double value) {
        ByteBuffer byteBuffer = ByteBuffer.Companion.allocate(8).order(this.byteOrder).putDouble(value);
        byteBuffer.flip();
        this.os.write(byteBuffer.array());
    }

    public ByteWriter() {
        this(null, 1, null);
    }
}

