package ai.cheq.sst.android.models.advertising

import ai.cheq.sst.android.core.ContextProvider
import com.google.android.gms.ads.identifier.AdvertisingIdClient
import com.google.android.gms.common.GooglePlayServicesNotAvailableException
import com.google.android.gms.common.GooglePlayServicesRepairableException
import kotlinx.io.IOException

internal sealed class AdvertisingIdLoader(protected val contextProvider: ContextProvider) {
    @Throws(
        IOException::class,
        IllegalStateException::class,
        GooglePlayServicesNotAvailableException::class,
        GooglePlayServicesRepairableException::class
    )
    abstract fun getAdvertisingIdInfo(): AdvertisingIdClient.Info
}