package ai.cheq.sst.android.models.advertising

import ai.cheq.sst.android.core.ContextProvider
import ai.cheq.sst.android.protobuf.advertising.Advertising
import kotlinx.coroutines.CancellationException
import kotlinx.coroutines.flow.firstOrNull
import kotlinx.coroutines.flow.map

internal object AdvertisingRepository {
    suspend fun readAdvertisingId(contextProvider: ContextProvider): String? {
        return read(contextProvider) { advertising ->
            advertising.advertisingId ?: null
        }
    }

    suspend fun storeAdvertisingId(contextProvider: ContextProvider, id: String?) {
        if (id != null) {
            store(
                contextProvider, id
            ) { l: Advertising.Builder, r: String -> l.setAdvertisingId(r) }
        }
    }

    suspend fun clearAdvertisingId(contextProvider: ContextProvider) {
        try {
            contextProvider.context().advertisingDataStore.updateData {
                it.toBuilder().clearAdvertisingId().build()
            }
        } catch (e: CancellationException) {
            throw e
        } catch (_: Exception) {
        }
    }

    private suspend fun <R> read(
        contextProvider: ContextProvider, accessor: suspend (value: Advertising) -> R
    ): R? {
        return try {
            contextProvider.context().advertisingDataStore.data.map(accessor).firstOrNull()
        } catch (e: CancellationException) {
            throw e
        } catch (_: Exception) {
            null
        }
    }

    private suspend fun <R> store(
        contextProvider: ContextProvider,
        value: R,
        setter: suspend (advertising: Advertising.Builder, value: R) -> Advertising.Builder
    ) {
        try {
            contextProvider.context().advertisingDataStore.updateData {
                setter(it.toBuilder(), value).build()
            }
        } catch (e: CancellationException) {
            throw e
        } catch (_: Exception) {
        }
    }
}