package ai.cheq.sst.android.models.advertising

import ai.cheq.sst.android.protobuf.advertising.Advertising
import android.content.Context
import androidx.datastore.core.CorruptionException
import androidx.datastore.core.DataStore
import androidx.datastore.core.Serializer
import androidx.datastore.dataStore
import com.google.protobuf.InvalidProtocolBufferException
import java.io.InputStream
import java.io.OutputStream

internal val Context.advertisingDataStore: DataStore<Advertising> by dataStore(
    fileName = "advertising.pb", serializer = AdvertisingSerializer
)

internal object AdvertisingSerializer : Serializer<Advertising> {
    override val defaultValue: Advertising = Advertising.getDefaultInstance()

    override suspend fun readFrom(input: InputStream): Advertising {
        try {
            return Advertising.parseFrom(input)
        } catch (exception: InvalidProtocolBufferException) {
            throw CorruptionException("Cannot read proto.", exception)
        }
    }

    override suspend fun writeTo(
        t: Advertising, output: OutputStream
    ) = t.writeTo(output)
}
