package ai.cheq.sst.android.core.domain

import ai.cheq.sst.android.core.models.Models.Data
import com.fasterxml.jackson.annotation.JsonAutoDetect
import com.fasterxml.jackson.core.JsonGenerator
import com.fasterxml.jackson.core.JsonParser
import com.fasterxml.jackson.core.JsonToken
import com.fasterxml.jackson.databind.DeserializationContext
import com.fasterxml.jackson.databind.JsonNode
import com.fasterxml.jackson.databind.SerializerProvider
import com.fasterxml.jackson.databind.annotation.JsonDeserialize
import com.fasterxml.jackson.databind.annotation.JsonSerialize
import com.fasterxml.jackson.databind.deser.std.StdDeserializer
import com.fasterxml.jackson.databind.ser.std.StdSerializer

@JsonAutoDetect(
    fieldVisibility = JsonAutoDetect.Visibility.NONE,
    setterVisibility = JsonAutoDetect.Visibility.NONE,
    getterVisibility = JsonAutoDetect.Visibility.NONE,
    isGetterVisibility = JsonAutoDetect.Visibility.NONE,
    creatorVisibility = JsonAutoDetect.Visibility.NONE
)
@JsonSerialize(using = DataLayer.Serializer::class)
@JsonDeserialize(using = DataLayer.Deserializer::class)
internal class DataLayer private constructor() {
    private var dataLayerName: String? = null

    var mobileData: Data? = null
        private set

    var dataLayer: Map<String, String?>? = null
        private set

    constructor(
        models: Data?, dataLayerName: String, dataLayer: Map<String, String?>
    ) : this() {
        this.mobileData = models
        this.dataLayerName = dataLayerName
        this.dataLayer = dataLayer
    }

    internal class Serializer : StdSerializer<DataLayer>(DataLayer::class.java, false) {
        override fun serialize(
            value: DataLayer?, gen: JsonGenerator?, provider: SerializerProvider?
        ) {
            gen!!.writeStartObject()
            if (value != null) {
                if (value.mobileData != null) {
                    gen.writeFieldName("__mobileData")
                    gen.writeObject(value.mobileData)
                }
                val dataLayer = value.dataLayer
                if (dataLayer?.isNotEmpty() == true) {
                    gen.writeFieldName(value.dataLayerName)
                    gen.writeStartObject()
                    dataLayer.forEach {
                        gen.writeFieldName(it.key)
                        gen.writeRawValue(it.value)
                    }
                    gen.writeEndObject()
                }
            }
            gen.writeEndObject()
        }
    }

    class Deserializer : StdDeserializer<DataLayer>(DataLayer::class.java) {
        override fun deserialize(
            p: JsonParser?, ctxt: DeserializationContext?
        ): DataLayer {
            val dataLayer = DataLayer()
            if (p != null && p.codec != null && ctxt != null) {
                if (p.currentToken == JsonToken.FIELD_NAME) {
                    p.nextToken()
                }
                val node: JsonNode? = p.codec.readTree(p)
                node?.fields()?.forEach {
                    if (it.key == "__mobileData") {
                        dataLayer.mobileData = ctxt.readValue(
                            node.get(it.key).traverse(p.codec), Data::class.java
                        )
                    } else {
                        dataLayer.dataLayerName = it.key
                        val customDataLayerNode = node.get(it.key)
                        val customDataLayer = mutableMapOf<String, String?>()
                        customDataLayerNode.fields().forEach { f ->
                            customDataLayer[f.key] = customDataLayerNode.get(f.key).toString()
                        }
                        dataLayer.dataLayer = customDataLayer
                    }
                }
            }
            return dataLayer
        }
    }
}