package ai.cheq.sst.android.core.domain

import ai.cheq.sst.android.core.Config
import ai.cheq.sst.android.core.Event
import com.fasterxml.jackson.annotation.JsonAutoDetect
import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonProperty
import java.time.ZoneOffset

@JsonAutoDetect(
    fieldVisibility = JsonAutoDetect.Visibility.NONE,
    setterVisibility = JsonAutoDetect.Visibility.NONE,
    getterVisibility = JsonAutoDetect.Visibility.NONE,
    isGetterVisibility = JsonAutoDetect.Visibility.NONE,
    creatorVisibility = JsonAutoDetect.Visibility.NONE
)
internal class Event {
    constructor(config: Config, event: Event) {
        this.name = event.name
        this.data = augmentData(config, event.data)
    }

    @JsonCreator
    constructor(name: String, data: Map<String, Any>) {
        this.name = name
        this.data = data
    }

    @JsonProperty
    val name: String

    @JsonProperty
    val data: Map<String, Any>

    private fun augmentData(config: Config, data: Map<String, Any>): Map<String, Any> {
        return addDataIfNotExists(
            data, "__timestamp", config.clock().withZone(ZoneOffset.UTC).millis()
        )
    }

    private fun addDataIfNotExists(
        data: Map<String, Any>, key: String, value: Any
    ): Map<String, Any> {
        var augmentedData = data
        if (!data.containsKey(key)) {
            when (augmentedData) {
                is HashMap<String, Any> -> augmentedData[key] = value
                else -> {
                    augmentedData = data.toMutableMap()
                    augmentedData[key] = value
                }
            }
        }
        return augmentedData
    }
}