package ai.cheq.sst.android.core.domain

import ai.cheq.sst.android.core.models.DeviceModel
import ai.cheq.sst.android.core.models.Models
import com.fasterxml.jackson.annotation.JsonAutoDetect
import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.annotation.JsonProperty

@JsonAutoDetect(
    fieldVisibility = JsonAutoDetect.Visibility.NONE,
    setterVisibility = JsonAutoDetect.Visibility.NONE,
    getterVisibility = JsonAutoDetect.Visibility.NONE,
    isGetterVisibility = JsonAutoDetect.Visibility.NONE,
    creatorVisibility = JsonAutoDetect.Visibility.NONE
)
internal class VirtualBrowser {
    constructor(models: Models.Data?) {
        val device = models?.get<DeviceModel.Data>()
        this.height = device?.screen?.height
        this.width = device?.screen?.width
        this.screenDepth = device?.screen?.depth
        this.language = device?.language
        this.timezone = device?.timezone
    }

    @JsonCreator
    constructor(
        height: Int? = null,
        width: Int? = null,
        screenDepth: Int? = null,
        language: String? = null,
        timezone: String? = null
    ) {
        this.height = height
        this.width = width
        this.screenDepth = screenDepth
        this.language = language
        this.timezone = timezone
    }

    @JsonProperty
    @JsonInclude(JsonInclude.Include.NON_NULL)
    val height: Int?

    @JsonProperty
    @JsonInclude(JsonInclude.Include.NON_NULL)
    val width: Int?

    @JsonProperty
    @JsonInclude(JsonInclude.Include.NON_NULL)
    val screenDepth: Int?

    @JsonProperty
    @JsonInclude(JsonInclude.Include.NON_NULL)
    val language: String?

    @JsonProperty
    @JsonInclude(JsonInclude.Include.NON_NULL)
    val timezone: String?
}