package ai.cheq.sst.android.core.internal

import io.ktor.client.statement.HttpResponse

internal sealed class HttpResult {
    data class Success(val response: HttpResponse) : HttpResult()
    sealed class Error : HttpResult() {
        data class HttpError(val response: HttpResponse) : Error()
        data class NetworkError(val throwable: Throwable) : Error()
        data class SerializationError(val throwable: Throwable) : Error()
        data class UnknownError(val throwable: Throwable) : Error()
    }
}