package ai.cheq.sst.android.core.models

import ai.cheq.sst.android.core.BuildConfig
import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.annotation.JsonProperty

/**
 * Represents the library model that collects and exposes data about the CHEQ SST SDK library.
 */
class LibraryModel internal constructor() : Model<LibraryModel.Data>(
    Data::class, Constants.MODEL_KEY_LIBRARY, BuildConfig.LIBRARY_VERSION
) {
    private lateinit var data: Data

    /**
     * Retrieves the data for the library model.
     *
     * @param modelContext The context for managing models.
     * @return The data for the library model.
     */
    override suspend fun get(modelContext: ModelContext): Data {
        if (!this::data.isInitialized) {
            data = Data(BuildConfig.LIBRARY_NAME,
                BuildConfig.LIBRARY_VERSION,
                modelContext.models.custom.associate { it.key to it.version })
        }

        return data
    }

    /**
     * Data class representing the library model data.
     *
     * This class holds information about the library, including its name, version, and custom models.
     *
     * @property name The name of the library.
     * @property version The version of the library.
     * @property models A map of custom models associated with the library.
     */
    class Data internal constructor(
        @field:JsonProperty val name: String,
        @field:JsonProperty val version: String,
        @field:JsonProperty @field:JsonInclude(JsonInclude.Include.NON_EMPTY) val models: Map<String, String> = emptyMap()
    ) : Model.Data()
}