package ai.cheq.sst.android.core.models

import android.util.Log
import ai.cheq.sst.android.core.Constants.TAG

/**
 * API for sending log output.
 *
 * The order in terms of verbosity, from least to most is
 * ERROR, WARN, INFO, DEBUG, VERBOSE.
 */
class Log internal constructor() {
    /**
     * Send a debug log message.
     *
     * @param message The message you would like logged.
     */
    fun d(message: String) {
        if (Log.isLoggable(TAG, Log.DEBUG)) {
            Log.d(TAG, message)
        }
    }

    /**
     * Send a information log message.
     *
     * @param message The message you would like logged.
     */
    fun i(message: String) {
        if (Log.isLoggable(TAG, Log.INFO)) {
            Log.i(TAG, message)
        }
    }

    /**
     * Send a warning log message.
     *
     * @param message The message you would like logged.
     */
    fun w(message: String) {
        if (Log.isLoggable(TAG, Log.WARN)) {
            Log.w(TAG, message)
        }
    }

    /**
     * Send an error log message.
     *
     * @param message The message you would like logged.
     */
    fun e(message: String) {
        if (Log.isLoggable(TAG, Log.ERROR)) {
            Log.e(TAG, message)
        }
    }

    /**
     * Send an error log message and log the exception.

     * @param message The message you would like logged.
     * @param throwable An exception to log.
     */
    fun e(message: String, throwable: Throwable) {
        if (Log.isLoggable(TAG, Log.ERROR)) {
            Log.e(TAG, message, throwable)
        }
    }
}