package ai.cheq.sst.android.core.monitoring

import io.ktor.http.HttpMethod

/**
 * Represents an http request event that can be tracked by the monitoring system.
 *
 * @property url The URL associated with the request.
 * @property method The HTTP method associated with the request.
 * @property headers The headers associated with the request.
 * @property body The body associated with the request.
 */
class HttpRequest internal constructor(
    val url: String,
    val method: HttpMethod,
    val headers: Map<String, List<String>>,
    val body: Map<String, Any>?
) : Event()
