package ai.cheq.sst.android.core.monitoring

import io.ktor.http.HttpStatusCode

/**
 * Represents a http response event that can be tracked by the monitoring system.
 *
 * @property url The URL associated with the response.
 * @property headers The headers associated with the response.
 * @property status The status code associated with the response.
 * @property body The body associated with the response.
 */
class HttpResponse internal constructor(
    val url: String,
    val headers: Map<String, List<String>>,
    val status: HttpStatusCode,
    val body: String
) : Event()
