package ai.cheq.sst.android.core


/**
 * Represents an event that can be sent to CHEQ SST.  The event must have a name, and can optionally include data and parameters.
 *
 *  __Links__
 *
 * More information about parameters that can be passed to the CHEQ SST service, see [Getting Started with Data Collection Pixels](https://help.ensighten.com/hc/en-us/articles/22962356688273-Getting-Started-with-Data-Collection-Pixels)
 *
 * @constructor Creates an instance of an SstEvent.
 * @property name The name of the event. This should be a descriptive name that identifies the event being tracked.
 * @property data A map of data associated with the event. This can be used to store any additional data that needs to be tracked with the event.
 * @property parameters A map of parameters associated with the event, which are included as query string parameters on the SST service call.
 *
 * @sample samples.core.Event.Usage.createEvent
 * @sample samples.core.Event.Usage.createEventWithData
 * @sample samples.core.Event.Usage.createEventWithDataAndParameters
 */
data class Event @JvmOverloads constructor(
    val name: String,
    val data: Map<String, Any> = emptyMap(),
    val parameters: Map<String, String> = emptyMap()
)