package ai.cheq.sst.android.core.domain

import ai.cheq.sst.android.core.Config
import com.fasterxml.jackson.annotation.JsonAutoDetect
import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonProperty

@JsonAutoDetect(
    fieldVisibility = JsonAutoDetect.Visibility.NONE,
    setterVisibility = JsonAutoDetect.Visibility.NONE,
    getterVisibility = JsonAutoDetect.Visibility.NONE,
    isGetterVisibility = JsonAutoDetect.Visibility.NONE,
    creatorVisibility = JsonAutoDetect.Visibility.NONE
)
internal class Settings {
    constructor(config: Config) : this(config.publishPath, config.nexusHost)

    @JsonCreator
    constructor(publishPath: String? = null, nexusHost: String? = null) {
        this.publishPath = publishPath
        this.nexusHost = nexusHost
    }

    @JsonProperty
    val publishPath: String?

    @JsonProperty
    val nexusHost: String?
}