package ai.cheq.sst.android.core.internal

import android.os.Build
import java.util.TimeZone

internal class Clock private constructor(private val epochMillis: Long? = null, timeZone: String? = null) {
    private val timeZone: String

    init {
        if (timeZone != null) {
            this.timeZone = timeZone
        } else {
            this.timeZone = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                java.time.Clock.systemDefaultZone().zone.id
            } else {
                TimeZone.getDefault().id
            }
        }
    }

    fun epochMillis() : Long = when {
        epochMillis != null -> {
            epochMillis
        }

        else -> System.currentTimeMillis()
    }

    fun timeZone() = timeZone

    companion object {
        fun fixed(epochMillis: Long, timeZone: String) : Clock {
            return Clock(epochMillis, timeZone)
        }

        fun system() : Clock {
            return Clock()
        }
    }
}