package ai.cheq.sst.android.core.serializers

import ai.cheq.sst.android.protobuf.storage.Storage
import android.content.Context
import androidx.datastore.core.CorruptionException
import androidx.datastore.core.DataStore
import androidx.datastore.core.Serializer
import androidx.datastore.dataStore
import com.google.protobuf.InvalidProtocolBufferException
import java.io.InputStream
import java.io.OutputStream

internal val Context.storageDataStore: DataStore<Storage> by dataStore(
    fileName = "storage.pb", serializer = StorageSerializer
)

internal object StorageSerializer : Serializer<Storage> {
    override val defaultValue: Storage = Storage.getDefaultInstance()

    override suspend fun readFrom(input: InputStream): Storage {
        try {
            return Storage.parseFrom(input)
        } catch (exception: InvalidProtocolBufferException) {
            throw CorruptionException("Cannot read proto.", exception)
        }
    }

    override suspend fun writeTo(
        t: Storage, output: OutputStream
    ) = t.writeTo(output)
}
