package ai.cheq.sst.android.core

/**
 * API for sending log output.
 *
 * The order in terms of verbosity, from least to most is
 * ERROR, WARN, INFO, DEBUG, VERBOSE.
 */
interface Log {
    /**
     * Check if debug logging is enabled.
     */
    fun isDebugLoggable(): Boolean

    /**
     * Send a debug log message.
     *
     * @param message The message you would like logged.
     */
    fun d(message: String)

    /**
     * Check if info logging is enabled.
     */
    fun isInfoLoggable(): Boolean

    /**
     * Send an information log message.
     *
     * @param message The message you would like logged.
     */
    fun i(message: String)

    /**
     * Check if warn logging is enabled.
     */
    fun isWarnLoggable(): Boolean

    /**
     * Send a warning log message.
     *
     * @param message The message you would like logged.
     */
    fun w(message: String)

    /**
     * Check if error logging is enabled.
     */
    fun isErrorLoggable(): Boolean

    /**
     * Send an error log message.
     *
     * @param message The message you would like logged.
     */
    fun e(message: String)

    /**
     * Send an error log message with a throwable.
     *
     * @param message The message you would like logged.
     * @param throwable The throwable to log.
     */
    fun e(message: String, throwable: Throwable)
}