package ai.cheq.sst.android.core

import com.fasterxml.jackson.core.StreamReadFeature
import com.fasterxml.jackson.databind.ObjectMapper
import com.fasterxml.jackson.databind.SerializationFeature
import com.fasterxml.jackson.databind.json.JsonMapper
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule
import com.fasterxml.jackson.module.kotlin.KotlinFeature
import com.fasterxml.jackson.module.kotlin.KotlinModule

internal class Utils {
    internal companion object {
        val jsonMapper: ObjectMapper = jsonMapper()

        fun jsonMapper(
            initializer: JsonMapper.Builder.() -> Unit = {}
        ): JsonMapper {
            return jsonMapper(initializer = initializer, kotlinModule())
        }

        fun jsonMapper(
            initializer: JsonMapper.Builder.() -> Unit = {},
            kotlinModule: KotlinModule = kotlinModule()
        ): JsonMapper {
            val builder = JsonMapper.builder()
                .addModule(kotlinModule)
                .addModule(JavaTimeModule())
                .enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS)
                .enable(StreamReadFeature.INCLUDE_SOURCE_IN_LOCATION)
                .disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)
            initializer(builder)
            return builder.build()
        }

        fun kotlinModule(initializer: KotlinModule.Builder.() -> Unit = {}): KotlinModule {
            val builder = KotlinModule.Builder()
            builder.enable(KotlinFeature.NullIsSameAsDefault)
            builder.initializer()
            return builder.build()
        }

        internal fun String.truncate(maxLength: Int): String {
            return if (this.length <= maxLength) {
                this
            } else {
                this.substring(0, maxLength - 3) + "..."
            }
        }
    }
}