package ai.cheq.sst.android.core.domain

import ai.cheq.sst.android.core.models.DeviceModel
import ai.cheq.sst.android.core.models.Models
import com.fasterxml.jackson.annotation.JsonAutoDetect
import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.annotation.JsonProperty
import java.util.Locale

@JsonAutoDetect(
    fieldVisibility = JsonAutoDetect.Visibility.NONE,
    setterVisibility = JsonAutoDetect.Visibility.NONE,
    getterVisibility = JsonAutoDetect.Visibility.NONE,
    isGetterVisibility = JsonAutoDetect.Visibility.NONE,
    creatorVisibility = JsonAutoDetect.Visibility.NONE
)
internal class VirtualBrowser {
    constructor(locale: Locale, timezone: String, page: String? = null, models: Models.Data?) {
        val device = models?.get<DeviceModel.Data>()
        this.height = device?.screen?.height
        this.width = device?.screen?.width
        this.screenDepth = device?.screen?.depth
        this.language = locale.toLanguageTag()
        this.timezone = timezone
        this.page = page
    }

    @JsonCreator
    constructor(
        height: Int? = null,
        width: Int? = null,
        screenDepth: Int? = null,
        language: String? = null,
        timezone: String? = null,
        page: String? = null
    ) {
        this.height = height
        this.width = width
        this.screenDepth = screenDepth
        this.language = language
        this.timezone = timezone
        this.page = page
    }

    @JsonProperty
    @JsonInclude(JsonInclude.Include.NON_NULL)
    val height: Int?

    @JsonProperty
    @JsonInclude(JsonInclude.Include.NON_NULL)
    val width: Int?

    @JsonProperty
    @JsonInclude(JsonInclude.Include.NON_NULL)
    val screenDepth: Int?

    @JsonProperty
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    val language: String?

    @JsonProperty
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    val timezone: String?

    @JsonProperty
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    val page: String?
}