package ai.cheq.sst.android.core.storage

import com.fasterxml.jackson.annotation.JsonAutoDetect
import com.fasterxml.jackson.annotation.JsonProperty

/**
 * A cookie object represents information about an HTTP cookie.
 *
 * @property name The name of the cookie
 * @property value The value of the cookie
 */
@JsonAutoDetect(
    fieldVisibility = JsonAutoDetect.Visibility.NONE,
    setterVisibility = JsonAutoDetect.Visibility.NONE,
    getterVisibility = JsonAutoDetect.Visibility.NONE,
    isGetterVisibility = JsonAutoDetect.Visibility.NONE,
    creatorVisibility = JsonAutoDetect.Visibility.NONE
)
data class Cookie(
    @field:JsonProperty("name") val name: String,
    @field:JsonProperty("value") val value: String
): Identifiable {
    override fun id(): String = name
}