package ai.cheq.sst.android.core.domain

import ai.cheq.sst.android.core.Config
import ai.cheq.sst.android.core.storage.Storage
import ai.cheq.sst.android.core.models.Models
import com.fasterxml.jackson.annotation.JsonAutoDetect
import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.annotation.JsonProperty
import java.util.Locale

private typealias SstEvent = ai.cheq.sst.android.core.Event

@JsonAutoDetect(
    fieldVisibility = JsonAutoDetect.Visibility.NONE,
    setterVisibility = JsonAutoDetect.Visibility.NONE,
    getterVisibility = JsonAutoDetect.Visibility.NONE,
    isGetterVisibility = JsonAutoDetect.Visibility.NONE,
    creatorVisibility = JsonAutoDetect.Visibility.NONE
)
internal class Data {
    constructor(
        config: Config, event: SstEvent, models: Models.Data, dataLayer: Map<String, String?>, storage: Storage.Data
    ) : this(
        Settings(config),
        VirtualBrowser(Locale.getDefault(), config.clock().timeZone(), config.virtualBrowser.page,  models),
        DataLayer(models, config.dataLayerName, dataLayer),
        storage,
        listOf(Event(config, event))
    )

    @JsonCreator
    constructor(
        @JsonProperty("settings") settings: Settings = Settings(),
        @JsonProperty("virtualBrowser") virtualBrowser: VirtualBrowser = VirtualBrowser(),
        @JsonProperty("dataLayer") dataLayer: DataLayer,
        @JsonProperty("storage") storage: Storage.Data,
        @JsonProperty("events") events: List<Event> = emptyList()
    ) {
        this.settings = settings
        this.virtualBrowser = virtualBrowser
        this.dataLayer = dataLayer
        this.storage = storage
        this.events = events
    }

    @JsonProperty
    val settings: Settings

    @JsonProperty
    val virtualBrowser: VirtualBrowser

    @JsonProperty
    val dataLayer: DataLayer

    @JsonProperty
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    val storage: Storage.Data

    @JsonProperty
    val events: List<Event>
}
