package ai.cheq.sst.android.core.monitoring

import com.fasterxml.jackson.annotation.JsonAutoDetect
import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonProperty


/**
 * Represents an http request event that can be tracked by the monitoring system.
 *
 * @property url The URL associated with the request.
 * @property method The HTTP method associated with the request.
 * @property headers The headers associated with the request.
 * @property body The body associated with the request.
 */
@JsonAutoDetect(
    fieldVisibility = JsonAutoDetect.Visibility.NONE,
    setterVisibility = JsonAutoDetect.Visibility.NONE,
    getterVisibility = JsonAutoDetect.Visibility.NONE,
    isGetterVisibility = JsonAutoDetect.Visibility.NONE,
    creatorVisibility = JsonAutoDetect.Visibility.NONE
)
class HttpRequest @JsonCreator internal constructor(
    @param:JsonProperty("url") @get:JsonProperty("url") val url: String,
    @param:JsonProperty("method") @get:JsonProperty("method") val method: String,
    @param:JsonProperty("headers") @get:JsonProperty("headers") val headers: Map<String, List<String>>,
    @param:JsonProperty("body") @get:JsonProperty("body") val body: Map<String, Any>?
) : Event()
