package ai.cheq.sst.android.core.monitoring

import com.fasterxml.jackson.annotation.JsonAutoDetect
import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonProperty

/**
 * Represents an http response event that can be tracked by the monitoring system.
 *
 * @property url The URL associated with the response.
 * @property headers The headers associated with the response.
 * @property status The status code associated with the response.
 * @property body The body associated with the response.
 */
@JsonAutoDetect(
    fieldVisibility = JsonAutoDetect.Visibility.NONE,
    setterVisibility = JsonAutoDetect.Visibility.NONE,
    getterVisibility = JsonAutoDetect.Visibility.NONE,
    isGetterVisibility = JsonAutoDetect.Visibility.NONE,
    creatorVisibility = JsonAutoDetect.Visibility.NONE
)
class HttpResponse @JsonCreator internal constructor(
    @param:JsonProperty("url") @get:JsonProperty("url") val url: String,
    @param:JsonProperty("headers") @get:JsonProperty("headers") val headers: Map<String, List<String>>,
    @param:JsonProperty("status") @get:JsonProperty("status") val status: HttpStatusCode,
    @param:JsonProperty("body") @get:JsonProperty("body") val body: String
) : Event()
