package ai.cheq.sst.android.core.monitoring

import com.fasterxml.jackson.annotation.JsonAutoDetect
import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonProperty

/**
 * Represents an http status code.
 *
 * @property value The value of the status code.
 * @property description The description of the status code.
 */
@JsonAutoDetect(
    fieldVisibility = JsonAutoDetect.Visibility.NONE,
    setterVisibility = JsonAutoDetect.Visibility.NONE,
    getterVisibility = JsonAutoDetect.Visibility.NONE,
    isGetterVisibility = JsonAutoDetect.Visibility.NONE,
    creatorVisibility = JsonAutoDetect.Visibility.NONE
)
class HttpStatusCode @JsonCreator internal constructor(
    @param:JsonProperty("value") @get:JsonProperty("value") val value: Int,
    @param:JsonProperty("description") @get:JsonProperty("description") val description: String
)