package ai.cheq.sst.android.core.android

import ai.cheq.sst.android.core.BuildConfig
import ai.cheq.sst.android.core.ContextProvider
import ai.cheq.sst.android.core.Log
import android.webkit.WebSettings
import kotlinx.coroutines.CancellationException

internal class UserAgentProvider {
    private var userAgentLoader: UserAgentLoader = DefaultUserAgentLoader()

    fun initialize(log: Log, contextProvider: ContextProvider) {
        try {
            userAgentLoader = AndroidUserAgentLoader(contextProvider)
        } catch (e: CancellationException) {
            throw e
        } catch (e: Exception) {
            log.e("Failed to initialize UserAgentProvider", e)
        }
    }

    suspend fun userAgent(): String {
        return userAgentLoader.userAgent()
    }

    private interface UserAgentLoader {
        suspend fun userAgent(): String
    }

    private class DefaultUserAgentLoader : UserAgentLoader {
        override suspend fun userAgent(): String {
            return "${BuildConfig.LIBRARY_NAME}/${BuildConfig.LIBRARY_VERSION}"
        }
    }

    private class AndroidUserAgentLoader(contextProvider: ContextProvider) : UserAgentLoader {
        private val userAgent = WebSettings.getDefaultUserAgent(contextProvider.context())

        override suspend fun userAgent(): String {
            return userAgent
        }
    }
}