package ai.cheq.sst.android.core.exceptions

internal class ModelException(message: String, private val model: String, cause: Throwable) :
    SstException(message, cause) {
    override val message: String
        get() = super.getSuppressed().filterIsInstance<ModelException>()
            .joinToString("', '") { it.model }.let {
            if (it.isNotEmpty()) {
                "${super.message} ['$model', '$it']"
            } else {
                "${super.message} ['$model']"
            }
        }
}