package ai.cheq.sst.android.core.internal

import ai.cheq.sst.android.core.ContextProvider
import ai.cheq.sst.android.core.NotConfiguredPolicy
import android.content.Context

internal class ConfigurableContextProvider() {
    private var holder: ContextHolder = NoopContextHolder()

    constructor(context: Context) : this() {
        holder = ConcreteContextHolder { context }
    }

    fun context() = holder.context()
    fun provider() = holder.provider()
    fun requireProvider() = holder.requireProvider()
    fun isConfigured() = holder.isConfigured()

    fun configure(contextProvider: ContextProvider) {
        holder = ConcreteContextHolder(contextProvider)
    }

    fun configure(contextProvider: ConfigurableContextProvider) {
        holder = ConcreteContextHolder(contextProvider.requireProvider())
    }

    fun reset() {
        holder = NoopContextHolder()
    }

    interface ContextHolder {
        fun context(): Context?
        fun provider(): ContextProvider?
        fun requireProvider(): ContextProvider
        fun isConfigured(): Boolean
    }

    class NoopContextHolder : ContextHolder {
        override fun context(): Context? {
            NotConfiguredPolicy.enforce()
            return null
        }

        override fun provider(): ContextProvider? {
            NotConfiguredPolicy.enforce()
            return null
        }

        override fun requireProvider(): Nothing = NotConfiguredPolicy.error()
        override fun isConfigured() = false
    }

    class ConcreteContextHolder(private val contextProvider: ContextProvider) : ContextHolder {
        override fun context() = contextProvider.context()
        override fun provider() = contextProvider
        override fun requireProvider() = contextProvider
        override fun isConfigured() = true
    }
}