package ai.cheq.sst.android.core.internal.store

import java.util.concurrent.CompletableFuture

internal interface DataStoreCollection {
    fun <T : Any> addAsync(key: String, value: T): CompletableFuture<Void?>

    @JvmSynthetic
    suspend fun <T : Any> add(key: String, value: T)

    fun allAsync(): CompletableFuture<Map<String, Any?>>

    @JvmSynthetic
    suspend fun all(): Map<String, Any?>

    fun clearAsync(): CompletableFuture<Void?>

    @JvmSynthetic
    suspend fun clear()

    fun containsAsync(key: String): CompletableFuture<Boolean>

    @JvmSynthetic
    suspend fun contains(key: String): Boolean

    fun <T : Any> getAsync(key: String, valueClass: Class<T>): CompletableFuture<T?>

    fun removeAsync(key: String): CompletableFuture<Boolean>

    @JvmSynthetic
    suspend fun remove(key: String): Boolean

    @JvmSynthetic
    suspend fun <T : Any> get(key: String, valueClass: Class<T>): T?

    @JvmSynthetic
    suspend fun raw(): Map<String, String?>
}