package ai.cheq.sst.android.core.internal.store

import ai.cheq.sst.android.core.NotConfiguredPolicy
import java.util.concurrent.CompletableFuture

internal class NoopDataStoreCollection : DataStoreCollection {
    override suspend fun <T : Any> add(key: String, value: T) {
        NotConfiguredPolicy.enforce()
    }

    override fun <T : Any> addAsync(key: String, value: T): CompletableFuture<Void?> {
        NotConfiguredPolicy.enforce()
        return CompletableFuture.completedFuture(null)
    }

    override fun allAsync(): CompletableFuture<Map<String, Any?>> {
        NotConfiguredPolicy.enforce()
        return CompletableFuture.completedFuture(emptyMap())
    }

    override suspend fun all(): Map<String, Any?> {
        NotConfiguredPolicy.enforce()
        return emptyMap()
    }

    override fun clearAsync(): CompletableFuture<Void?> {
        NotConfiguredPolicy.enforce()
        return CompletableFuture.completedFuture(null)
    }

    override suspend fun clear() {
        NotConfiguredPolicy.enforce()
    }

    override fun containsAsync(key: String): CompletableFuture<Boolean> {
        NotConfiguredPolicy.enforce()
        return CompletableFuture.completedFuture(false)
    }

    override suspend fun contains(key: String): Boolean {
        NotConfiguredPolicy.enforce()
        return false
    }

    override fun <T : Any> getAsync(key: String, valueClass: Class<T>): CompletableFuture<T?> {
        NotConfiguredPolicy.enforce()
        return CompletableFuture.completedFuture(null)
    }

    override fun removeAsync(key: String): CompletableFuture<Boolean> {
        NotConfiguredPolicy.enforce()
        return CompletableFuture.completedFuture(false)
    }

    override suspend fun remove(key: String): Boolean {
        NotConfiguredPolicy.enforce()
        return false
    }

    override suspend fun <T : Any> get(key: String, valueClass: Class<T>): T? {
        NotConfiguredPolicy.enforce()
        return null
    }

    override suspend fun raw(): Map<String, String?> {
        NotConfiguredPolicy.enforce()
        return emptyMap()
    }
}