package ai.cheq.sst.android.core.models

import ai.cheq.sst.android.core.ContextProvider
import ai.cheq.sst.android.core.Log
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.CoroutineScope

/**
 * Provides a context which encapsulates various dependencies and information necessary for model operations.
 *
 * @property contextProvider The context provider for accessing the Android context.
 * @property modelScope The coroutine scope used for model-related tasks.
 * @property modelDispatcher The coroutine dispatcher used for executing model operations.
 * @property log A [Log] instance for logging purposes.
 */
open class ModelContext internal constructor(
    val contextProvider: ContextProvider,
    val modelScope: CoroutineScope,
    val modelDispatcher: CoroutineDispatcher,
    internal val models: ModelIdentifiers,
    val log: Log
)
