package ai.cheq.sst.android.core.models

internal class ModelIdentifier {
    internal val key: String
    internal val version: String

    @Suppress("ConvertSecondaryConstructorToPrimary")
    constructor(key: String, version: String = DEFAULT_VERSION) {
        require(key.isNotBlank()) { "key cannot be empty" }
        require(version.isNotBlank()) { "version cannot be empty" }
        this.key = key
        this.version = version
    }

    override fun toString(): String {
        return "$key:$version"
    }

    internal companion object {
        internal const val DEFAULT_VERSION = "1.0.0"
    }
}