package ai.cheq.sst.android.core.models

internal class ModelsInitializedResult(private val results: MutableList<ModelResult<Unit>> = mutableListOf()) :
    MutableCollection<ModelResult<Unit>> by results {
    val failures get() = results.filter { it.isFailure }

    val isFailure get() = failures.any()

    override fun toString(): String {
        val failingModelIdentifiers =
            failures.map { it.model.toString() }.sorted().joinToString(",")
        if (failingModelIdentifiers.isNotEmpty()) {
            return "Failed to initialize models: $failingModelIdentifiers"
        }
        return "Success"
    }
}