package ai.cheq.sst.android.core.monitoring

import com.fasterxml.jackson.annotation.JsonAutoDetect
import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonProperty

/**
 * Represents an error event that can be tracked by the monitoring system.
 *
 * @property name The name of the error.
 * @property function The function where the error occurred.
 * @property message The error message.
 */
@JsonAutoDetect(
    fieldVisibility = JsonAutoDetect.Visibility.NONE,
    setterVisibility = JsonAutoDetect.Visibility.NONE,
    getterVisibility = JsonAutoDetect.Visibility.NONE,
    isGetterVisibility = JsonAutoDetect.Visibility.NONE,
    creatorVisibility = JsonAutoDetect.Visibility.NONE
)
class Error @JsonCreator internal constructor(
    @param:JsonProperty("name") @get:JsonProperty("name") val name: String,
    @param:JsonProperty("function") @get:JsonProperty("function") val function: String,
    @param:JsonProperty("message") @get:JsonProperty("message") val message: String
) : Event()
