package ai.cheq.sst.android.core.serializers

import ai.cheq.sst.android.protobuf.dataLayer.DataLayer
import android.content.Context
import androidx.datastore.core.CorruptionException
import androidx.datastore.core.DataStore
import androidx.datastore.core.Serializer
import androidx.datastore.dataStore
import com.google.protobuf.InvalidProtocolBufferException
import java.io.InputStream
import java.io.OutputStream

internal val Context.dataLayerDataStore: DataStore<DataLayer> by dataStore(
    fileName = "dataLayer.pb", serializer = DataLayerSerializer
)

internal object DataLayerSerializer : Serializer<DataLayer> {
    override val defaultValue: DataLayer = DataLayer.getDefaultInstance()

    override suspend fun readFrom(input: InputStream): DataLayer {
        try {
            return DataLayer.parseFrom(input)
        } catch (exception: InvalidProtocolBufferException) {
            throw CorruptionException("Cannot read proto.", exception)
        }
    }

    override suspend fun writeTo(
        t: DataLayer, output: OutputStream
    ) = t.writeTo(output)
}
