package ai.cheq.sst.android.core.storage

import ai.cheq.sst.android.core.Log
import ai.cheq.sst.android.core.internal.ConfigurableContextProvider
import ai.cheq.sst.android.core.internal.EventBus
import ai.cheq.sst.android.core.internal.store.DataStoreCollection
import ai.cheq.sst.android.core.internal.store.NoopDataStoreCollection
import ai.cheq.sst.android.core.internal.store.ProtobufDataStoreCollection
import ai.cheq.sst.android.protobuf.storage.Storage
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.CoroutineScope
import java.util.concurrent.CompletableFuture
import kotlin.reflect.KClass

internal class DataStoreStorageCollection<T : Identifiable> private constructor(
    private val type : KClass<T>,
    private val layerConfig: ProtobufDataStoreCollection.Config<Storage, Storage, Storage.Builder>
) : StorageCollection<T> {
    private var dataStoreCollection: DataStoreCollection = NoopDataStoreCollection()

    internal fun configure(
        contextProvider: ConfigurableContextProvider,
        log: Log,
        eventBus: EventBus,
        coroutineScope: CoroutineScope,
        coroutineDispatcher: CoroutineDispatcher
    ) {
        this.dataStoreCollection = ProtobufDataStoreCollection(
            layerConfig, contextProvider, log, eventBus, coroutineScope, coroutineDispatcher
        )
    }

    override fun addAsync(value: T): CompletableFuture<Void?> {
        return dataStoreCollection.addAsync(value.id(), value)
    }

    @JvmSynthetic
    override suspend fun add(value: T) {
        return dataStoreCollection.add(value.id(), value)
    }

    override fun allAsync(): CompletableFuture<Map<String, Any?>> {
        return dataStoreCollection.allAsync()
    }

    @JvmSynthetic
    override suspend fun all(): Map<String, Any?> {
        return dataStoreCollection.all()
    }

    override fun clearAsync(): CompletableFuture<Void?> {
        return dataStoreCollection.clearAsync()
    }

    @JvmSynthetic
    override suspend fun clear() {
        dataStoreCollection.clear()
    }

    override fun containsAsync(key: String): CompletableFuture<Boolean> {
        return dataStoreCollection.containsAsync(key)
    }

    @JvmSynthetic
    override suspend fun contains(key: String): Boolean {
        return dataStoreCollection.contains(key)
    }

    override suspend fun get(key: String): T? {
        return dataStoreCollection.get(key, type.javaObjectType)
    }

    override fun getAsync(key: String): CompletableFuture<T?> {
        return dataStoreCollection.getAsync(key, type.javaObjectType)
    }

    override fun removeAsync(key: String): CompletableFuture<Boolean> {
        return dataStoreCollection.removeAsync(key)
    }

    @JvmSynthetic
    override suspend fun remove(key: String): Boolean {
        return dataStoreCollection.remove(key)
    }

    @JvmSynthetic
    internal suspend fun raw(): List<String> {
        return dataStoreCollection.raw().values.filterNotNull()
    }

    companion object{
        internal inline fun <reified T : Identifiable> create(
            layerConfig: ProtobufDataStoreCollection.Config<Storage, Storage, Storage.Builder>
        ) = DataStoreStorageCollection(T::class, layerConfig)
    }
}