package ai.cheq.sst.android.core.storage

import com.fasterxml.jackson.annotation.JsonAutoDetect
import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonProperty

/**
 * A storage item object represents information stored in local or session storage.
 *
 * @property key The name of the storage item
 * @property value The value of the storage item
 */
@JsonAutoDetect(
    fieldVisibility = JsonAutoDetect.Visibility.NONE,
    setterVisibility = JsonAutoDetect.Visibility.NONE,
    getterVisibility = JsonAutoDetect.Visibility.NONE,
    isGetterVisibility = JsonAutoDetect.Visibility.NONE,
    creatorVisibility = JsonAutoDetect.Visibility.NONE
)
data class Item @JsonCreator constructor(
    @param:JsonProperty("key") @get:JsonProperty("key") val key: String,
    @param:JsonProperty("value") @get:JsonProperty("value") val value: String
): Identifiable {
    override fun id(): String = key
}