/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.service;

import ai.chronon.online.Metrics;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.statsd.StatsdConfig;
import io.micrometer.statsd.StatsdMeterRegistry;
import io.vertx.core.Launcher;
import io.vertx.core.VertxOptions;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.MicrometerMetricsFactory;
import io.vertx.micrometer.MicrometerMetricsOptions;
import java.util.HashMap;
import java.util.Map;

public class ChrononServiceLauncher
extends Launcher {
    public void beforeStartingVertx(VertxOptions vertxOptions) {
        StatsdConfig statsdConfig = new StatsdConfig(){
            private final String statsdHost = Metrics.Context$.MODULE$.statsHost();
            private final String statsdPort = String.valueOf(Metrics.Context$.MODULE$.statsPort());
            final Map<String, String> statsProps = new HashMap<String, String>(){
                {
                    this.put(this.prefix() + ".port", statsdPort);
                    this.put(this.prefix() + ".host", statsdHost);
                    this.put(this.prefix() + ".protocol", Integer.parseInt(statsdPort) == 0 ? "UDS_DATAGRAM" : "UDP");
                }
            };

            public String get(String string) {
                return this.statsProps.get(string);
            }
        };
        StatsdMeterRegistry statsdMeterRegistry = new StatsdMeterRegistry(statsdConfig, Clock.SYSTEM);
        MicrometerMetricsFactory micrometerMetricsFactory = new MicrometerMetricsFactory((MeterRegistry)statsdMeterRegistry);
        MicrometerMetricsOptions micrometerMetricsOptions = new MicrometerMetricsOptions().setEnabled(true).setJvmMetricsEnabled(true).setFactory((VertxMetricsFactory)micrometerMetricsFactory).addLabels(new Label[]{Label.HTTP_METHOD, Label.HTTP_CODE, Label.HTTP_PATH});
        vertxOptions.setMetricsOptions((MetricsOptions)micrometerMetricsOptions);
    }

    public static void main(String[] stringArray) {
        new ChrononServiceLauncher().dispatch(stringArray);
    }
}

