/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.service;

import io.vertx.config.ConfigRetriever;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class ConfigStore {
    private static final int DEFAULT_PORT = 8080;
    private static final String SERVER_PORT = "server.port";
    private static final String ONLINE_JAR = "online.jar";
    private static final String ONLINE_CLASS = "online.class";
    private static final String ONLINE_API_PROPS = "online.api.props";
    private volatile JsonObject jsonConfig;
    private final Object lock = new Object();

    public ConfigStore(Vertx vertx) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        ConfigRetriever configRetriever = ConfigRetriever.create((Vertx)vertx);
        configRetriever.getConfig().onComplete(asyncResult -> {
            if (asyncResult.failed()) {
                throw new IllegalStateException("Unable to load service config", asyncResult.cause());
            }
            Object object = this.lock;
            synchronized (object) {
                this.jsonConfig = (JsonObject)asyncResult.result();
            }
            countDownLatch.countDown();
        });
        try {
            if (!countDownLatch.await(1L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Timed out waiting for Vertx config read");
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted while loading config", interruptedException);
        }
    }

    public int getServerPort() {
        return this.jsonConfig.getInteger(SERVER_PORT, Integer.valueOf(8080));
    }

    public Optional<String> getOnlineJar() {
        return Optional.ofNullable(this.jsonConfig.getString(ONLINE_JAR));
    }

    public Optional<String> getOnlineClass() {
        return Optional.ofNullable(this.jsonConfig.getString(ONLINE_CLASS));
    }

    public Map<String, String> getOnlineApiProps() {
        JsonObject jsonObject = this.jsonConfig.getJsonObject(ONLINE_API_PROPS);
        if (jsonObject == null) {
            return new HashMap<String, String>();
        }
        return jsonObject.stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> String.valueOf(entry.getValue())));
    }

    public String encodeConfig() {
        return this.jsonConfig.encodePrettily();
    }
}

